/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.psu;

import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.repository.jpa.psu.PsuRepository;
import de.adorsys.opba.protocol.facade.config.encryption.impl.psu.PsuSecureStorage;
import de.adorsys.opba.protocol.facade.exceptions.PsuAuthenticationException;
import de.adorsys.opba.protocol.facade.exceptions.PsuAuthorizationException;
import de.adorsys.opba.protocol.facade.exceptions.PsuRegisterException;
import java.beans.ConstructorProperties;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PsuAuthService {
    private final PsuRepository psuRepository;
    private final PsuSecureStorage psuSecureStorage;

    @Transactional
    public Psu tryAuthenticateUser(String login, String password) throws PsuAuthorizationException {
        Optional psu = this.psuRepository.findByLogin(login);
        if (!psu.isPresent()) {
            throw new PsuAuthenticationException("User not found: " + login);
        }
        UserIDAuth idAuth = new UserIDAuth(((Psu)psu.get()).getId().toString(), password::toCharArray);
        this.enableDatasafeAuthentication(idAuth);
        return (Psu)psu.get();
    }

    @Transactional
    public Psu createPsuIfNotExist(String login, String password) {
        Optional psu = this.psuRepository.findByLogin(login);
        if (psu.isPresent()) {
            throw new PsuRegisterException("Psu already exists:" + login);
        }
        Psu newPsu = (Psu)this.psuRepository.save((Object)Psu.builder().login(login).build());
        this.psuSecureStorage.registerPsu(newPsu, password::toCharArray);
        return newPsu;
    }

    private void enableDatasafeAuthentication(UserIDAuth idAuth) throws PsuAuthorizationException {
        try {
            this.psuSecureStorage.userProfile().updateReadKeyPassword(idAuth, idAuth.getReadKeyPassword());
        }
        catch (Exception e) {
            throw new PsuAuthorizationException(e.getMessage(), e);
        }
    }

    @ConstructorProperties(value={"psuRepository", "psuSecureStorage"})
    @Generated
    public PsuAuthService(PsuRepository psuRepository, PsuSecureStorage psuSecureStorage) {
        this.psuRepository = psuRepository;
        this.psuSecureStorage = psuSecureStorage;
    }
}

