/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.fintech.registrar;

import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPrvKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPubKey;
import de.adorsys.opba.db.repository.jpa.fintech.FintechOnlyPubKeyRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechRepository;
import de.adorsys.opba.protocol.facade.config.encryption.FintechOnlyEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.FintechOnlyKeyPairConfig;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import java.beans.ConstructorProperties;
import java.security.KeyPair;
import java.util.UUID;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FintechRegistrar {
    private final EntityManager entityManager;
    private final FintechRepository fintechRepository;
    private final FintechSecureStorage fintechSecureStorage;
    private final FintechOnlyPubKeyRepository pubKeyRepository;
    private final FintechOnlyKeyPairConfig fintechOnlyKeyPairConfig;
    private final FintechOnlyEncryptionServiceProvider fintechOnlyEncryptionServiceProvider;

    @Transactional
    public Fintech registerFintech(String fintechId, Supplier<char[]> finTechPassword) {
        Fintech fintech = (Fintech)this.fintechRepository.save((Object)Fintech.builder().globalId(fintechId).build());
        this.fintechSecureStorage.registerFintech(fintech, finTechPassword);
        for (int i = 0; i < this.fintechOnlyKeyPairConfig.getPairCount(); ++i) {
            UUID id = UUID.randomUUID();
            KeyPair pair = this.fintechOnlyEncryptionServiceProvider.generateKeyPair();
            this.fintechSecureStorage.fintechOnlyPrvKeyToPrivate(id, pair.getPrivate(), fintech, finTechPassword);
            FintechPubKey pubKey = FintechPubKey.builder().prvKey((FintechPrvKey)this.entityManager.find(FintechPrvKey.class, (Object)id)).build();
            pubKey.setKey(pair.getPublic());
            this.pubKeyRepository.save((Object)pubKey);
        }
        return fintech;
    }

    @ConstructorProperties(value={"entityManager", "fintechRepository", "fintechSecureStorage", "pubKeyRepository", "fintechOnlyKeyPairConfig", "fintechOnlyEncryptionServiceProvider"})
    @Generated
    public FintechRegistrar(EntityManager entityManager, FintechRepository fintechRepository, FintechSecureStorage fintechSecureStorage, FintechOnlyPubKeyRepository pubKeyRepository, FintechOnlyKeyPairConfig fintechOnlyKeyPairConfig, FintechOnlyEncryptionServiceProvider fintechOnlyEncryptionServiceProvider) {
        this.entityManager = entityManager;
        this.fintechRepository = fintechRepository;
        this.fintechSecureStorage = fintechSecureStorage;
        this.pubKeyRepository = pubKeyRepository;
        this.fintechOnlyKeyPairConfig = fintechOnlyKeyPairConfig;
        this.fintechOnlyEncryptionServiceProvider = fintechOnlyEncryptionServiceProvider;
    }
}

