/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.fintech;

import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.repository.jpa.fintech.FintechRepository;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.services.fintech.registrar.FintechRegistrar;
import java.beans.ConstructorProperties;
import java.util.function.Supplier;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FintechAuthenticator {
    private final FintechRegistrar fintechRegistrar;
    private final FintechSecureStorage fintechSecureStorage;
    private final FintechRepository fintechRepository;

    @Transactional
    public Fintech authenticateOrCreateFintech(FacadeServiceableRequest request) {
        String fintechId = request.getAuthorization();
        Supplier<char[]> finTechPassword = () -> request.getSessionPassword().toCharArray();
        Fintech fintech = this.fintechRepository.findByGlobalId(fintechId).orElseGet(() -> this.fintechRegistrar.registerFintech(fintechId, finTechPassword));
        this.fintechSecureStorage.validatePassword(fintech, finTechPassword);
        return fintech;
    }

    @ConstructorProperties(value={"fintechRegistrar", "fintechSecureStorage", "fintechRepository"})
    @Generated
    public FintechAuthenticator(FintechRegistrar fintechRegistrar, FintechSecureStorage fintechSecureStorage, FintechRepository fintechRepository) {
        this.fintechRegistrar = fintechRegistrar;
        this.fintechSecureStorage = fintechSecureStorage;
        this.fintechRepository = fintechRepository;
    }
}

