/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.context;

import com.google.common.base.Strings;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.AuthorizationSessionRepository;
import de.adorsys.opba.db.repository.jpa.BankProfileJpaRepository;
import de.adorsys.opba.db.repository.jpa.ServiceSessionRepository;
import de.adorsys.opba.protocol.api.dto.context.Context;
import de.adorsys.opba.protocol.api.dto.context.ServiceContext;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableGetter;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.services.scoped.RequestScoped;
import de.adorsys.opba.protocol.facade.config.encryption.ConsentAuthorizationEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import de.adorsys.opba.protocol.facade.services.InternalContext;
import de.adorsys.opba.protocol.facade.services.context.ServiceContextProvider;
import de.adorsys.opba.protocol.facade.services.fintech.FintechAuthenticator;
import de.adorsys.opba.protocol.facade.services.scoped.RequestScopedProvider;
import java.beans.ConstructorProperties;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="FINTECH_CONTEXT_PROVIDER")
public class ServiceContextProviderForFintech
implements ServiceContextProvider {
    public static final String FINTECH_CONTEXT_PROVIDER = "FINTECH_CONTEXT_PROVIDER";
    protected final AuthorizationSessionRepository authSessions;
    private final FintechAuthenticator authenticator;
    private final BankProfileJpaRepository profileJpaRepository;
    private final ConsentAuthorizationEncryptionServiceProvider consentAuthorizationEncryptionServiceProvider;
    private final RequestScopedProvider provider;
    private final EncryptionKeySerde encryptionKeySerde;
    private final ServiceSessionRepository serviceSessions;

    @Override
    @Transactional
    public <REQUEST extends FacadeServiceableGetter, ACTION> InternalContext<REQUEST, ACTION> provide(REQUEST request) {
        if (null == request.getFacadeServiceable()) {
            throw new IllegalArgumentException("No serviceable body");
        }
        AuthSession authSession = this.extractAndValidateAuthSession(request);
        ServiceSession session = this.extractOrCreateServiceSession(request, authSession);
        return InternalContext.builder().serviceCtx(Context.builder().serviceSessionId(session.getId()).authorizationBankProtocolId(null == authSession ? null : authSession.getAction().getId()).bankId(request.getFacadeServiceable().getBankId()).authSessionId(null == authSession ? null : authSession.getId()).authContext(null == authSession ? null : authSession.getContext()).futureAuthSessionId(session.getId()).futureRedirectCode(UUID.randomUUID()).futureAspspRedirectCode(UUID.randomUUID()).request(request).build()).authSession(authSession).session(session).build();
    }

    public <REQUEST extends FacadeServiceableGetter, ACTION> ServiceContext<REQUEST> provideRequestScoped(REQUEST request, InternalContext<REQUEST, ACTION> ctx) {
        RequestScoped requestScoped = this.getRequestScoped(request, ctx.getSession(), ctx.getAuthSession(), ctx.getServiceCtx().getServiceBankProtocolId());
        return ServiceContext.builder().ctx(ctx.getServiceCtx()).requestScoped(requestScoped).build();
    }

    protected <REQUEST extends FacadeServiceableGetter> void validateRedirectCode(REQUEST request, AuthSession session) {
        if (Strings.isNullOrEmpty((String)request.getFacadeServiceable().getRedirectCode())) {
            throw new IllegalArgumentException("Missing redirect code");
        }
        if (!Objects.equals(session.getRedirectCode(), request.getFacadeServiceable().getRedirectCode())) {
            throw new IllegalArgumentException("Wrong redirect code");
        }
    }

    private <REQUEST extends FacadeServiceableGetter> AuthSession readAndValidateAuthSession(REQUEST request) {
        UUID sessionId = UUID.fromString(request.getFacadeServiceable().getAuthorizationSessionId());
        AuthSession session = (AuthSession)this.authSessions.findById((Object)sessionId).orElseThrow(() -> new IllegalStateException("No auth session " + sessionId));
        this.validateRedirectCode(request, session);
        return session;
    }

    private <REQUEST extends FacadeServiceableGetter> ServiceSession extractOrCreateServiceSession(REQUEST request, AuthSession authSession) {
        if (null != authSession) {
            return authSession.getParent();
        }
        return this.readOrCreateServiceSessionFromRequest(request.getFacadeServiceable());
    }

    private ServiceSession readOrCreateServiceSessionFromRequest(FacadeServiceableRequest facadeServiceable) {
        UUID serviceSessionId = facadeServiceable.getServiceSessionId();
        if (null == serviceSessionId) {
            return this.createServiceSession(UUID.randomUUID(), facadeServiceable);
        }
        return this.serviceSessions.findById((Object)serviceSessionId).orElseGet(() -> this.createServiceSession(serviceSessionId, facadeServiceable));
    }

    @NotNull
    private ServiceSession createServiceSession(UUID serviceSessionId, FacadeServiceableRequest request) {
        ServiceSession serviceSession = new ServiceSession();
        serviceSession.setId(serviceSessionId);
        serviceSession.setBankProfile(this.getBankProfileFromRequest(request));
        return (ServiceSession)this.serviceSessions.save((Object)serviceSession);
    }

    private <REQUEST extends FacadeServiceableGetter> AuthSession extractAndValidateAuthSession(REQUEST request) {
        if (null == request.getFacadeServiceable().getAuthorizationSessionId()) {
            return this.handleNoAuthSession(request);
        }
        return this.readAndValidateAuthSession(request);
    }

    private <REQUEST extends FacadeServiceableGetter> AuthSession handleNoAuthSession(REQUEST request) {
        if (!Strings.isNullOrEmpty((String)request.getFacadeServiceable().getRedirectCode())) {
            throw new IllegalArgumentException("Unexpected redirect code as no auth session is present");
        }
        return null;
    }

    @Nullable
    private <REQUEST extends FacadeServiceableGetter> RequestScoped getRequestScoped(REQUEST request, ServiceSession session, AuthSession authSession, long bankProtocolId) {
        return null == request.getFacadeServiceable().getAuthorizationKey() ? this.fintechFacingSecretKeyBasedEncryption(request, session, bankProtocolId) : this.psuCookieBasedKeyEncryption(request, authSession, bankProtocolId);
    }

    private <REQUEST extends FacadeServiceableGetter> RequestScoped psuCookieBasedKeyEncryption(REQUEST request, AuthSession session, long bankProtocolId) {
        if (null == session) {
            throw new IllegalArgumentException("Missing authorization session");
        }
        return this.provider.registerForPsuSession(session, this.consentAuthorizationEncryptionServiceProvider, bankProtocolId, this.encryptionKeySerde.fromString(request.getFacadeServiceable().getAuthorizationKey()));
    }

    private <REQUEST extends FacadeServiceableGetter> RequestScoped fintechFacingSecretKeyBasedEncryption(REQUEST request, ServiceSession session, long bankProtocolId) {
        BankProfile profile = this.getBankProfileFromRequest(request.getFacadeServiceable());
        Fintech fintech = this.authenticator.authenticateOrCreateFintech(request.getFacadeServiceable());
        return this.provider.registerForFintechSession(fintech, profile, session, bankProtocolId, this.consentAuthorizationEncryptionServiceProvider, this.consentAuthorizationEncryptionServiceProvider.generateKey(), () -> request.getFacadeServiceable().getSessionPassword().toCharArray());
    }

    private BankProfile getBankProfileFromRequest(FacadeServiceableRequest request) {
        return (BankProfile)this.profileJpaRepository.findByBankUuid(request.getBankId()).orElseThrow(() -> new IllegalArgumentException("No bank profile for bank: " + request.getBankId()));
    }

    @ConstructorProperties(value={"authSessions", "authenticator", "profileJpaRepository", "consentAuthorizationEncryptionServiceProvider", "provider", "encryptionKeySerde", "serviceSessions"})
    @Generated
    public ServiceContextProviderForFintech(AuthorizationSessionRepository authSessions, FintechAuthenticator authenticator, BankProfileJpaRepository profileJpaRepository, ConsentAuthorizationEncryptionServiceProvider consentAuthorizationEncryptionServiceProvider, RequestScopedProvider provider, EncryptionKeySerde encryptionKeySerde, ServiceSessionRepository serviceSessions) {
        this.authSessions = authSessions;
        this.authenticator = authenticator;
        this.profileJpaRepository = profileJpaRepository;
        this.consentAuthorizationEncryptionServiceProvider = consentAuthorizationEncryptionServiceProvider;
        this.provider = provider;
        this.encryptionKeySerde = encryptionKeySerde;
        this.serviceSessions = serviceSessions;
    }
}

