/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.authorization.internal.psuauth;

import de.adorsys.opba.db.domain.entity.psu.PsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.psu.PsuAspspPubKey;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.repository.jpa.psu.PsuAspspPubKeyRepository;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechConsentSpecSecureStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.psu.PsuSecureStorage;
import java.beans.ConstructorProperties;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PsuFintechAssociationService {
    private final PsuAspspPubKeyRepository pubKeys;
    private final EntityManager entityManager;
    private final FintechSecureStorage fintechVault;
    private final PsuSecureStorage psuVault;
    private final FintechConsentSpecSecureStorage vault;

    @Transactional
    public void sharePsuAspspSecretKeyWithFintech(String psuPassword, AuthSession session) {
        PrivateKey psuAspspKey = this.psuVault.getOrCreateKeyFromPrivateForAspsp(psuPassword::toCharArray, session, this::storePublicKey);
        this.fintechVault.psuAspspKeyToInbox(session, psuAspspKey);
    }

    @Transactional
    public void shareAnonymousUserSecretKeyWithFintech(String psuPassword, AuthSession session) {
        PrivateKey psuAspspKey = this.psuVault.getOrCreateKeyFromPrivateForAspsp(psuPassword::toCharArray, session, this::storePublicKey);
        this.fintechVault.psuAspspKeyToInbox(session, psuAspspKey);
    }

    @Transactional
    public FintechConsentSpecSecureStorage.FinTechUserInboxData readInboxFromFinTech(AuthSession session, String fintechUserPassword) {
        return this.vault.fromInboxForAuth(session, fintechUserPassword::toCharArray);
    }

    private void storePublicKey(UUID id, PublicKey publicKey) {
        PsuAspspPubKey psuAspspPubKey = PsuAspspPubKey.builder().prvKey((PsuAspspPrvKey)this.entityManager.find(PsuAspspPrvKey.class, (Object)id)).build();
        psuAspspPubKey.setKey(publicKey);
        this.pubKeys.save((Object)psuAspspPubKey);
    }

    @ConstructorProperties(value={"pubKeys", "entityManager", "fintechVault", "psuVault", "vault"})
    @Generated
    public PsuFintechAssociationService(PsuAspspPubKeyRepository pubKeys, EntityManager entityManager, FintechSecureStorage fintechVault, PsuSecureStorage psuVault, FintechConsentSpecSecureStorage vault) {
        this.pubKeys = pubKeys;
        this.entityManager = entityManager;
        this.fintechVault = fintechVault;
        this.psuVault = psuVault;
        this.vault = vault;
    }
}

