/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services.authorization;

import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.repository.jpa.AuthorizationSessionRepository;
import de.adorsys.opba.db.repository.jpa.psu.PsuRepository;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechConsentSpecSecureStorage;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import de.adorsys.opba.protocol.facade.services.authorization.internal.psuauth.PsuFintechAssociationService;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PsuLoginForAisService {
    private final EncryptionKeySerde serde;
    private final PsuRepository psus;
    private final PsuFintechAssociationService associationService;
    private final AuthorizationSessionRepository authRepository;

    @Transactional
    public Outcome loginInPsuScopeAndAssociateAuthSession(String psuLogin, String psuPassword, UUID authorizationId, String authorizationPassword) {
        AuthSession session = (AuthSession)this.authRepository.findById((Object)authorizationId).orElseThrow(() -> new IllegalStateException("Missing authorization session: " + authorizationId));
        session.setPsu((Psu)this.psus.findByLogin(psuLogin).orElseThrow(() -> new IllegalStateException("No PSU found: " + psuLogin)));
        this.associationService.sharePsuAspspSecretKeyWithFintech(psuPassword, session);
        FintechConsentSpecSecureStorage.FinTechUserInboxData association = this.associationService.readInboxFromFinTech(session, authorizationPassword);
        this.authRepository.save((Object)session);
        return new Outcome(this.serde.asString(association.getProtocolKey().asKey()), association.getAfterPsuIdentifiedRedirectTo());
    }

    @Transactional
    public Outcome anonymousPsuAssociateAuthSession(UUID authorizationId, String authorizationPassword) {
        AuthSession session = (AuthSession)this.authRepository.findById((Object)authorizationId).orElseThrow(() -> new IllegalStateException("Missing authorization session: " + authorizationId));
        if (!session.isPsuAnonymous()) {
            throw new IllegalStateException("Session does not support anonymous PSU: " + authorizationId);
        }
        FintechConsentSpecSecureStorage.FinTechUserInboxData inbox = this.associationService.readInboxFromFinTech(session, authorizationPassword);
        this.authRepository.save((Object)session);
        return new Outcome(this.serde.asString(inbox.getProtocolKey().asKey()), inbox.getAfterPsuIdentifiedRedirectTo());
    }

    @ConstructorProperties(value={"serde", "psus", "associationService", "authRepository"})
    @Generated
    public PsuLoginForAisService(EncryptionKeySerde serde, PsuRepository psus, PsuFintechAssociationService associationService, AuthorizationSessionRepository authRepository) {
        this.serde = serde;
        this.psus = psus;
        this.associationService = associationService;
        this.authRepository = authRepository;
    }

    public static class Outcome {
        @NonNull
        private final String key;
        @NonNull
        private final URI redirectLocation;

        @NonNull
        @Generated
        public String getKey() {
            return this.key;
        }

        @NonNull
        @Generated
        public URI getRedirectLocation() {
            return this.redirectLocation;
        }

        @ConstructorProperties(value={"key", "redirectLocation"})
        @Generated
        public Outcome(@NonNull String key, @NonNull URI redirectLocation) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (redirectLocation == null) {
                throw new NullPointerException("redirectLocation is marked non-null but is null");
            }
            this.key = key;
            this.redirectLocation = redirectLocation;
        }
    }
}

