/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services;

import de.adorsys.opba.db.domain.entity.BankAction;
import de.adorsys.opba.db.domain.entity.BankSubAction;
import de.adorsys.opba.db.repository.jpa.BankActionRepository;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import de.adorsys.opba.protocol.facade.services.InternalContext;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProtocolSelector {
    private final BankActionRepository bankActionRepository;

    @Transactional
    public <REQUEST, ACTION> InternalContext<REQUEST, ACTION> selectProtocolFor(InternalContext<REQUEST, ACTION> ctx, ProtocolAction protocolAction, Map<String, ? extends ACTION> actionBeans) {
        Optional bankAction;
        if (null == ctx.getAuthSession()) {
            bankAction = this.bankActionRepository.findByBankProfileUuidAndAction(ctx.getServiceCtx().getBankId(), protocolAction);
        } else {
            Long id = this.isForAuthorization(protocolAction) ? ctx.getServiceCtx().getAuthorizationBankProtocolId() : ctx.getServiceCtx().getServiceBankProtocolId();
            bankAction = this.bankActionRepository.findById((Object)id);
        }
        return bankAction.map(action -> {
            Object actionBean = this.findActionBean((BankAction)action, actionBeans, protocolAction);
            return ctx.toBuilder().serviceCtx(ctx.getServiceCtx().toBuilder().serviceBankProtocolId(action.getId()).build()).action(actionBean).build();
        }).orElseThrow(() -> new IllegalStateException("No action bean for " + protocolAction.name() + " of: " + ctx.getServiceCtx().loggableBankId()));
    }

    private boolean isForAuthorization(ProtocolAction action) {
        return action == ProtocolAction.AUTHORIZATION || ProtocolAction.AUTHORIZATION == action.getParent();
    }

    private <A> A findActionBean(BankAction forProtocol, Map<String, A> actionBeans, ProtocolAction action) {
        return actionBeans.getOrDefault(forProtocol.getProtocolBeanName(), this.findActionBeanFromSubProtocols(forProtocol.getSubProtocols(), actionBeans, action));
    }

    private <A> A findActionBeanFromSubProtocols(Collection<BankSubAction> subProtocols, Map<String, A> actionBeans, ProtocolAction action) {
        Optional<BankSubAction> subProtocol = subProtocols.stream().filter(it -> it.getProtocolAction() == action).findFirst();
        return subProtocol.map(sub -> actionBeans.get(sub.getSubProtocolBeanName())).orElse(null);
    }

    @ConstructorProperties(value={"bankActionRepository"})
    @Generated
    public ProtocolSelector(BankActionRepository bankActionRepository) {
        this.bankActionRepository = bankActionRepository;
    }
}

