/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services;

import com.google.common.base.Strings;
import de.adorsys.opba.api.security.internal.config.TppTokenProperties;
import de.adorsys.opba.api.security.internal.service.TokenBasedAuthService;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.repository.jpa.AuthorizationSessionRepository;
import de.adorsys.opba.db.repository.jpa.ServiceSessionRepository;
import de.adorsys.opba.protocol.api.dto.context.ServiceContext;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableGetter;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.dto.result.body.AuthStateBody;
import de.adorsys.opba.protocol.api.dto.result.body.ReturnableProcessErrorResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.Result;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.AuthorizationDeniedResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.AuthorizationRequiredResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.ConsentAcquiredResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.ConsentIncompatibleResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.RedirectToAspspResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.RedirectionResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.dialog.ValidationErrorResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.error.ErrorResult;
import de.adorsys.opba.protocol.api.dto.result.fromprotocol.ok.SuccessResult;
import de.adorsys.opba.protocol.facade.config.encryption.SecretKeyWithIv;
import de.adorsys.opba.protocol.facade.dto.result.torest.FacadeResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRedirectErrorResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRedirectResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeResultRedirectable;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRuntimeErrorResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeRuntimeErrorResultWithOwnResponseCode;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeStartAuthorizationResult;
import de.adorsys.opba.protocol.facade.dto.result.torest.staticres.FacadeSuccessResult;
import de.adorsys.opba.protocol.facade.services.AuthSessionHandler;
import de.adorsys.opba.protocol.facade.services.scoped.RequestScopedProvider;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProtocolResultHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolResultHandler.class);
    private final RequestScopedProvider provider;
    private final AuthSessionHandler authSessionHandler;
    private final ServiceSessionRepository sessions;
    private final AuthorizationSessionRepository authorizationSessions;
    private final TokenBasedAuthService authService;
    private final TppTokenProperties tppTokenProperties;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleResult(Result<RESULT> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session) {
        SecretKeyWithIv sessionKey = this.provider.deregister(session.getRequestScoped()).getKey();
        return this.doHandleResult(result, request, session, sessionKey);
    }

    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> doHandleResult(Result<RESULT> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session, SecretKeyWithIv sessionKey) {
        if (result instanceof SuccessResult) {
            return this.handleSuccess((SuccessResult)result, request.getRequestId(), session);
        }
        if (result instanceof ConsentAcquiredResult) {
            return this.handleConsentAcquired((ConsentAcquiredResult)result);
        }
        if (result instanceof ErrorResult) {
            return this.handleError((ErrorResult)result, request.getRequestId(), session, request);
        }
        if (result instanceof RedirectionResult) {
            return this.handleRedirect((RedirectionResult)result, request, session, sessionKey);
        }
        if (result instanceof ReturnableProcessErrorResult) {
            return this.handleReturnableError((ReturnableProcessErrorResult)result, request, session);
        }
        throw new IllegalStateException("Can't handle protocol result: " + result.getClass());
    }

    @NotNull
    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleReturnableError(ReturnableProcessErrorResult result, FacadeServiceableRequest request, ServiceContext<REQUEST> session) {
        FacadeRuntimeErrorResultWithOwnResponseCode mappedResult = FacadeRuntimeErrorResultWithOwnResponseCode.ERROR_FROM_PROTOCOL.map(result);
        mappedResult.setServiceSessionId(session.getServiceSessionId().toString());
        mappedResult.setXRequestId(request.getRequestId());
        return mappedResult;
    }

    @NotNull
    protected <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleSuccess(SuccessResult<RESULT> result, UUID xRequestId, ServiceContext<REQUEST> session) {
        FacadeSuccessResult mappedResult = FacadeSuccessResult.FROM_PROTOCOL.map(result);
        mappedResult.setServiceSessionId(session.getServiceSessionId().toString());
        mappedResult.setXRequestId(xRequestId);
        return mappedResult;
    }

    protected <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleError(ErrorResult<RESULT> result, UUID xRequestId, ServiceContext<REQUEST> session, FacadeServiceableRequest request) {
        if (Strings.isNullOrEmpty((String)request.getFintechRedirectUrlNok()) || !result.isCanRedirectBackToFintech()) {
            return this.handleNonRedirectableError(result, xRequestId, session);
        }
        return this.handleRedirectableError(result, xRequestId, session, request);
    }

    protected <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleNonRedirectableError(ErrorResult<RESULT> result, UUID xRequestId, ServiceContext<REQUEST> session) {
        FacadeRuntimeErrorResult mappedResult = FacadeRuntimeErrorResult.ERROR_FROM_PROTOCOL.map(result);
        mappedResult.setServiceSessionId(session.getServiceSessionId().toString());
        mappedResult.setXRequestId(xRequestId);
        return mappedResult;
    }

    protected <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResult<RESULT> handleRedirectableError(ErrorResult<RESULT> result, UUID xRequestId, ServiceContext<REQUEST> session, FacadeServiceableRequest request) {
        FacadeRedirectErrorResult mappedResult = FacadeRedirectErrorResult.ERROR_FROM_PROTOCOL.map(result);
        mappedResult.setServiceSessionId(session.getServiceSessionId().toString());
        mappedResult.setRedirectionTo(URI.create(request.getFintechRedirectUrlNok()));
        mappedResult.setXRequestId(xRequestId);
        this.addAuthorizationSessionDataIfAvailable((Result<REQUEST>)result, request, (ServiceContext<RESULT>)session, mappedResult);
        return mappedResult;
    }

    protected <RESULT> FacadeResult<RESULT> handleConsentAcquired(ConsentAcquiredResult<RESULT, ?> result) {
        FacadeRedirectResult mappedResult = FacadeRedirectResult.FROM_PROTOCOL.map((RedirectionResult)result);
        mappedResult.setRedirectionTo(result.getRedirectionTo());
        return mappedResult;
    }

    protected <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResultRedirectable<RESULT, AuthStateBody> handleRedirect(RedirectionResult<RESULT, ?> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session, SecretKeyWithIv sessionKey) {
        if (result instanceof AuthorizationDeniedResult) {
            return this.doHandleAbortAuthorization(result, request.getRequestId(), session);
        }
        Optional authSession = this.authorizationSessions.findByParentId(session.getServiceSessionId());
        return authSession.map(it -> this.handleExistingAuthSession((AuthSession)it, result, request, session, sessionKey)).orElseGet(() -> this.handleNewAuthSession(result, request, session, sessionKey));
    }

    @NotNull
    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResultRedirectable<RESULT, AuthStateBody> handleExistingAuthSession(AuthSession session, RedirectionResult<RESULT, ?> result, FacadeServiceableRequest request, ServiceContext<REQUEST> context, SecretKeyWithIv sessionKey) {
        if (result instanceof ConsentIncompatibleResult) {
            return this.handleAuthRequiredForExistingAuthSession(result, request, context, sessionKey, session);
        }
        return this.handleExistingAuthSessionForAuthContinuation(result, request, context, session);
    }

    protected <RESULT> FacadeRedirectResult<RESULT, AuthStateBody> doHandleAbortAuthorization(RedirectionResult<RESULT, ?> result, UUID xRequestId, ServiceContext session) {
        FacadeRedirectResult mappedResult = FacadeRedirectResult.FROM_PROTOCOL.map(result);
        if (this.sessions.findById((Object)session.getServiceSessionId()).isPresent()) {
            this.sessions.deleteById((Object)session.getServiceSessionId());
        }
        mappedResult.setCause(this.mapCause(result));
        mappedResult.setXRequestId(xRequestId);
        return mappedResult;
    }

    protected <RESULT> void setAspspRedirectCodeIfRequired(RedirectionResult<RESULT, ?> result, AuthSession session, ServiceContext context) {
        if (result instanceof AuthorizationRequiredResult) {
            session.setAspspRedirectCode(context.getFutureAspspRedirectCode().toString());
        }
    }

    protected <REQUEST, RESULT extends FacadeServiceableGetter> void addAuthorizationSessionDataIfAvailable(Result<REQUEST> result, FacadeServiceableRequest request, ServiceContext<RESULT> session, FacadeResultRedirectable mappedResult) {
        Optional authSession = this.authorizationSessions.findByParentId(session.getServiceSessionId());
        if (!authSession.isPresent()) {
            return;
        }
        this.addAuthorizationSessionData(result, (AuthSession)authSession.get(), request, session, mappedResult);
    }

    protected <RESULT> AuthSession addAuthorizationSessionData(Result<RESULT> result, AuthSession authSession, FacadeServiceableRequest request, ServiceContext session, FacadeResultRedirectable<RESULT, ?> mappedResult) {
        authSession.setRedirectCode(session.getFutureRedirectCode().toString());
        authSession.setContext(result.authContext());
        this.authorizationSessions.save((Object)authSession);
        mappedResult.setAuthorizationSessionId(authSession.getId().toString());
        mappedResult.setServiceSessionId(authSession.getParent().getId().toString());
        mappedResult.setXRequestId(request.getRequestId());
        mappedResult.setRedirectCode(authSession.getRedirectCode());
        return authSession;
    }

    @NotNull
    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResultRedirectable<RESULT, AuthStateBody> handleExistingAuthSessionForAuthContinuation(RedirectionResult<RESULT, ?> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session, AuthSession authSession) {
        FacadeRedirectResult mappedResult = FacadeRedirectResult.FROM_PROTOCOL.map(result);
        if (result instanceof RedirectToAspspResult) {
            this.setAspspRedirectTokenIfRequired(request.getAuthorizationKey(), mappedResult);
        }
        this.addAuthorizationSessionData((Result<RESULT>)result, authSession, request, (ServiceContext)session, mappedResult);
        mappedResult.setCause(this.mapCause(result));
        this.setAspspRedirectCodeIfRequired(result, authSession, session);
        return mappedResult;
    }

    @NotNull
    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResultRedirectable<RESULT, AuthStateBody> handleNewAuthSession(RedirectionResult<RESULT, ?> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session, SecretKeyWithIv sessionKey) {
        FacadeStartAuthorizationResult mappedResult = FacadeStartAuthorizationResult.FROM_PROTOCOL.map(result);
        AuthSession newAuthSession = this.authSessionHandler.createNewAuthSessionAndEnhanceResult(request, sessionKey, session, mappedResult);
        this.addAuthorizationSessionData((Result<RESULT>)result, newAuthSession, request, (ServiceContext)session, mappedResult);
        mappedResult.setCause(this.mapCause(result));
        this.setAspspRedirectCodeIfRequired(result, newAuthSession, session);
        return mappedResult;
    }

    @NotNull
    private <RESULT, REQUEST extends FacadeServiceableGetter> FacadeResultRedirectable<RESULT, AuthStateBody> handleAuthRequiredForExistingAuthSession(RedirectionResult<RESULT, ?> result, FacadeServiceableRequest request, ServiceContext<REQUEST> session, SecretKeyWithIv sessionKey, AuthSession authSession) {
        FacadeStartAuthorizationResult mappedResult = FacadeStartAuthorizationResult.FROM_PROTOCOL.map(result);
        AuthSession updatedSession = this.authSessionHandler.reuseAuthSessionAndEnhanceResult(authSession, sessionKey, session, mappedResult);
        this.addAuthorizationSessionData((Result<RESULT>)result, updatedSession, request, (ServiceContext)session, mappedResult);
        mappedResult.setCause(this.mapCause(result));
        this.setAspspRedirectCodeIfRequired(result, updatedSession, session);
        return mappedResult;
    }

    private void setAspspRedirectTokenIfRequired(String authKey, FacadeRedirectResult mappedResult) {
        if (Strings.isNullOrEmpty((String)authKey)) {
            return;
        }
        String toAspspRedirectToken = this.authService.generateToken(authKey, this.tppTokenProperties.getRedirectTokenValidityDuration());
        mappedResult.setToken(toAspspRedirectToken);
    }

    protected AuthStateBody mapCause(RedirectionResult result) {
        if (result instanceof ValidationErrorResult && null != result.getCause()) {
            return (AuthStateBody)result.getCause();
        }
        return null;
    }

    @ConstructorProperties(value={"provider", "authSessionHandler", "sessions", "authorizationSessions", "authService", "tppTokenProperties"})
    @Generated
    public ProtocolResultHandler(RequestScopedProvider provider, AuthSessionHandler authSessionHandler, ServiceSessionRepository sessions, AuthorizationSessionRepository authorizationSessions, TokenBasedAuthService authService, TppTokenProperties tppTokenProperties) {
        this.provider = provider;
        this.authSessionHandler = authSessionHandler;
        this.sessions = sessions;
        this.authorizationSessions = authorizationSessions;
        this.authService = authService;
        this.tppTokenProperties = tppTokenProperties;
    }
}

