/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.protocol.facade.config.encryption.SecretKeyWithIv;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class EncryptionKeySerde {
    private static final String PKCS_8 = "PKCS#8";
    private final ObjectMapper mapper;

    public String asString(SecretKeyWithIv secretKeyWithIv) {
        return this.mapper.writeValueAsString((Object)new SecretKeyWithIvContainer(secretKeyWithIv));
    }

    public SecretKeyWithIv fromString(String fromString) {
        SecretKeyWithIvContainer container = (SecretKeyWithIvContainer)this.mapper.readValue(fromString, SecretKeyWithIvContainer.class);
        return new SecretKeyWithIv(container.getIv(), new SecretKeySpec(container.getEncoded(), container.getAlgo()));
    }

    public void write(SecretKeyWithIv value, OutputStream os) {
        os.write(this.mapper.writeValueAsBytes((Object)new SecretKeyWithIvContainer(value)));
    }

    public SecretKeyWithIv read(InputStream is) {
        SecretKeyWithIvContainer container = (SecretKeyWithIvContainer)this.mapper.readValue(is, SecretKeyWithIvContainer.class);
        return new SecretKeyWithIv(container.getIv(), new SecretKeySpec(container.getEncoded(), container.getAlgo()));
    }

    public void writePrivateKey(PrivateKey value, OutputStream os) {
        os.write(this.mapper.writeValueAsBytes((Object)new PrivateKeyContainer(value)));
    }

    public PrivateKey readPrivateKey(InputStream is) {
        PrivateKeyContainer container = (PrivateKeyContainer)this.mapper.readValue(is, PrivateKeyContainer.class);
        if (!PKCS_8.equals(container.getFormat())) {
            throw new IllegalArgumentException("Bad key format");
        }
        KeyFactory factory = KeyFactory.getInstance(container.getAlgo());
        return factory.generatePrivate(new PKCS8EncodedKeySpec(container.getEncoded()));
    }

    @ConstructorProperties(value={"mapper"})
    @Generated
    public EncryptionKeySerde(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public static class PrivateKeyContainer {
        private String algo;
        private String format;
        private byte[] encoded;

        public PrivateKeyContainer(PrivateKey key) {
            if (!EncryptionKeySerde.PKCS_8.equals(key.getFormat())) {
                throw new IllegalArgumentException("Bad key format");
            }
            this.algo = key.getAlgorithm();
            this.format = key.getFormat();
            this.encoded = key.getEncoded();
        }

        @Generated
        public String getAlgo() {
            return this.algo;
        }

        @Generated
        public String getFormat() {
            return this.format;
        }

        @Generated
        public byte[] getEncoded() {
            return this.encoded;
        }

        @Generated
        public void setAlgo(String algo) {
            this.algo = algo;
        }

        @Generated
        public void setFormat(String format) {
            this.format = format;
        }

        @Generated
        public void setEncoded(byte[] encoded) {
            this.encoded = encoded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PrivateKeyContainer)) {
                return false;
            }
            PrivateKeyContainer other = (PrivateKeyContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$algo = this.getAlgo();
            String other$algo = other.getAlgo();
            if (this$algo == null ? other$algo != null : !this$algo.equals(other$algo)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            return Arrays.equals(this.getEncoded(), other.getEncoded());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PrivateKeyContainer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $algo = this.getAlgo();
            result = result * 59 + ($algo == null ? 43 : $algo.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            result = result * 59 + Arrays.hashCode(this.getEncoded());
            return result;
        }

        @Generated
        public String toString() {
            return "EncryptionKeySerde.PrivateKeyContainer(algo=" + this.getAlgo() + ", format=" + this.getFormat() + ", encoded=" + Arrays.toString(this.getEncoded()) + ")";
        }

        @Generated
        public PrivateKeyContainer() {
        }

        @ConstructorProperties(value={"algo", "format", "encoded"})
        @Generated
        public PrivateKeyContainer(String algo, String format, byte[] encoded) {
            this.algo = algo;
            this.format = format;
            this.encoded = encoded;
        }
    }

    public static class SecretKeyWithIvContainer {
        private String algo;
        private byte[] encoded;
        private byte[] iv;

        public SecretKeyWithIvContainer(SecretKeyWithIv key) {
            this.algo = key.getSecretKey().getAlgorithm();
            this.encoded = key.getSecretKey().getEncoded();
            this.iv = key.getIv();
        }

        public SecretKeyWithIv asKey() {
            return new SecretKeyWithIv(this.iv, new SecretKeySpec(this.encoded, this.algo));
        }

        @Generated
        public String getAlgo() {
            return this.algo;
        }

        @Generated
        public byte[] getEncoded() {
            return this.encoded;
        }

        @Generated
        public byte[] getIv() {
            return this.iv;
        }

        @Generated
        public void setAlgo(String algo) {
            this.algo = algo;
        }

        @Generated
        public void setEncoded(byte[] encoded) {
            this.encoded = encoded;
        }

        @Generated
        public void setIv(byte[] iv) {
            this.iv = iv;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SecretKeyWithIvContainer)) {
                return false;
            }
            SecretKeyWithIvContainer other = (SecretKeyWithIvContainer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$algo = this.getAlgo();
            String other$algo = other.getAlgo();
            if (this$algo == null ? other$algo != null : !this$algo.equals(other$algo)) {
                return false;
            }
            if (!Arrays.equals(this.getEncoded(), other.getEncoded())) {
                return false;
            }
            return Arrays.equals(this.getIv(), other.getIv());
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SecretKeyWithIvContainer;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $algo = this.getAlgo();
            result = result * 59 + ($algo == null ? 43 : $algo.hashCode());
            result = result * 59 + Arrays.hashCode(this.getEncoded());
            result = result * 59 + Arrays.hashCode(this.getIv());
            return result;
        }

        @Generated
        public String toString() {
            return "EncryptionKeySerde.SecretKeyWithIvContainer(algo=" + this.getAlgo() + ", encoded=" + Arrays.toString(this.getEncoded()) + ", iv=" + Arrays.toString(this.getIv()) + ")";
        }

        @Generated
        public SecretKeyWithIvContainer() {
        }

        @ConstructorProperties(value={"algo", "encoded", "iv"})
        @Generated
        public SecretKeyWithIvContainer(String algo, byte[] encoded, byte[] iv) {
            this.algo = algo;
            this.encoded = encoded;
            this.iv = iv;
        }
    }
}

