/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.services;

import com.google.common.collect.ImmutableMap;
import de.adorsys.opba.db.domain.entity.BankAction;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechUser;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.db.repository.jpa.AuthorizationSessionRepository;
import de.adorsys.opba.db.repository.jpa.BankActionRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechUserRepository;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import de.adorsys.opba.protocol.api.dto.context.ServiceContext;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.dto.request.payments.InitiateSinglePaymentRequest;
import de.adorsys.opba.protocol.facade.config.auth.FacadeAuthConfig;
import de.adorsys.opba.protocol.facade.config.encryption.SecretKeyWithIv;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechConsentSpecSecureStorage;
import de.adorsys.opba.protocol.facade.dto.result.torest.redirectable.FacadeResultRedirectable;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import de.adorsys.opba.protocol.facade.services.password.FintechUserPasswordGenerator;
import java.beans.ConstructorProperties;
import java.util.Map;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class AuthSessionHandler {
    private final FacadeAuthConfig facadeAuthConfig;
    private final BankActionRepository bankActionRepository;
    private final FintechUserPasswordGenerator passwordGenerator;
    private final FintechRepository fintechs;
    private final FintechUserRepository fintechUsers;
    private final FintechConsentSpecSecureStorage fintechUserVault;
    private final AuthorizationSessionRepository authenticationSessions;
    private final EntityManager entityManager;

    @Transactional
    @NotNull
    public <O> AuthSession createNewAuthSessionAndEnhanceResult(FacadeServiceableRequest request, SecretKeyWithIv sessionKey, ServiceContext context, FacadeResultRedirectable<O, ?> result) {
        return this.fillAuthSessionData(request, context, sessionKey, result);
    }

    @Transactional
    @NotNull
    public <O> AuthSession reuseAuthSessionAndEnhanceResult(AuthSession authSession, SecretKeyWithIv sessionKey, ServiceContext context, FacadeResultRedirectable<O, ?> result) {
        return this.fillAuthSessionData(authSession, context, sessionKey, result);
    }

    private <O> AuthSession fillAuthSessionData(FacadeServiceableRequest request, ServiceContext context, SecretKeyWithIv sessionKey, FacadeResultRedirectable<O, ?> result) {
        BankAction authAction = (BankAction)this.bankActionRepository.findByBankProfileUuidAndAction(context.getBankId(), ProtocolAction.AUTHORIZATION).orElseThrow(() -> new IllegalStateException("Missing update authorization handler for " + context.getBankId()));
        Fintech fintech = (Fintech)this.fintechs.findByGlobalId(request.getAuthorization()).orElseThrow(() -> new IllegalStateException("No registered FinTech: " + request.getAuthorization()));
        String newPassword = this.passwordGenerator.generate();
        FintechUser user = (FintechUser)this.fintechUsers.save((Object)FintechUser.builder().psuFintechId(request.getFintechUserId()).fintech(fintech).build());
        this.fintechUserVault.registerFintechUser(user, newPassword::toCharArray);
        AuthSession session = (AuthSession)this.authenticationSessions.save((Object)AuthSession.builder().parent((ServiceSession)this.entityManager.find(ServiceSession.class, (Object)context.getServiceSessionId())).action(authAction).fintechUser(user).psuAnonymous(request.isAnonymousPsuAllowed()).redirectCode(context.getFutureRedirectCode().toString()).build());
        return this.createInboxDataAndUpdateAuthSession(context, sessionKey, result, session, newPassword);
    }

    private <O> AuthSession fillAuthSessionData(AuthSession authSession, ServiceContext context, SecretKeyWithIv sessionKey, FacadeResultRedirectable<O, ?> result) {
        AuthSession session = authSession;
        Fintech fintech = authSession.getFintechUser().getFintech();
        String newPassword = this.passwordGenerator.generate();
        FintechUser oldUser = authSession.getFintechUser();
        this.fintechUsers.delete((Object)oldUser);
        FintechUser user = (FintechUser)this.fintechUsers.save((Object)FintechUser.builder().psuFintechId(oldUser.getPsuFintechId()).fintech(fintech).build());
        this.fintechUserVault.registerFintechUser(user, newPassword::toCharArray);
        session.setFintechUser(user);
        session.setRedirectCode(context.getFutureRedirectCode().toString());
        session = (AuthSession)this.authenticationSessions.save((Object)session);
        return this.createInboxDataAndUpdateAuthSession(context, sessionKey, result, session, newPassword);
    }

    @NotNull
    private <O> AuthSession createInboxDataAndUpdateAuthSession(ServiceContext context, SecretKeyWithIv sessionKey, FacadeResultRedirectable<O, ?> result, AuthSession session, String newPassword) {
        this.fintechUserVault.toInboxForAuth(session, new FintechConsentSpecSecureStorage.FinTechUserInboxData(result.getRedirectionTo(), new EncryptionKeySerde.SecretKeyWithIvContainer(sessionKey), null));
        String url = this.facadeAuthConfig.getRedirect().getConsentLogin().getPage().getForAis();
        if (context.getRequest() instanceof InitiateSinglePaymentRequest) {
            InitiateSinglePaymentRequest request = (InitiateSinglePaymentRequest)context.getRequest();
            url = request.getFacadeServiceable().isAnonymousPsuAllowed() ? this.facadeAuthConfig.getRedirect().getConsentLogin().getPage().getForPisAnonymous() : this.facadeAuthConfig.getRedirect().getConsentLogin().getPage().getForPis();
        }
        result.setRedirectionTo(UriComponentsBuilder.fromHttpUrl((String)url).buildAndExpand((Map)ImmutableMap.of((Object)"fintechUserTempPassword", (Object)newPassword, (Object)"authorizationSessionId", (Object)session.getId())).toUri());
        return session;
    }

    @ConstructorProperties(value={"facadeAuthConfig", "bankActionRepository", "passwordGenerator", "fintechs", "fintechUsers", "fintechUserVault", "authenticationSessions", "entityManager"})
    @Generated
    public AuthSessionHandler(FacadeAuthConfig facadeAuthConfig, BankActionRepository bankActionRepository, FintechUserPasswordGenerator passwordGenerator, FintechRepository fintechs, FintechUserRepository fintechUsers, FintechConsentSpecSecureStorage fintechUserVault, AuthorizationSessionRepository authenticationSessions, EntityManager entityManager) {
        this.facadeAuthConfig = facadeAuthConfig;
        this.bankActionRepository = bankActionRepository;
        this.passwordGenerator = passwordGenerator;
        this.fintechs = fintechs;
        this.fintechUsers = fintechUsers;
        this.fintechUserVault = fintechUserVault;
        this.authenticationSessions = authenticationSessions;
        this.entityManager = entityManager;
    }
}

