/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl.psu;

import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import de.adorsys.opba.protocol.facade.config.encryption.impl.PairIdPsuAspspTuple;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;

public class PsuSecureStorage {
    private final DefaultDatasafeServices datasafeServices;
    private final DFSConfig config;
    private final PsuEncryptionServiceProvider encryptionServiceProvider;
    private final EncryptionKeySerde serde;

    public void registerPsu(Psu psu, Supplier<char[]> password) {
        this.userProfile().createDocumentKeystore(psu.getUserIdAuth(password), this.config.defaultPrivateTemplate(psu.getUserIdAuth(password)).buildPrivateProfile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey getOrCreateKeyFromPrivateForAspsp(Supplier<char[]> password, AuthSession session, BiConsumer<UUID, PublicKey> storePublicKeyIfNeeded) {
        try (PasswordClearingInputStream is = this.datasafeServices.privateService().read(ReadRequest.forDefaultPrivate((Object)session.getPsu().getUserIdAuth(password), (String)new PairIdPsuAspspTuple(session).toDatasafePathWithoutPsuAndId()));){
            PrivateKey privateKey = this.serde.readPrivateKey((InputStream)is);
            return privateKey;
        }
        catch (BaseDatasafeDbStorageService.DbStorageEntityNotFoundException ex) {
            return this.generateAndSaveAspspSecretKey(password, session, storePublicKeyIfNeeded);
        }
    }

    public PrivateKey createOneTimePrivateKey(Supplier<char[]> password, AuthSession session, BiConsumer<UUID, PublicKey> storePublicKeyIfNeeded) {
        return this.generateAndSaveAspspSecretKey(password, session, storePublicKeyIfNeeded);
    }

    private PrivateKey generateAndSaveAspspSecretKey(Supplier<char[]> password, AuthSession session, BiConsumer<UUID, PublicKey> storePublicKeyIfNeeded) {
        UUID keyId = UUID.randomUUID();
        KeyPair key = this.encryptionServiceProvider.generateKeyPair();
        try (PasswordClearingOutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)session.getPsu().getUserIdAuth(password), (String)new PairIdPsuAspspTuple(keyId, session).toDatasafePathWithoutPsu()));){
            this.serde.writePrivateKey(key.getPrivate(), (OutputStream)os);
        }
        storePublicKeyIfNeeded.accept(keyId, key.getPublic());
        return key.getPrivate();
    }

    @ConstructorProperties(value={"datasafeServices", "config", "encryptionServiceProvider", "serde"})
    @Generated
    public PsuSecureStorage(DefaultDatasafeServices datasafeServices, DFSConfig config, PsuEncryptionServiceProvider encryptionServiceProvider, EncryptionKeySerde serde) {
        this.datasafeServices = datasafeServices;
        this.config = config;
        this.encryptionServiceProvider = encryptionServiceProvider;
        this.serde = serde;
    }

    @Generated
    public PrivateSpaceService privateService() {
        return this.datasafeServices.privateService();
    }

    @Generated
    public InboxService inboxService() {
        return this.datasafeServices.inboxService();
    }

    @Generated
    public ProfileOperations userProfile() {
        return this.datasafeServices.userProfile();
    }
}

