/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl.psu;

import com.google.common.collect.ImmutableMap;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.psu.PsuAspspPrvKey;
import de.adorsys.opba.db.repository.jpa.psu.PsuAspspPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.psu.PsuRepository;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.DatasafeDataStorage;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.DatasafeMetadataStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.PairIdPsuAspspTuple;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionOperations;

@Component
public class PsuDatasafeStorage
extends BaseDatasafeDbStorageService {
    public PsuDatasafeStorage(DatasafeDataStorage<PsuAspspPrvKey> datasafePrivate, PsuKeystoreStorage datasafeKeystore, PsuPubKeysStorage datasafePubKeys) {
        super((Map<String, BaseDatasafeDbStorageService.StorageActions>)ImmutableMap.builder().put((Object)PsuDatasafeStorage.tableId("db://storage/"), datasafePrivate).put((Object)PsuDatasafeStorage.tableId("db://keystore/"), (Object)datasafeKeystore).put((Object)PsuDatasafeStorage.tableId("db://pubkeys/"), (Object)datasafePubKeys).build());
    }

    private static String tableId(String value) {
        return URI.create(value).getHost();
    }

    @Component
    public static class PsuPubKeysStorage
    extends DatasafeMetadataStorage<Psu> {
        public PsuPubKeysStorage(PsuRepository psus) {
            super(psus, Psu::getPubKeys, Psu::setPubKeys);
        }
    }

    @Component
    public static class PsuKeystoreStorage
    extends DatasafeMetadataStorage<Psu> {
        public PsuKeystoreStorage(PsuRepository psus) {
            super(psus, Psu::getKeystore, Psu::setKeystore);
        }
    }

    @Component
    public static class PsuAspspPrvKeyStorage
    extends DatasafeDataStorage<PsuAspspPrvKey> {
        public PsuAspspPrvKeyStorage(PsuAspspPrvKeyRepository privateKeys, EntityManager em, TransactionOperations txOper) {
            super(privateKeys, path -> PairIdPsuAspspTuple.buildPrvKey(path, em), path -> PsuAspspPrvKeyStorage.find(privateKeys, path), PsuAspspPrvKey::getEncData, PsuAspspPrvKey::setEncData, txOper);
        }

        private static Optional<PsuAspspPrvKey> find(PsuAspspPrvKeyRepository consents, String path) {
            PairIdPsuAspspTuple psuAspspTuple = new PairIdPsuAspspTuple(path);
            return consents.findByPsuIdAndAspspId(psuAspspTuple.getPsuId(), psuAspspTuple.getAspspId());
        }
    }
}

