/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl.fintech;

import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import de.adorsys.opba.protocol.facade.config.encryption.impl.FintechPsuAspspTuple;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechDatasafeStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechOnlyPrvKeyTuple;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.util.UUID;
import java.util.function.Supplier;
import lombok.Generated;

public class FintechSecureStorage {
    private final DefaultDatasafeServices datasafeServices;
    private final DFSConfig config;
    private final EncryptionKeySerde serde;

    public void registerFintech(Fintech fintech, Supplier<char[]> password) {
        this.userProfile().createDocumentKeystore(fintech.getUserIdAuth(password), this.config.defaultPrivateTemplate(fintech.getUserIdAuth(password)).buildPrivateProfile());
    }

    public void validatePassword(Fintech fintech, Supplier<char[]> password) {
        this.userProfile().updateReadKeyPassword(fintech.getUserIdAuth(password), fintech.getUserIdAuth(password).getReadKeyPassword());
    }

    public void psuAspspKeyToInbox(AuthSession authSession, PrivateKey psuAspspKey) {
        try (OutputStream os = this.datasafeServices.inboxService().write(WriteRequest.forDefaultPublic((Object)ImmutableSet.of((Object)authSession.getFintechUser().getFintech().getUserId()), (String)new FintechPsuAspspTuple(authSession).toDatasafePathWithoutParent()));){
            this.serde.writePrivateKey(psuAspspKey, os);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey psuAspspKeyFromInbox(AuthSession authSession, Supplier<char[]> password) {
        try (InputStream is = this.datasafeServices.inboxService().read(ReadRequest.forDefaultPrivate((Object)authSession.getFintechUser().getFintech().getUserIdAuth(password), (String)new FintechPsuAspspTuple(authSession).toDatasafePathWithoutParent()));){
            PrivateKey privateKey = this.serde.readPrivateKey(is);
            return privateKey;
        }
    }

    public void psuAspspKeyToPrivate(AuthSession authSession, Fintech fintech, PrivateKey psuAspspKey, Supplier<char[]> password) {
        try (PasswordClearingOutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)fintech.getUserIdAuth(password), (String)new FintechPsuAspspTuple(authSession).toDatasafePathWithoutParent()));){
            this.serde.writePrivateKey(psuAspspKey, (OutputStream)os);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey psuAspspKeyFromPrivate(ServiceSession session, Fintech fintech, Supplier<char[]> password) {
        try (PasswordClearingInputStream is = this.datasafeServices.privateService().read(ReadRequest.forDefaultPrivate((Object)fintech.getUserIdAuth(password), (String)new FintechPsuAspspTuple(session).toDatasafePathWithoutParent()));){
            PrivateKey privateKey = this.serde.readPrivateKey((InputStream)is);
            return privateKey;
        }
    }

    public void fintechOnlyPrvKeyToPrivate(UUID id, PrivateKey prvKey, Fintech fintech, Supplier<char[]> password) {
        try (PasswordClearingOutputStream os = this.datasafeServices.privateService().write(WriteRequest.forPrivate((Object)fintech.getUserIdAuth(password), (StorageIdentifier)FintechDatasafeStorage.FINTECH_ONLY_KEYS_ID, (String)new FintechOnlyPrvKeyTuple(fintech.getId(), id).toDatasafePathWithoutParent()));){
            this.serde.writePrivateKey(prvKey, (OutputStream)os);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivateKey fintechOnlyPrvKeyFromPrivate(FintechPrvKey prvKey, Fintech fintech, Supplier<char[]> password) {
        try (PasswordClearingInputStream is = this.datasafeServices.privateService().read(ReadRequest.forPrivate((Object)fintech.getUserIdAuth(password), (StorageIdentifier)FintechDatasafeStorage.FINTECH_ONLY_KEYS_ID, (String)new FintechOnlyPrvKeyTuple(fintech.getId(), prvKey.getId()).toDatasafePathWithoutParent()));){
            PrivateKey privateKey = this.serde.readPrivateKey((InputStream)is);
            return privateKey;
        }
    }

    @ConstructorProperties(value={"datasafeServices", "config", "serde"})
    @Generated
    public FintechSecureStorage(DefaultDatasafeServices datasafeServices, DFSConfig config, EncryptionKeySerde serde) {
        this.datasafeServices = datasafeServices;
        this.config = config;
        this.serde = serde;
    }

    @Generated
    public PrivateSpaceService privateService() {
        return this.datasafeServices.privateService();
    }

    @Generated
    public InboxService inboxService() {
        return this.datasafeServices.inboxService();
    }

    @Generated
    public ProfileOperations userProfile() {
        return this.datasafeServices.userProfile();
    }
}

