/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl.fintech;

import com.google.common.collect.ImmutableMap;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPrvKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKeyInbox;
import de.adorsys.opba.db.repository.jpa.fintech.FintechOnlyPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyInboxRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechRepository;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.DatasafeDataStorage;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.DatasafeMetadataStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.FintechPsuAspspTuple;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechOnlyPrvKeyTuple;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionOperations;

@Component
public class FintechDatasafeStorage
extends BaseDatasafeDbStorageService {
    public static final String FINTECH_ONLY_PRV_KEYS_TABLE = "private-keys";
    public static final StorageIdentifier FINTECH_ONLY_KEYS_ID = new StorageIdentifier("private-keys");
    public static final String FINTECH_ONLY_PRV_KEYS = "db://private-keys/";

    public FintechDatasafeStorage(DatasafeDataStorage<FintechPrvKey> fintechOnlyPrvKeys, DatasafeDataStorage<FintechPsuAspspPrvKey> datasafePrivate, DatasafeDataStorage<FintechPsuAspspPrvKeyInbox> datasafeInbox, FintechKeystoreStorage datasafeKeystore, FintechPubKeysStorage datasafePub) {
        super((Map<String, BaseDatasafeDbStorageService.StorageActions>)ImmutableMap.builder().put((Object)FINTECH_ONLY_PRV_KEYS_TABLE, fintechOnlyPrvKeys).put((Object)FintechDatasafeStorage.tableId("db://storage/"), datasafePrivate).put((Object)FintechDatasafeStorage.tableId("db://inbox/"), datasafeInbox).put((Object)FintechDatasafeStorage.tableId("db://keystore/"), (Object)datasafeKeystore).put((Object)FintechDatasafeStorage.tableId("db://pubkeys/"), (Object)datasafePub).build());
    }

    private static String tableId(String value) {
        return URI.create(value).getHost();
    }

    @Component
    public static class FintechPubKeysStorage
    extends DatasafeMetadataStorage<Fintech> {
        public FintechPubKeysStorage(FintechRepository fintechs) {
            super(fintechs, Fintech::getPubKeys, Fintech::setPubKeys);
        }
    }

    @Component
    public static class FintechKeystoreStorage
    extends DatasafeMetadataStorage<Fintech> {
        public FintechKeystoreStorage(FintechRepository fintechs) {
            super(fintechs, Fintech::getKeystore, Fintech::setKeystore);
        }
    }

    @Component
    public static class FintechPsuAspspPrvKeyInboxStorage
    extends DatasafeDataStorage<FintechPsuAspspPrvKeyInbox> {
        public FintechPsuAspspPrvKeyInboxStorage(FintechPsuAspspPrvKeyInboxRepository inboxPsuAspspKeysForConsentOrPayment, TransactionOperations txOper, EntityManager em) {
            super(inboxPsuAspspKeysForConsentOrPayment, path -> FintechPsuAspspTuple.buildFintechInboxPrvKey(path, em), path -> FintechPsuAspspPrvKeyInboxStorage.find(inboxPsuAspspKeysForConsentOrPayment, path), FintechPsuAspspKey::getEncData, FintechPsuAspspKey::setEncData, txOper);
        }

        private static Optional<FintechPsuAspspPrvKeyInbox> find(FintechPsuAspspPrvKeyInboxRepository consents, String path) {
            FintechPsuAspspTuple psuAspspTuple = new FintechPsuAspspTuple(path);
            return consents.findByFintechIdAndPsuIdAndAspspId(psuAspspTuple.getFintechId(), psuAspspTuple.getPsuId(), psuAspspTuple.getAspspId());
        }
    }

    @Component
    public static class FintechPsuAspspPrvKeyStorage
    extends DatasafeDataStorage<FintechPsuAspspPrvKey> {
        public FintechPsuAspspPrvKeyStorage(FintechPsuAspspPrvKeyRepository psuAspspKeysForConsentOrPayment, TransactionOperations txOper, EntityManager em) {
            super(psuAspspKeysForConsentOrPayment, path -> FintechPsuAspspTuple.buildFintechPrvKey(path, em), path -> FintechPsuAspspPrvKeyStorage.find(psuAspspKeysForConsentOrPayment, path), FintechPsuAspspKey::getEncData, FintechPsuAspspKey::setEncData, txOper);
        }

        private static Optional<FintechPsuAspspPrvKey> find(FintechPsuAspspPrvKeyRepository consents, String path) {
            FintechPsuAspspTuple psuAspspTuple = new FintechPsuAspspTuple(path);
            return consents.findByFintechIdAndPsuIdAndAspspId(psuAspspTuple.getFintechId(), psuAspspTuple.getPsuId(), psuAspspTuple.getAspspId());
        }
    }

    @Component
    public static class FintechOnlyPrvKeyStorage
    extends DatasafeDataStorage<FintechPrvKey> {
        public FintechOnlyPrvKeyStorage(FintechOnlyPrvKeyRepository keys, TransactionOperations txOper, EntityManager em) {
            super(keys, path -> FintechOnlyPrvKeyTuple.buildFintechPrvKey(path, em), path -> FintechOnlyPrvKeyStorage.find(keys, path), FintechPrvKey::getEncData, FintechPrvKey::setEncData, txOper);
        }

        private static Optional<FintechPrvKey> find(FintechOnlyPrvKeyRepository keys, String path) {
            FintechOnlyPrvKeyTuple psuAspspTuple = new FintechOnlyPrvKeyTuple(path);
            return keys.findByIdAndFintechId(psuAspspTuple.getKeyId(), psuAspspTuple.getFintechId());
        }
    }
}

