/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl.fintech;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileOperations;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.opba.db.domain.entity.fintech.FintechUser;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.protocol.facade.config.encryption.impl.FintechUserAuthSessionTuple;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;

public class FintechConsentSpecSecureStorage {
    private final DefaultDatasafeServices datasafeServices;
    private final DFSConfig config;
    private final ObjectMapper mapper;

    public void registerFintechUser(FintechUser user, Supplier<char[]> password) {
        this.userProfile().createDocumentKeystore(user.getUserIdAuth(password), this.config.defaultPrivateTemplate(user.getUserIdAuth(password)).buildPrivateProfile());
    }

    public void toInboxForAuth(AuthSession authSession, FinTechUserInboxData data) {
        try (OutputStream os = this.datasafeServices.inboxService().write(WriteRequest.forDefaultPublic((Object)ImmutableSet.of((Object)authSession.getFintechUser().getUserId()), (String)new FintechUserAuthSessionTuple(authSession).toDatasafePathWithoutParent()));){
            os.write(this.mapper.writeValueAsBytes((Object)data));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FinTechUserInboxData fromInboxForAuth(AuthSession authSession, Supplier<char[]> password) {
        try (InputStream is = this.datasafeServices.inboxService().read(ReadRequest.forDefaultPrivate((Object)authSession.getFintechUser().getUserIdAuth(password), (String)new FintechUserAuthSessionTuple(authSession).toDatasafePathWithoutParent()));){
            FinTechUserInboxData finTechUserInboxData = (FinTechUserInboxData)this.mapper.readValue(is, FinTechUserInboxData.class);
            return finTechUserInboxData;
        }
    }

    @ConstructorProperties(value={"datasafeServices", "config", "mapper"})
    @Generated
    public FintechConsentSpecSecureStorage(DefaultDatasafeServices datasafeServices, DFSConfig config, ObjectMapper mapper) {
        this.datasafeServices = datasafeServices;
        this.config = config;
        this.mapper = mapper;
    }

    @Generated
    public PrivateSpaceService privateService() {
        return this.datasafeServices.privateService();
    }

    @Generated
    public InboxService inboxService() {
        return this.datasafeServices.inboxService();
    }

    @Generated
    public ProfileOperations userProfile() {
        return this.datasafeServices.userProfile();
    }

    public static class FinTechUserInboxData {
        @NonNull
        private URI afterPsuIdentifiedRedirectTo;
        @NonNull
        private EncryptionKeySerde.SecretKeyWithIvContainer protocolKey;
        private Object requirements;

        @NonNull
        @Generated
        public URI getAfterPsuIdentifiedRedirectTo() {
            return this.afterPsuIdentifiedRedirectTo;
        }

        @NonNull
        @Generated
        public EncryptionKeySerde.SecretKeyWithIvContainer getProtocolKey() {
            return this.protocolKey;
        }

        @Generated
        public Object getRequirements() {
            return this.requirements;
        }

        @Generated
        public void setAfterPsuIdentifiedRedirectTo(@NonNull URI afterPsuIdentifiedRedirectTo) {
            if (afterPsuIdentifiedRedirectTo == null) {
                throw new NullPointerException("afterPsuIdentifiedRedirectTo is marked non-null but is null");
            }
            this.afterPsuIdentifiedRedirectTo = afterPsuIdentifiedRedirectTo;
        }

        @Generated
        public void setProtocolKey(@NonNull EncryptionKeySerde.SecretKeyWithIvContainer protocolKey) {
            if (protocolKey == null) {
                throw new NullPointerException("protocolKey is marked non-null but is null");
            }
            this.protocolKey = protocolKey;
        }

        @Generated
        public void setRequirements(Object requirements) {
            this.requirements = requirements;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinTechUserInboxData)) {
                return false;
            }
            FinTechUserInboxData other = (FinTechUserInboxData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            URI this$afterPsuIdentifiedRedirectTo = this.getAfterPsuIdentifiedRedirectTo();
            URI other$afterPsuIdentifiedRedirectTo = other.getAfterPsuIdentifiedRedirectTo();
            if (this$afterPsuIdentifiedRedirectTo == null ? other$afterPsuIdentifiedRedirectTo != null : !((Object)this$afterPsuIdentifiedRedirectTo).equals(other$afterPsuIdentifiedRedirectTo)) {
                return false;
            }
            EncryptionKeySerde.SecretKeyWithIvContainer this$protocolKey = this.getProtocolKey();
            EncryptionKeySerde.SecretKeyWithIvContainer other$protocolKey = other.getProtocolKey();
            if (this$protocolKey == null ? other$protocolKey != null : !((Object)this$protocolKey).equals(other$protocolKey)) {
                return false;
            }
            Object this$requirements = this.getRequirements();
            Object other$requirements = other.getRequirements();
            return !(this$requirements == null ? other$requirements != null : !this$requirements.equals(other$requirements));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FinTechUserInboxData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            URI $afterPsuIdentifiedRedirectTo = this.getAfterPsuIdentifiedRedirectTo();
            result = result * 59 + ($afterPsuIdentifiedRedirectTo == null ? 43 : ((Object)$afterPsuIdentifiedRedirectTo).hashCode());
            EncryptionKeySerde.SecretKeyWithIvContainer $protocolKey = this.getProtocolKey();
            result = result * 59 + ($protocolKey == null ? 43 : ((Object)$protocolKey).hashCode());
            Object $requirements = this.getRequirements();
            result = result * 59 + ($requirements == null ? 43 : $requirements.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "FintechConsentSpecSecureStorage.FinTechUserInboxData(afterPsuIdentifiedRedirectTo=" + this.getAfterPsuIdentifiedRedirectTo() + ", protocolKey=" + this.getProtocolKey() + ", requirements=" + this.getRequirements() + ")";
        }

        @Generated
        public FinTechUserInboxData() {
        }

        @ConstructorProperties(value={"afterPsuIdentifiedRedirectTo", "protocolKey", "requirements"})
        @Generated
        public FinTechUserInboxData(@NonNull URI afterPsuIdentifiedRedirectTo, @NonNull EncryptionKeySerde.SecretKeyWithIvContainer protocolKey, Object requirements) {
            if (afterPsuIdentifiedRedirectTo == null) {
                throw new NullPointerException("afterPsuIdentifiedRedirectTo is marked non-null but is null");
            }
            if (protocolKey == null) {
                throw new NullPointerException("protocolKey is marked non-null but is null");
            }
            this.afterPsuIdentifiedRedirectTo = afterPsuIdentifiedRedirectTo;
            this.protocolKey = protocolKey;
            this.requirements = requirements;
        }
    }
}

