/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.psu.PsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;

public class PairIdPsuAspspTuple {
    private final UUID pairId;
    private final long psuId;
    private final long aspspId;

    public PairIdPsuAspspTuple(String path) {
        String[] segments = path.split("/");
        if (segments.length == 3) {
            this.psuId = Long.parseLong(segments[0]);
            this.pairId = UUID.fromString(segments[1]);
            this.aspspId = Long.parseLong(segments[2]);
            return;
        }
        this.pairId = null;
        this.psuId = Long.parseLong(segments[0]);
        this.aspspId = Long.parseLong(segments[1]);
    }

    public PairIdPsuAspspTuple(UUID pairId, AuthSession session) {
        this.pairId = pairId;
        this.psuId = session.getPsu().getId();
        this.aspspId = session.getAction().getBankProfile().getBank().getId();
    }

    public PairIdPsuAspspTuple(AuthSession session) {
        this.pairId = null;
        this.psuId = session.getPsu().getId();
        this.aspspId = session.getAction().getBankProfile().getBank().getId();
    }

    public String toDatasafePathWithoutPsuAndId() {
        if (null != this.pairId) {
            throw new IllegalArgumentException("Unexpected pair id");
        }
        return String.valueOf(this.aspspId);
    }

    public String toDatasafePathWithoutPsu() {
        return this.pairId.toString() + "/" + this.aspspId;
    }

    public static PsuAspspPrvKey buildPrvKey(String path, EntityManager em) {
        PairIdPsuAspspTuple tuple = new PairIdPsuAspspTuple(path);
        if (null == tuple.getPairId()) {
            throw new IllegalArgumentException("Pair id missing");
        }
        return PsuAspspPrvKey.builder().id(tuple.getPairId()).psu((Psu)em.find(Psu.class, (Object)tuple.getPsuId())).aspsp((Bank)em.find(Bank.class, (Object)tuple.getAspspId())).build();
    }

    @Generated
    public UUID getPairId() {
        return this.pairId;
    }

    @Generated
    public long getPsuId() {
        return this.psuId;
    }

    @Generated
    public long getAspspId() {
        return this.aspspId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PairIdPsuAspspTuple)) {
            return false;
        }
        PairIdPsuAspspTuple other = (PairIdPsuAspspTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$pairId = this.getPairId();
        UUID other$pairId = other.getPairId();
        if (this$pairId == null ? other$pairId != null : !((Object)this$pairId).equals(other$pairId)) {
            return false;
        }
        if (this.getPsuId() != other.getPsuId()) {
            return false;
        }
        return this.getAspspId() == other.getAspspId();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PairIdPsuAspspTuple;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $pairId = this.getPairId();
        result = result * 59 + ($pairId == null ? 43 : ((Object)$pairId).hashCode());
        long $psuId = this.getPsuId();
        result = result * 59 + (int)($psuId >>> 32 ^ $psuId);
        long $aspspId = this.getAspspId();
        result = result * 59 + (int)($aspspId >>> 32 ^ $aspspId);
        return result;
    }

    @Generated
    public String toString() {
        return "PairIdPsuAspspTuple(pairId=" + this.getPairId() + ", psuId=" + this.getPsuId() + ", aspspId=" + this.getAspspId() + ")";
    }
}

