/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl;

import de.adorsys.opba.db.domain.entity.fintech.FintechConsentSpec;
import de.adorsys.opba.db.domain.entity.fintech.FintechUser;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;

public class FintechUserAuthSessionTuple {
    private final long fintechUserId;
    private final UUID authSessionId;

    public FintechUserAuthSessionTuple(String id) {
        String[] segments = id.split("/");
        this.fintechUserId = Long.parseLong(segments[0]);
        this.authSessionId = UUID.fromString(segments[1]);
    }

    public FintechUserAuthSessionTuple(AuthSession session) {
        this.fintechUserId = session.getFintechUser().getId();
        this.authSessionId = session.getId();
    }

    public String toDatasafePathWithoutParent() {
        return this.authSessionId.toString();
    }

    public static FintechConsentSpec buildFintechConsentSpec(String path, EntityManager em) {
        FintechUserAuthSessionTuple tuple = new FintechUserAuthSessionTuple(path);
        return FintechConsentSpec.builder().id(tuple.getAuthSessionId()).user((FintechUser)em.find(FintechUser.class, (Object)tuple.getFintechUserId())).build();
    }

    @Generated
    public long getFintechUserId() {
        return this.fintechUserId;
    }

    @Generated
    public UUID getAuthSessionId() {
        return this.authSessionId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FintechUserAuthSessionTuple)) {
            return false;
        }
        FintechUserAuthSessionTuple other = (FintechUserAuthSessionTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFintechUserId() != other.getFintechUserId()) {
            return false;
        }
        UUID this$authSessionId = this.getAuthSessionId();
        UUID other$authSessionId = other.getAuthSessionId();
        return !(this$authSessionId == null ? other$authSessionId != null : !((Object)this$authSessionId).equals(other$authSessionId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FintechUserAuthSessionTuple;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fintechUserId = this.getFintechUserId();
        result = result * 59 + (int)($fintechUserId >>> 32 ^ $fintechUserId);
        UUID $authSessionId = this.getAuthSessionId();
        result = result * 59 + ($authSessionId == null ? 43 : ((Object)$authSessionId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FintechUserAuthSessionTuple(fintechUserId=" + this.getFintechUserId() + ", authSessionId=" + this.getAuthSessionId() + ")";
    }
}

