/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.impl;

import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.fintech.Fintech;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKey;
import de.adorsys.opba.db.domain.entity.fintech.FintechPsuAspspPrvKeyInbox;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.db.domain.entity.sessions.ServiceSession;
import javax.persistence.EntityManager;
import lombok.Generated;

public class FintechPsuAspspTuple {
    private final long fintechId;
    private final long psuId;
    private final long aspspId;

    public FintechPsuAspspTuple(String path) {
        String[] segments = path.split("/");
        this.fintechId = Long.parseLong(segments[0]);
        this.psuId = Long.parseLong(segments[1]);
        this.aspspId = Long.parseLong(segments[2]);
    }

    public FintechPsuAspspTuple(AuthSession session) {
        this.fintechId = session.getFintechUser().getFintech().getId();
        this.psuId = session.getPsu().getId();
        this.aspspId = session.getAction().getBankProfile().getBank().getId();
    }

    public FintechPsuAspspTuple(ServiceSession session) {
        this.fintechId = session.getAuthSession().getFintechUser().getFintech().getId();
        this.psuId = session.getAuthSession().getPsu().getId();
        this.aspspId = session.getBankProfile().getBank().getId();
    }

    public String toDatasafePathWithoutParent() {
        return this.psuId + "/" + this.aspspId;
    }

    public static FintechPsuAspspPrvKey buildFintechPrvKey(String path, EntityManager em) {
        FintechPsuAspspTuple tuple = new FintechPsuAspspTuple(path);
        return ((FintechPsuAspspPrvKey.FintechPsuAspspPrvKeyBuilder)((FintechPsuAspspPrvKey.FintechPsuAspspPrvKeyBuilder)((FintechPsuAspspPrvKey.FintechPsuAspspPrvKeyBuilder)FintechPsuAspspPrvKey.builder().fintech((Fintech)em.find(Fintech.class, (Object)tuple.getFintechId()))).psu((Psu)em.find(Psu.class, (Object)tuple.getPsuId()))).aspsp((Bank)em.find(Bank.class, (Object)tuple.getAspspId()))).build();
    }

    public static FintechPsuAspspPrvKeyInbox buildFintechInboxPrvKey(String path, EntityManager em) {
        FintechPsuAspspTuple tuple = new FintechPsuAspspTuple(path);
        return ((FintechPsuAspspPrvKeyInbox.FintechPsuAspspPrvKeyInboxBuilder)((FintechPsuAspspPrvKeyInbox.FintechPsuAspspPrvKeyInboxBuilder)((FintechPsuAspspPrvKeyInbox.FintechPsuAspspPrvKeyInboxBuilder)FintechPsuAspspPrvKeyInbox.builder().fintech((Fintech)em.find(Fintech.class, (Object)tuple.getFintechId()))).psu((Psu)em.find(Psu.class, (Object)tuple.getPsuId()))).aspsp((Bank)em.find(Bank.class, (Object)tuple.getAspspId()))).build();
    }

    @Generated
    public long getFintechId() {
        return this.fintechId;
    }

    @Generated
    public long getPsuId() {
        return this.psuId;
    }

    @Generated
    public long getAspspId() {
        return this.aspspId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FintechPsuAspspTuple)) {
            return false;
        }
        FintechPsuAspspTuple other = (FintechPsuAspspTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFintechId() != other.getFintechId()) {
            return false;
        }
        if (this.getPsuId() != other.getPsuId()) {
            return false;
        }
        return this.getAspspId() == other.getAspspId();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FintechPsuAspspTuple;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fintechId = this.getFintechId();
        result = result * 59 + (int)($fintechId >>> 32 ^ $fintechId);
        long $psuId = this.getPsuId();
        result = result * 59 + (int)($psuId >>> 32 ^ $psuId);
        long $aspspId = this.getAspspId();
        result = result * 59 + (int)($aspspId >>> 32 ^ $aspspId);
        return result;
    }

    @Generated
    public String toString() {
        return "FintechPsuAspspTuple(fintechId=" + this.getFintechId() + ", psuId=" + this.getPsuId() + ", aspspId=" + this.getAspspId() + ")";
    }
}

