/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.datasafe;

import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.annotation.Transactional;

public abstract class DatasafeMetadataStorage<T>
implements BaseDatasafeDbStorageService.StorageActions {
    private final CrudRepository<T, Long> repository;
    private final Function<T, byte[]> getData;
    private final BiConsumer<T, byte[]> setData;

    @Override
    @Transactional
    public void update(String id, byte[] data) {
        Object toSave = this.repository.findById((Object)this.getIdValue(id)).get();
        this.setData.accept(toSave, data);
        this.repository.save(toSave);
    }

    @Override
    @Transactional
    public Optional<byte[]> read(String id) {
        return this.repository.findById((Object)Long.valueOf(id)).map(this.getData);
    }

    @Override
    @Transactional
    public void delete(String id) {
        throw new IllegalStateException("Not allowed");
    }

    protected Long getIdValue(String id) {
        return Long.valueOf(id);
    }

    @ConstructorProperties(value={"repository", "getData", "setData"})
    @Generated
    public DatasafeMetadataStorage(CrudRepository<T, Long> repository, Function<T, byte[]> getData, BiConsumer<T, byte[]> setData) {
        this.repository = repository;
        this.getData = getData;
        this.setData = setData;
    }
}

