/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.datasafe;

import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.data.repository.CrudRepository;
import org.springframework.transaction.support.TransactionOperations;

public abstract class DatasafeDataStorage<T>
implements BaseDatasafeDbStorageService.StorageActions {
    protected final CrudRepository<T, UUID> repository;
    private final Function<String, T> factory;
    private final Function<String, Optional<T>> find;
    private final Function<T, byte[]> getData;
    private final BiConsumer<T, byte[]> setData;
    private final TransactionOperations txOper;

    @Override
    public void update(String path, byte[] data) {
        this.txOper.execute(callback -> {
            Optional<T> entry = this.find.apply(path);
            if (entry.isPresent()) {
                T toSave = entry.get();
                this.setData.accept(toSave, data);
                return null;
            }
            T newEntry = this.factory.apply(path);
            this.setData.accept(newEntry, data);
            this.repository.save(newEntry);
            return null;
        });
    }

    @Override
    public Optional<byte[]> read(String path) {
        return (Optional)this.txOper.execute(callback -> this.find.apply(path).map(this.getData));
    }

    @Override
    public void delete(String path) {
        throw new IllegalStateException("Not allowed");
    }

    @ConstructorProperties(value={"repository", "factory", "find", "getData", "setData", "txOper"})
    @Generated
    public DatasafeDataStorage(CrudRepository<T, UUID> repository, Function<String, T> factory, Function<String, Optional<T>> find, Function<T, byte[]> getData, BiConsumer<T, byte[]> setData, TransactionOperations txOper) {
        this.repository = repository;
        this.factory = factory;
        this.find = find;
        this.getData = getData;
        this.setData = setData;
        this.txOper = txOper;
    }
}

