/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption.datasafe;

import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.UserPublicProfile;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyStoreAuth;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.WithCallback;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechDatasafeStorage;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseDatasafeDbStorageService
implements StorageService {
    public static final String DB_PROTOCOL = "db://";
    public static final String PRIVATE_STORAGE = "db://storage/";
    public static final String INBOX_STORAGE = "db://inbox/";
    public static final String KEYSTORE = "db://keystore/";
    public static final String PUB_KEYS = "db://pubkeys/";
    private final Map<String, StorageActions> handlers;

    @Transactional
    public boolean objectExists(AbsoluteLocation absoluteLocation) {
        return this.handlers.get(this.deduceTable(absoluteLocation)).read(this.deduceId(absoluteLocation)).isPresent();
    }

    @Transactional
    public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation absoluteLocation) {
        throw new IllegalStateException("Unsupported operation");
    }

    @Transactional(noRollbackFor={DbStorageEntityNotFoundException.class})
    public InputStream read(AbsoluteLocation absoluteLocation) {
        return new ByteArrayInputStream(this.requireBytes(absoluteLocation));
    }

    @Transactional
    public void remove(AbsoluteLocation absoluteLocation) {
        this.handlers.get(this.deduceTable(absoluteLocation)).delete(this.deduceId(absoluteLocation));
    }

    @Transactional
    public OutputStream write(WithCallback<AbsoluteLocation, ? extends ResourceWriteCallback> withCallback) {
        return new SetAndSaveOnClose(this.deduceId((AbsoluteLocation)withCallback.getWrapped()), this.handlers.get(this.deduceTable((AbsoluteLocation)withCallback.getWrapped())));
    }

    protected String deduceTable(AbsoluteLocation<?> path) {
        return path.location().getWrapped().getHost();
    }

    protected String deduceId(AbsoluteLocation<?> path) {
        return path.location().getWrapped().getPath().replaceAll("^/", "");
    }

    private byte[] requireBytes(AbsoluteLocation<?> location) {
        return this.handlers.get(this.deduceTable(location)).read(this.deduceId(location)).orElseThrow(() -> new DbStorageEntityNotFoundException("Failed to find entity for " + location.location().toASCIIString()));
    }

    private static CreateUserPrivateProfile createUserPrivateProfile(UserIDAuth userIDAuth) {
        String userId = userIDAuth.getUserID().getValue();
        return CreateUserPrivateProfile.builder().id(userIDAuth).privateStorage(BasePrivateResource.forAbsolutePrivate((String)(PRIVATE_STORAGE + userId + "/"))).keystore(BasePrivateResource.forAbsolutePrivate((String)(KEYSTORE + userId))).inboxWithWriteAccess(BasePrivateResource.forAbsolutePrivate((String)(INBOX_STORAGE + userId + "/"))).publishPubKeysTo(BasePublicResource.forAbsolutePublic((String)(PUB_KEYS + userId))).associatedResources(Collections.emptyList()).build();
    }

    @ConstructorProperties(value={"handlers"})
    @Generated
    public BaseDatasafeDbStorageService(Map<String, StorageActions> handlers) {
        this.handlers = handlers;
    }

    private static class SetAndSaveOnClose
    extends OutputStream {
        private final ByteArrayOutputStream os = new ByteArrayOutputStream();
        private final String id;
        private final StorageActions actions;

        @Override
        public void write(int b) {
            this.os.write(b);
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) {
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
            this.os.close();
            this.actions.update(this.id, this.os.toByteArray());
        }

        @ConstructorProperties(value={"id", "actions"})
        @Generated
        public SetAndSaveOnClose(String id, StorageActions actions) {
            this.id = id;
            this.actions = actions;
        }
    }

    public static class DbTableFintechRetrieval
    extends ProfileRetrievalServiceImpl {
        private final DFSConfig dfsConfig;

        public DbTableFintechRetrieval(ProfileRetrievalServiceImplRuntimeDelegatable.ArgumentsCaptor captor) {
            super(null, null, null, null, null, null);
            this.dfsConfig = captor.getDfsConfig();
        }

        public UserPublicProfile publicProfile(UserID ofUser) {
            return this.dfsConfig.defaultPublicTemplate(ofUser).buildPublicProfile();
        }

        public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
            UserPrivateProfile privateProfile = this.dfsConfig.defaultPrivateTemplate(ofUser).buildPrivateProfile();
            privateProfile.getPrivateStorage().put(FintechDatasafeStorage.FINTECH_ONLY_KEYS_ID, BasePrivateResource.forAbsolutePrivate((String)"db://private-keys/"));
            return privateProfile;
        }

        public boolean userExists(UserID ofUser) {
            return false;
        }
    }

    public static class DbTableUserRetrieval
    extends ProfileRetrievalServiceImpl {
        private final DFSConfig dfsConfig;

        public DbTableUserRetrieval(ProfileRetrievalServiceImplRuntimeDelegatable.ArgumentsCaptor captor) {
            super(null, null, null, null, null, null);
            this.dfsConfig = captor.getDfsConfig();
        }

        public UserPublicProfile publicProfile(UserID ofUser) {
            return this.dfsConfig.defaultPublicTemplate(ofUser).buildPublicProfile();
        }

        public UserPrivateProfile privateProfile(UserIDAuth ofUser) {
            return this.dfsConfig.defaultPrivateTemplate(ofUser).buildPrivateProfile();
        }

        public boolean userExists(UserID ofUser) {
            return false;
        }
    }

    public static class DbTablePrivateOnlyDFSConfig
    implements DFSConfig {
        private final String readKeystorePassword;

        public KeyStoreAuth privateKeyStoreAuth(UserIDAuth userIDAuth) {
            return new KeyStoreAuth(new ReadStorePassword(this.readKeystorePassword::toCharArray), userIDAuth.getReadKeyPassword());
        }

        public AbsoluteLocation publicProfile(UserID userID) {
            throw new IllegalStateException("Not supported");
        }

        public AbsoluteLocation privateProfile(UserID userID) {
            throw new IllegalStateException("Not supported");
        }

        public CreateUserPrivateProfile defaultPrivateTemplate(UserIDAuth userIDAuth) {
            return BaseDatasafeDbStorageService.createUserPrivateProfile(userIDAuth);
        }

        public CreateUserPublicProfile defaultPublicTemplate(UserID userID) {
            throw new IllegalStateException("Not supported");
        }

        @ConstructorProperties(value={"readKeystorePassword"})
        @Generated
        public DbTablePrivateOnlyDFSConfig(String readKeystorePassword) {
            this.readKeystorePassword = readKeystorePassword;
        }
    }

    public static class DbTableDFSConfig
    implements DFSConfig {
        private final String readKeystorePassword;

        public KeyStoreAuth privateKeyStoreAuth(UserIDAuth userIDAuth) {
            return new KeyStoreAuth(new ReadStorePassword(this.readKeystorePassword::toCharArray), userIDAuth.getReadKeyPassword());
        }

        public AbsoluteLocation publicProfile(UserID userID) {
            throw new IllegalStateException("Not supported");
        }

        public AbsoluteLocation privateProfile(UserID userID) {
            throw new IllegalStateException("Not supported");
        }

        public CreateUserPrivateProfile defaultPrivateTemplate(UserIDAuth userIDAuth) {
            return BaseDatasafeDbStorageService.createUserPrivateProfile(userIDAuth);
        }

        public CreateUserPublicProfile defaultPublicTemplate(UserID userID) {
            String userId = userID.getValue();
            return CreateUserPublicProfile.builder().id(userID).inbox(BasePublicResource.forAbsolutePublic((String)(BaseDatasafeDbStorageService.INBOX_STORAGE + userId + "/"))).publicKeys(BasePublicResource.forAbsolutePublic((String)(BaseDatasafeDbStorageService.PUB_KEYS + userId))).build();
        }

        @ConstructorProperties(value={"readKeystorePassword"})
        @Generated
        public DbTableDFSConfig(String readKeystorePassword) {
            this.readKeystorePassword = readKeystorePassword;
        }
    }

    public static interface StorageActions {
        public void update(String var1, byte[] var2);

        public Optional<byte[]> read(String var1);

        public void delete(String var1);
    }

    public static class DbStorageEntityNotFoundException
    extends IllegalStateException {
        public DbStorageEntityNotFoundException(String s) {
            super(s);
        }
    }
}

