/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption;

import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.facade.config.encryption.SecretKeyWithIv;
import de.adorsys.opba.protocol.facade.config.encryption.SymmetricEncSpec;
import java.beans.ConstructorProperties;
import java.security.Key;
import java.security.SecureRandom;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import lombok.Generated;

public class EncryptionWithInitVectorOper {
    private final SymmetricEncSpec encSpec;

    public EncryptionService encryptionService(String keyId, SecretKeyWithIv keyWithIv) {
        return new SymmeticEncryption(keyId, () -> this.encryption(keyWithIv), () -> this.decryption(keyWithIv));
    }

    public Cipher encryption(SecretKeyWithIv keyWithIv) {
        Cipher cipher = Cipher.getInstance(this.encSpec.getCipherAlgo());
        cipher.init(1, (Key)keyWithIv.getSecretKey(), new IvParameterSpec(keyWithIv.getIv()));
        return cipher;
    }

    public Cipher decryption(SecretKeyWithIv keyWithIv) {
        Cipher cipher = Cipher.getInstance(this.encSpec.getCipherAlgo());
        cipher.init(2, (Key)keyWithIv.getSecretKey(), new IvParameterSpec(keyWithIv.getIv()));
        return cipher;
    }

    public SecretKeyWithIv generateKey() {
        byte[] iv = new byte[this.encSpec.getIvSize()];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        KeyGenerator keyGen = KeyGenerator.getInstance(this.encSpec.getKeyAlgo());
        keyGen.init(this.encSpec.getLen());
        return new SecretKeyWithIv(iv, keyGen.generateKey());
    }

    @ConstructorProperties(value={"encSpec"})
    @Generated
    public EncryptionWithInitVectorOper(SymmetricEncSpec encSpec) {
        this.encSpec = encSpec;
    }

    public static class SymmeticEncryption
    implements EncryptionService {
        private final String encryptionKeyId;
        private final Supplier<Cipher> encryption;
        private final Supplier<Cipher> decryption;

        public byte[] encrypt(byte[] data) {
            return this.encryption.get().doFinal(data);
        }

        public byte[] decrypt(byte[] data) {
            return this.decryption.get().doFinal(data);
        }

        @ConstructorProperties(value={"encryptionKeyId", "encryption", "decryption"})
        @Generated
        public SymmeticEncryption(String encryptionKeyId, Supplier<Cipher> encryption, Supplier<Cipher> decryption) {
            this.encryptionKeyId = encryptionKeyId;
            this.encryption = encryption;
            this.decryption = decryption;
        }

        @Generated
        public String getEncryptionKeyId() {
            return this.encryptionKeyId;
        }
    }
}

