/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.operations.actions.ProfileRetrievalServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionImpl;
import de.adorsys.datasafe.encrypiton.impl.pathencryption.PathEncryptionImplRuntimeDelegatable;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.context.BaseOverridesRegistry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.opba.protocol.facade.config.encryption.PsuEncryptionServiceProvider;
import de.adorsys.opba.protocol.facade.config.encryption.datasafe.BaseDatasafeDbStorageService;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechConsentSpecDatasafeStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechConsentSpecSecureStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechDatasafeStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.fintech.FintechSecureStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.psu.PsuDatasafeStorage;
import de.adorsys.opba.protocol.facade.config.encryption.impl.psu.PsuSecureStorage;
import de.adorsys.opba.protocol.facade.services.EncryptionKeySerde;
import java.beans.ConstructorProperties;
import java.security.Provider;
import java.security.Security;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DatasafeConfig {
    private static final String ENCRYPTION_DATASAFE_READ_KEYSTORE_PREFIX = "${facade.encryption.datasafe.read-keystore";
    private final ObjectMapper mapper;
    private final FintechDatasafeStorage fintechStorage;
    private final PsuDatasafeStorage psuStorage;
    private final FintechConsentSpecDatasafeStorage fintechUserStorage;

    @Bean
    public FintechSecureStorage fintechDatasafeServices(@Value(value="${facade.encryption.datasafe.read-keystore.fintech}") String fintechReadStorePass, EncryptionKeySerde serde) {
        BaseDatasafeDbStorageService.DbTableDFSConfig config = new BaseDatasafeDbStorageService.DbTableDFSConfig(fintechReadStorePass);
        BaseOverridesRegistry overridesRegistry = new BaseOverridesRegistry();
        ProfileRetrievalServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, BaseDatasafeDbStorageService.DbTableFintechRetrieval::new);
        PathEncryptionImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, x$0 -> new NoOpPathEncryptionImplOverridden((PathEncryptionImplRuntimeDelegatable.ArgumentsCaptor)x$0));
        return new FintechSecureStorage(DaggerDefaultDatasafeServices.builder().config((DFSConfig)config).storage((StorageService)this.fintechStorage).overridesRegistry((OverridesRegistry)overridesRegistry).build(), config, serde);
    }

    @Bean
    public PsuSecureStorage psuDatasafeServices(@Value(value="${facade.encryption.datasafe.read-keystore.psu}") String psuReadStorePass, PsuEncryptionServiceProvider encryptionServiceProvider, EncryptionKeySerde serde) {
        BaseDatasafeDbStorageService.DbTableDFSConfig config = new BaseDatasafeDbStorageService.DbTableDFSConfig(psuReadStorePass);
        BaseOverridesRegistry overridesRegistry = new BaseOverridesRegistry();
        ProfileRetrievalServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, BaseDatasafeDbStorageService.DbTableUserRetrieval::new);
        PathEncryptionImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, x$0 -> new NoOpPathEncryptionImplOverridden((PathEncryptionImplRuntimeDelegatable.ArgumentsCaptor)x$0));
        return new PsuSecureStorage(DaggerDefaultDatasafeServices.builder().config((DFSConfig)config).storage((StorageService)this.psuStorage).overridesRegistry((OverridesRegistry)overridesRegistry).build(), config, encryptionServiceProvider, serde);
    }

    @Bean
    public FintechConsentSpecSecureStorage fintechUserDatasafeServices(@Value(value="${facade.encryption.datasafe.read-keystore.fintech-user}") String psuReadStorePass) {
        BaseDatasafeDbStorageService.DbTableDFSConfig config = new BaseDatasafeDbStorageService.DbTableDFSConfig(psuReadStorePass);
        BaseOverridesRegistry overridesRegistry = new BaseOverridesRegistry();
        ProfileRetrievalServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, BaseDatasafeDbStorageService.DbTableUserRetrieval::new);
        PathEncryptionImplRuntimeDelegatable.overrideWith((OverridesRegistry)overridesRegistry, x$0 -> new NoOpPathEncryptionImplOverridden((PathEncryptionImplRuntimeDelegatable.ArgumentsCaptor)x$0));
        return new FintechConsentSpecSecureStorage(DaggerDefaultDatasafeServices.builder().config((DFSConfig)config).storage((StorageService)this.fintechUserStorage).overridesRegistry((OverridesRegistry)overridesRegistry).build(), config, this.mapper);
    }

    @PostConstruct
    void provideBouncyCastle() {
        if (null != Security.getProvider("BC")) {
            return;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @ConstructorProperties(value={"mapper", "fintechStorage", "psuStorage", "fintechUserStorage"})
    @Generated
    public DatasafeConfig(ObjectMapper mapper, FintechDatasafeStorage fintechStorage, PsuDatasafeStorage psuStorage, FintechConsentSpecDatasafeStorage fintechUserStorage) {
        this.mapper = mapper;
        this.fintechStorage = fintechStorage;
        this.psuStorage = psuStorage;
        this.fintechUserStorage = fintechUserStorage;
    }

    class NoOpPathEncryptionImplOverridden
    extends PathEncryptionImpl {
        NoOpPathEncryptionImplOverridden(PathEncryptionImplRuntimeDelegatable.ArgumentsCaptor captor) {
            super(captor.getSymmetricPathEncryptionService(), captor.getPrivateKeyService());
        }

        public Uri encrypt(UserIDAuth forUser, Uri path) {
            return path;
        }

        public Function<Uri, Uri> decryptor(UserIDAuth forUser) {
            return Function.identity();
        }
    }
}

