/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption;

import de.adorsys.datasafe.encrypiton.impl.utils.ProviderUtils;
import de.adorsys.opba.protocol.api.services.EncryptionService;
import de.adorsys.opba.protocol.facade.config.encryption.CmsEncSpec;
import java.beans.ConstructorProperties;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataParser;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;

public class CmsEncryptionOper {
    private final CmsEncSpec cmsEncSpec;

    public EncryptionService encryptionService(String keyId, PrivateKey privateKey) {
        return new CmsEncryption(keyId, this.cmsEncSpec.getCipherAlgo(), null, privateKey);
    }

    public EncryptionService encryptionService(String keyId, PublicKey publicKey) {
        return new CmsEncryption(keyId, this.cmsEncSpec.getCipherAlgo(), publicKey, null);
    }

    public KeyPair generatePublicPrivateKey() {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance(this.cmsEncSpec.getKeyAlgo());
        keyGen.initialize(this.cmsEncSpec.getLen());
        return keyGen.genKeyPair();
    }

    @ConstructorProperties(value={"cmsEncSpec"})
    @Generated
    public CmsEncryptionOper(CmsEncSpec cmsEncSpec) {
        this.cmsEncSpec = cmsEncSpec;
    }

    public static class CmsEncryption
    implements EncryptionService {
        private final String encryptionKeyId;
        private final ASN1ObjectIdentifier algorithm;
        private final PublicKey publicKey;
        private final PrivateKey privateKey;

        public byte[] encrypt(byte[] data) {
            CMSEnvelopedDataGenerator generator = new CMSEnvelopedDataGenerator();
            generator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(this.encryptionKeyId.getBytes(StandardCharsets.UTF_8), this.publicKey));
            return generator.generate((CMSTypedData)new CMSProcessableByteArray(data), new JceCMSContentEncryptorBuilder(this.algorithm).setProvider(ProviderUtils.bcProvider).build()).getEncoded();
        }

        public byte[] decrypt(byte[] data) {
            CMSEnvelopedDataParser parser = new CMSEnvelopedDataParser(data);
            return ((RecipientInformation)parser.getRecipientInfos().iterator().next()).getContent((Recipient)new JceKeyTransEnvelopedRecipient(this.privateKey));
        }

        @ConstructorProperties(value={"encryptionKeyId", "algorithm", "publicKey", "privateKey"})
        @Generated
        public CmsEncryption(String encryptionKeyId, ASN1ObjectIdentifier algorithm, PublicKey publicKey, PrivateKey privateKey) {
            this.encryptionKeyId = encryptionKeyId;
            this.algorithm = algorithm;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        @Generated
        public String getEncryptionKeyId() {
            return this.encryptionKeyId;
        }
    }
}

