/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config.encryption;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
@ConfigurationPropertiesBinding
public class ASN1ObjectIdentifierConverter
implements Converter<String, ASN1ObjectIdentifier> {
    private static final Map<String, ASN1ObjectIdentifier> MAPPINGS = ImmutableMap.builder().put((Object)"AES128_CBC", (Object)NISTObjectIdentifiers.id_aes128_CBC).put((Object)"AES192_CBC", (Object)NISTObjectIdentifiers.id_aes192_CBC).put((Object)"AES256_CBC", (Object)NISTObjectIdentifiers.id_aes256_CBC).put((Object)"AES128_CCM", (Object)NISTObjectIdentifiers.id_aes128_CCM).put((Object)"AES192_CCM", (Object)NISTObjectIdentifiers.id_aes192_CCM).put((Object)"AES256_CCM", (Object)NISTObjectIdentifiers.id_aes256_CCM).put((Object)"AES128_GCM", (Object)NISTObjectIdentifiers.id_aes128_GCM).put((Object)"AES192_GCM", (Object)NISTObjectIdentifiers.id_aes192_GCM).put((Object)"AES256_GCM", (Object)NISTObjectIdentifiers.id_aes256_GCM).put((Object)"AES128_WRAP", (Object)NISTObjectIdentifiers.id_aes128_wrap).put((Object)"AES192_WRAP", (Object)NISTObjectIdentifiers.id_aes192_wrap).put((Object)"AES256_WRAP", (Object)NISTObjectIdentifiers.id_aes256_wrap).put((Object)"CHACHA20_POLY1305", (Object)PKCSObjectIdentifiers.id_alg_AEADChaCha20Poly1305).build();

    public ASN1ObjectIdentifier convert(String source) {
        ASN1ObjectIdentifier identifier = MAPPINGS.get(source);
        if (null == identifier) {
            throw new IllegalArgumentException("Unknown mapping: " + source);
        }
        return identifier;
    }
}

