/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.facade.config;

import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FacadeTransientDataConfig {
    public static final long MIN_EXPIRE_SECONDS = 60L;
    public static final String FACADE_CACHE_BUILDER = "facade-cache-builder";

    @Bean(value={"facade-cache-builder"})
    CacheBuilder facadeCacheBuilder(@Value(value="${facade..expirable.expire-after-write}") Duration expireAfterWrite) {
        if (expireAfterWrite.getSeconds() < 60L) {
            throw new IllegalArgumentException("It is not recommended to have short transient data expiration time, it must be at least equal to request timeout");
        }
        return CacheBuilder.newBuilder().expireAfterWrite(expireAfterWrite).maximumSize(Integer.MAX_VALUE);
    }
}

