/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppauthapi.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import de.adorsys.opba.api.security.internal.config.AuthorizationSessionKeyConfig;
import de.adorsys.opba.api.security.internal.config.CookieProperties;
import de.adorsys.opba.api.security.internal.config.TppTokenProperties;
import de.adorsys.opba.api.security.internal.service.CookieBuilderTemplate;
import de.adorsys.opba.api.security.internal.service.TokenBasedAuthService;
import de.adorsys.opba.db.domain.entity.psu.Psu;
import de.adorsys.opba.protocol.facade.config.auth.FacadeAuthConfig;
import de.adorsys.opba.protocol.facade.services.authorization.PsuLoginForAisService;
import de.adorsys.opba.protocol.facade.services.psu.PsuAuthService;
import de.adorsys.opba.tppauthapi.model.generated.LoginResponse;
import de.adorsys.opba.tppauthapi.model.generated.PsuAuthBody;
import de.adorsys.opba.tppauthapi.resource.generated.PsuAuthenticationAndConsentApprovalApi;
import de.adorsys.opba.tppauthapi.resource.generated.PsuAuthenticationApi;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@CrossOrigin(origins={"*"})
public class PsuAuthController
implements PsuAuthenticationApi,
PsuAuthenticationAndConsentApprovalApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PsuAuthController.class);
    public static final Base64.Encoder ENCODER = Base64.getEncoder();
    private final PsuLoginForAisService aisService;
    private final PsuAuthService psuAuthService;
    private final TokenBasedAuthService authService;
    private final FacadeAuthConfig authConfig;
    private final AuthorizationSessionKeyConfig.AuthorizationSessionKeyFromHttpRequest authorizationKeyFromHttpRequest;
    private final CookieBuilderTemplate cookieBuilderTemplate;
    private final CookieProperties cookieProperties;
    private final TppTokenProperties tppTokenProperties;

    public ResponseEntity<LoginResponse> login(PsuAuthBody psuAuthBody, UUID xRequestID) {
        Psu psu = this.psuAuthService.tryAuthenticateUser(psuAuthBody.getLogin(), psuAuthBody.getPassword());
        String jwtToken = this.authService.generateToken(psu.getLogin(), this.tppTokenProperties.getTokenValidityDuration());
        String cookieString = this.cookieBuilderTemplate.builder(jwtToken).build().toString();
        String ttl = Long.toString(this.cookieProperties.getMaxAge().getSeconds());
        LoginResponse loginResponse = new LoginResponse();
        loginResponse.setXsrfToken(ENCODER.encodeToString(jwtToken.getBytes()));
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).header("X-Request-ID", new String[]{xRequestID.toString()})).header("Cookie-TTL", new String[]{ttl})).header("Set-Cookie", new String[]{cookieString})).body((Object)loginResponse);
    }

    public ResponseEntity<LoginResponse> loginForApproval(PsuAuthBody body, UUID xRequestId, String redirectCode, UUID authorizationId) {
        PsuLoginForAisService.Outcome outcome = this.aisService.loginInPsuScopeAndAssociateAuthSession(body.getLogin(), body.getPassword(), authorizationId, redirectCode);
        return this.createResponseWithSecretKeyInCookieOnAllPaths(xRequestId, authorizationId, outcome);
    }

    public ResponseEntity<LoginResponse> loginForPaymentApproval(PsuAuthBody body, UUID xRequestId, String redirectCode, UUID authorizationId) {
        return this.loginForApproval(body, xRequestId, redirectCode, authorizationId);
    }

    public ResponseEntity<LoginResponse> loginForAnonymousPaymentApproval(UUID xRequestId, UUID authorizationId, String redirectCode) {
        PsuLoginForAisService.Outcome outcome = this.aisService.anonymousPsuAssociateAuthSession(authorizationId, redirectCode);
        return this.createResponseWithSecretKeyInCookieOnAllPaths(xRequestId, authorizationId, outcome);
    }

    public ResponseEntity<Void> registration(PsuAuthBody psuAuthDto, UUID xRequestID) {
        this.psuAuthService.createPsuIfNotExist(psuAuthDto.getLogin(), psuAuthDto.getPassword());
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Location", this.authConfig.getRedirect().getConsentLogin().getPage().getForAis());
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.CREATED);
    }

    public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    public ResponseEntity<Void> renewalAuthorizationSessionKey(UUID xRequestId, UUID authorizationId) {
        String[] cookies = this.buildAuthorizationCookiesOnAllPaths(authorizationId, this.authorizationKeyFromHttpRequest.getKey(), this.tppTokenProperties.getTokenValidityDuration());
        String ttl = Long.toString(this.cookieProperties.getMaxAge().getSeconds());
        log.debug("cookie is renewed for authid {} for time {}", (Object)authorizationId, (Object)ttl);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).header("X-Request-ID", new String[]{xRequestId.toString()})).header("Cookie-TTL", new String[]{ttl})).header("Set-Cookie", cookies)).build();
    }

    @NotNull
    private ResponseEntity<LoginResponse> createResponseWithSecretKeyInCookieOnAllPaths(UUID xRequestId, UUID authorizationId, PsuLoginForAisService.Outcome outcome) {
        String ttl = Long.toString(this.cookieProperties.getMaxAge().getSeconds());
        log.debug("created new session cookie for authid {}", (Object)authorizationId);
        return ((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).header("Location", new String[]{outcome.getRedirectLocation().toASCIIString()})).header("X-Request-ID", new String[]{xRequestId.toString()})).header("Cookie-TTL", new String[]{ttl})).header("Set-Cookie", this.buildAuthorizationCookiesOnAllPaths(authorizationId, outcome.getKey(), this.tppTokenProperties.getTokenValidityDuration()))).build();
    }

    private String[] buildAuthorizationCookiesOnAllPaths(UUID authorizationId, String key, Duration duration) {
        String token = this.authService.generateToken(key, duration);
        return (String[])this.authConfig.getAuthorizationSessionKey().getCookie().getPathTemplates().stream().map(it -> this.cookieString(authorizationId, (String)it, token)).toArray(String[]::new);
    }

    private String cookieString(UUID authorizationId, String path, String token) {
        String redirectPath = UriComponentsBuilder.fromPath((String)path).buildAndExpand((Map)ImmutableMap.of((Object)"authorizationSessionId", (Object)authorizationId.toString())).toUriString();
        String domain = this.authConfig.getAuthorizationSessionKey().getCookie().getDomain();
        ResponseCookie.ResponseCookieBuilder builder = this.cookieBuilderTemplate.builder(token, redirectPath, domain);
        return builder.build().toString();
    }

    @ConstructorProperties(value={"aisService", "psuAuthService", "authService", "authConfig", "authorizationKeyFromHttpRequest", "cookieBuilderTemplate", "cookieProperties", "tppTokenProperties"})
    @Generated
    public PsuAuthController(PsuLoginForAisService aisService, PsuAuthService psuAuthService, TokenBasedAuthService authService, FacadeAuthConfig authConfig, AuthorizationSessionKeyConfig.AuthorizationSessionKeyFromHttpRequest authorizationKeyFromHttpRequest, CookieBuilderTemplate cookieBuilderTemplate, CookieProperties cookieProperties, TppTokenProperties tppTokenProperties) {
        this.aisService = aisService;
        this.psuAuthService = psuAuthService;
        this.authService = authService;
        this.authConfig = authConfig;
        this.authorizationKeyFromHttpRequest = authorizationKeyFromHttpRequest;
        this.cookieBuilderTemplate = cookieBuilderTemplate;
        this.cookieProperties = cookieProperties;
        this.tppTokenProperties = tppTokenProperties;
    }
}

