/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppauthapi.controller;

import de.adorsys.opba.protocol.facade.exceptions.NoProtocolRegisteredException;
import de.adorsys.opba.protocol.facade.exceptions.PsuAuthenticationException;
import de.adorsys.opba.protocol.facade.exceptions.PsuAuthorizationException;
import de.adorsys.opba.protocol.facade.exceptions.PsuRegisterException;
import de.adorsys.opba.tppauthapi.controller.PsuAuthController;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice(basePackageClasses={PsuAuthController.class})
public class GenericControllerAdvice {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericControllerAdvice.class);

    @ExceptionHandler(value={PsuRegisterException.class})
    public ResponseEntity<List<String>> handleUserExistsException(PsuRegisterException ex) {
        log.error("User exists exception: {}", (Object)ex.getMessage(), (Object)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(Collections.singletonList(ex.getMessage()));
    }

    @ExceptionHandler(value={PsuAuthenticationException.class})
    public ResponseEntity<List<String>> handleUserDoesNotExistException(PsuAuthenticationException ex) {
        log.error("User does not exist exception: {}", (Object)ex.getMessage(), (Object)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(Collections.singletonList(ex.getMessage()));
    }

    @ExceptionHandler(value={PsuAuthorizationException.class})
    public ResponseEntity<List<String>> handleUnauthorizedException(Exception ex) {
        log.error("Unauthorized exception: {}", (Object)ex.getMessage(), (Object)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).body(Collections.singletonList(ex.getMessage()));
    }

    @ExceptionHandler(value={NoProtocolRegisteredException.class})
    public ResponseEntity<List<String>> handleNoProtocolException(Exception ex) {
        log.error("No protocol registered exception: {}", (Object)ex.getMessage(), (Object)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(Collections.singletonList(ex.getMessage()));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public ResponseEntity<List<String>> handleException(Exception ex) {
        log.error("Unhandled exception: {}", (Object)ex.getMessage(), (Object)ex);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body(Collections.singletonList(ex.getMessage()));
    }
}

