/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppauthapi.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppauthapi.model.generated.GeneralError;
import de.adorsys.opba.tppauthapi.model.generated.LoginResponse;
import de.adorsys.opba.tppauthapi.model.generated.PsuAuthBody;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="PsuAuthenticationAndConsentApproval", description="the PsuAuthenticationAndConsentApproval API")
public interface PsuAuthenticationAndConsentApprovalApi {
    public static final Logger log = LoggerFactory.getLogger(PsuAuthenticationAndConsentApprovalApi.class);

    public Optional<ObjectMapper> getObjectMapper();

    public Optional<HttpServletRequest> getRequest();

    @ApiOperation(value="Login user to open-banking to perform payment (anonymous to OPBA)", nickname="loginForAnonymousPaymentApproval", notes="TBD", response=LoginResponse.class, tags={"Psu Authentication and consent approval"})
    @ApiResponses(value={@ApiResponse(code=202, message="User logged in", response=LoginResponse.class), @ApiResponse(code=401, message="Bad username or password ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/pis/{authorization-id}/anonymous"}, produces={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<LoginResponse> loginForAnonymousPaymentApproval(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var1, @ApiParam(value="Authorization session ID to approve", required=true) @PathVariable(value="authorization-id") UUID var2, @NotNull @ApiParam(value="Redirect code that acts as a password protecting FinTech requested consent specification", required=true) @Valid @RequestParam(value="redirectCode", required=true) String var3);

    @ApiOperation(value="Login user to open-banking", nickname="loginForApproval", notes="TBD", response=LoginResponse.class, tags={"Psu Authentication and consent approval"})
    @ApiResponses(value={@ApiResponse(code=202, message="User logged in", response=LoginResponse.class), @ApiResponse(code=401, message="Bad username or password ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/ais/{authorization-id}/for-approval/login"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<LoginResponse> loginForApproval(@ApiParam(value="User credentials object", required=true) @Valid @RequestBody PsuAuthBody var1, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var2, @NotNull @ApiParam(value="Redirect code that acts as a password protecting FinTech requested consent specification", required=true) @Valid @RequestParam(value="redirectCode", required=true) String var3, @ApiParam(value="Authorization session ID to approve", required=true) @PathVariable(value="authorization-id") UUID var4);

    @ApiOperation(value="Login user to open-banking to perform payment", nickname="loginForPaymentApproval", notes="TBD", response=LoginResponse.class, tags={"Psu Authentication and consent approval"})
    @ApiResponses(value={@ApiResponse(code=202, message="User logged in", response=LoginResponse.class), @ApiResponse(code=401, message="Bad username or password ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/pis/{authorization-id}/for-approval/login"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<LoginResponse> loginForPaymentApproval(@ApiParam(value="User credentials object", required=true) @Valid @RequestBody PsuAuthBody var1, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var2, @NotNull @ApiParam(value="Redirect code that acts as a password protecting FinTech requested consent specification", required=true) @Valid @RequestParam(value="redirectCode", required=true) String var3, @ApiParam(value="Authorization session ID to approve", required=true) @PathVariable(value="authorization-id") UUID var4);
}

