/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.tppauthapi.resource.generated;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.opba.tppauthapi.model.generated.GeneralError;
import de.adorsys.opba.tppauthapi.model.generated.LoginResponse;
import de.adorsys.opba.tppauthapi.model.generated.PsuAuthBody;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="PsuAuthentication", description="the PsuAuthentication API")
public interface PsuAuthenticationApi {
    public static final Logger log = LoggerFactory.getLogger(PsuAuthenticationApi.class);

    public Optional<ObjectMapper> getObjectMapper();

    public Optional<HttpServletRequest> getRequest();

    @ApiOperation(value="Login user to open-banking", nickname="login", notes="TBD", response=LoginResponse.class, tags={"Psu Authentication"})
    @ApiResponses(value={@ApiResponse(code=202, message="User logged in", response=LoginResponse.class), @ApiResponse(code=401, message="Bad username or password ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/login"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<LoginResponse> login(@ApiParam(value="User credentials object", required=true) @Valid @RequestBody PsuAuthBody var1, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var2);

    @ApiOperation(value="registration user in open-banking db", nickname="registration", notes="TBD", tags={"Psu Authentication"})
    @ApiResponses(value={@ApiResponse(code=201, message="User created sucessfully"), @ApiResponse(code=400, message="Wrong registration parameters or user exist ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/register"}, produces={"application/json"}, consumes={"application/json"}, method={RequestMethod.POST})
    public ResponseEntity<Void> registration(@ApiParam(value="User credentials object", required=true) @Valid @RequestBody PsuAuthBody var1, @ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var2);

    @ApiOperation(value="the AuthorizationSessionKey is replaces with a new one", nickname="renewalAuthorizationSessionKey", notes="Input is the old cookie, response is empty with a new cookie", tags={"Psu Authentication"})
    @ApiResponses(value={@ApiResponse(code=202, message="User logged in"), @ApiResponse(code=401, message="Bad username or password ", response=GeneralError.class)})
    @ApiImplicitParams(value={@ApiImplicitParam(name="xRequestID", value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true, dataType="UUID", paramType="header")})
    @RequestMapping(value={"/v1/psu/ais/{authorization-id}/renewal-authorization-session-key"}, produces={"application/json"}, method={RequestMethod.GET})
    public ResponseEntity<Void> renewalAuthorizationSessionKey(@ApiParam(value="Unique ID that identifies this request through common workflow. Shall be contained in HTTP Response as well. ", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID var1, @ApiParam(value="Authorization session ID to approve", required=true) @PathVariable(value="authorization-id") UUID var2);
}

