/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.analytics;

import de.adorsys.opba.analytics.dto.AnalyticsRequest;
import de.adorsys.opba.protocol.api.dto.request.FacadeServiceableRequest;
import de.adorsys.opba.protocol.api.dto.result.body.AnalyticsResult;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionDetailsBody;
import de.adorsys.opba.protocol.api.dto.result.body.TransactionsResponseBody;
import de.adorsys.opba.protocol.api.services.ResultBodyPostProcessor;
import java.util.List;

public abstract class TransactionAnalyzer
implements ResultBodyPostProcessor {
    public Object apply(Object requestMappedResult) {
        TransactionsResponseBody body = (TransactionsResponseBody)requestMappedResult;
        if (null == body.getTransactions()) {
            return body;
        }
        TransactionsResponseBody.TransactionsResponseBodyBuilder result = body.toBuilder();
        if (null != body.getTransactions().getBooked()) {
            AnalyticsResult analyzedTxn = this.analyze(AnalyticsRequest.builder().transactions((List<TransactionDetailsBody>)body.getTransactions().getBooked()).build());
            result = result.analytics(analyzedTxn);
        }
        return result.build();
    }

    public boolean shouldApply(FacadeServiceableRequest request, Object requestMappedResult) {
        return request.isWithAnalytics() && requestMappedResult instanceof TransactionsResponseBody;
    }

    public abstract AnalyticsResult analyze(AnalyticsRequest var1);
}

