/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.adminapi.service.mappers;

import de.adorsys.opba.adminapi.model.generated.Bank;
import de.adorsys.opba.adminapi.model.generated.BankAction;
import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.model.generated.BankProfile;
import de.adorsys.opba.adminapi.model.generated.BankSubAction;
import de.adorsys.opba.adminapi.service.AdminApiService;
import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.BankAction;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.domain.entity.BankSubAction;
import de.adorsys.opba.protocol.api.common.Approach;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class AdminApiService$BankMapperImpl
implements AdminApiService.BankMapper {
    @Override
    public BankData map(AdminApiService.BankDataToMap bank) {
        if (bank == null) {
            return null;
        }
        BankData bankData = new BankData();
        bankData.setBank(this.bankToBank(bank.getBank()));
        bankData.setProfiles(this.bankProfileCollectionToBankProfileList(bank.getProfiles()));
        return bankData;
    }

    @Override
    public Bank bankToBank(de.adorsys.opba.db.domain.entity.Bank bank) {
        if (bank == null) {
            return null;
        }
        Bank bank1 = new Bank();
        bank1.setIsActive(Boolean.valueOf(bank.isActive()));
        bank1.setId(bank.getId());
        bank1.setUuid(bank.getUuid());
        bank1.setName(bank.getName());
        bank1.setBic(bank.getBic());
        bank1.setBankCode(bank.getBankCode());
        return bank1;
    }

    @Override
    public de.adorsys.opba.adminapi.model.generated.BankProfile bankProfileToBankProfile(BankProfile bankProfile) {
        if (bankProfile == null) {
            return null;
        }
        de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile1 = new de.adorsys.opba.adminapi.model.generated.BankProfile();
        bankProfile1.setIsActive(Boolean.valueOf(bankProfile.isActive()));
        bankProfile1.setId(bankProfile.getId());
        bankProfile1.setUrl(bankProfile.getUrl());
        bankProfile1.setUuid(bankProfile.getUuid());
        bankProfile1.setAdapterId(bankProfile.getAdapterId());
        bankProfile1.setIdpUrl(bankProfile.getIdpUrl());
        bankProfile1.setScaApproaches(this.approachListToScaApproachesEnumList(bankProfile.getScaApproaches()));
        bankProfile1.setPreferredApproach(this.approachToPreferredApproachEnum(bankProfile.getPreferredApproach()));
        bankProfile1.setTryToUsePreferredApproach(Boolean.valueOf(bankProfile.isTryToUsePreferredApproach()));
        bankProfile1.setUniquePaymentPurpose(Boolean.valueOf(bankProfile.isUniquePaymentPurpose()));
        bankProfile1.setActions(this.protocolActionBankActionMapToStringBankActionMap(bankProfile.getActions()));
        bankProfile1.setBankCode(bankProfile.getBankCode());
        bankProfile1.setBic(bankProfile.getBic());
        bankProfile1.setName(bankProfile.getName());
        bankProfile1.setExternalId(bankProfile.getExternalId());
        bankProfile1.setExternalInterfaces(bankProfile.getExternalInterfaces());
        bankProfile1.setProtocolType(bankProfile.getProtocolType());
        return bankProfile1;
    }

    @Override
    public AdminApiService.BankDataToMap map(BankData bank) {
        if (bank == null) {
            return null;
        }
        AdminApiService.BankDataToMap bankDataToMap = new AdminApiService.BankDataToMap();
        bankDataToMap.setBank(this.bankToBank1(bank.getBank()));
        bankDataToMap.setProfiles(this.bankProfileListToBankProfileCollection(bank.getProfiles()));
        return bankDataToMap;
    }

    @Override
    public void mapToBank(Bank bankData, de.adorsys.opba.db.domain.entity.Bank bank) {
        if (bankData == null) {
            return;
        }
        if (bankData.isIsActive() != null) {
            bank.setActive(bankData.isIsActive().booleanValue());
        }
        if (bankData.getName() != null) {
            bank.setName(bankData.getName());
        }
        if (bankData.getBic() != null) {
            bank.setBic(bankData.getBic());
        }
        if (bankData.getBankCode() != null) {
            bank.setBankCode(bankData.getBankCode());
        }
    }

    @Override
    public void mapToProfile(de.adorsys.opba.adminapi.model.generated.BankProfile bankData, BankProfile bank) {
        if (bankData == null) {
            return;
        }
        if (bankData.isIsActive() != null) {
            bank.setActive(bankData.isIsActive().booleanValue());
        }
        if (bankData.getUrl() != null) {
            bank.setUrl(bankData.getUrl());
        }
        if (bankData.getAdapterId() != null) {
            bank.setAdapterId(bankData.getAdapterId());
        }
        if (bankData.getIdpUrl() != null) {
            bank.setIdpUrl(bankData.getIdpUrl());
        }
        if (bankData.getUuid() != null) {
            bank.setUuid(bankData.getUuid());
        }
        if (bankData.getName() != null) {
            bank.setName(bankData.getName());
        }
        if (bank.getScaApproaches() != null) {
            List<Approach> list = this.scaApproachesEnumListToApproachList(bankData.getScaApproaches());
            if (list != null) {
                bank.getScaApproaches().clear();
                bank.getScaApproaches().addAll(list);
            }
        } else {
            List<Approach> list = this.scaApproachesEnumListToApproachList(bankData.getScaApproaches());
            if (list != null) {
                bank.setScaApproaches(list);
            }
        }
        if (bankData.getPreferredApproach() != null) {
            bank.setPreferredApproach(this.preferredApproachEnumToApproach(bankData.getPreferredApproach()));
        }
        if (bankData.isTryToUsePreferredApproach() != null) {
            bank.setTryToUsePreferredApproach(bankData.isTryToUsePreferredApproach().booleanValue());
        }
        if (bankData.isUniquePaymentPurpose() != null) {
            bank.setUniquePaymentPurpose(bankData.isUniquePaymentPurpose().booleanValue());
        }
        if (bankData.getExternalId() != null) {
            bank.setExternalId(bankData.getExternalId());
        }
        if (bankData.getExternalInterfaces() != null) {
            bank.setExternalInterfaces(bankData.getExternalInterfaces());
        }
        if (bankData.getProtocolType() != null) {
            bank.setProtocolType(bankData.getProtocolType());
        }
    }

    @Override
    public Map<ProtocolAction, BankAction> mapActions(Map<String, de.adorsys.opba.adminapi.model.generated.BankAction> map) {
        if (map == null) {
            return null;
        }
        HashMap<ProtocolAction, BankAction> map1 = new HashMap<ProtocolAction, BankAction>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<String, de.adorsys.opba.adminapi.model.generated.BankAction> entry : map.entrySet()) {
            ProtocolAction key = Enum.valueOf(ProtocolAction.class, entry.getKey());
            BankAction value = this.bankActionToBankAction1(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    @Override
    public void mapAction(BankAction action, BankAction targetAction) {
        Collection collection1;
        Collection collection;
        if (action == null) {
            return;
        }
        if (action.getBankProfile() != null) {
            targetAction.setBankProfile(action.getBankProfile());
        }
        if (action.getProtocolAction() != null) {
            targetAction.setProtocolAction(action.getProtocolAction());
        }
        if (action.getProtocolBeanName() != null) {
            targetAction.setProtocolBeanName(action.getProtocolBeanName());
        }
        targetAction.setConsentSupported(action.isConsentSupported());
        if (targetAction.getSubProtocols() != null) {
            collection = action.getSubProtocols();
            if (collection != null) {
                targetAction.getSubProtocols().clear();
                targetAction.getSubProtocols().addAll(collection);
            }
        } else {
            collection = action.getSubProtocols();
            if (collection != null) {
                targetAction.setSubProtocols(new ArrayList(collection));
            }
        }
        if (targetAction.getAuthSessions() != null) {
            collection1 = action.getAuthSessions();
            if (collection1 != null) {
                targetAction.getAuthSessions().clear();
                targetAction.getAuthSessions().addAll(collection1);
            }
        } else {
            collection1 = action.getAuthSessions();
            if (collection1 != null) {
                targetAction.setAuthSessions(new ArrayList(collection1));
            }
        }
    }

    protected List<de.adorsys.opba.adminapi.model.generated.BankProfile> bankProfileCollectionToBankProfileList(Collection<BankProfile> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<de.adorsys.opba.adminapi.model.generated.BankProfile> list = new ArrayList<de.adorsys.opba.adminapi.model.generated.BankProfile>(collection.size());
        for (BankProfile bankProfile : collection) {
            list.add(this.bankProfileToBankProfile(bankProfile));
        }
        return list;
    }

    protected BankProfile.ScaApproachesEnum approachToScaApproachesEnum(Approach approach) {
        BankProfile.ScaApproachesEnum scaApproachesEnum;
        if (approach == null) {
            return null;
        }
        switch (approach) {
            case REDIRECT: {
                scaApproachesEnum = BankProfile.ScaApproachesEnum.REDIRECT;
                break;
            }
            case EMBEDDED: {
                scaApproachesEnum = BankProfile.ScaApproachesEnum.EMBEDDED;
                break;
            }
            case DECOUPLED: {
                scaApproachesEnum = BankProfile.ScaApproachesEnum.DECOUPLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + approach);
            }
        }
        return scaApproachesEnum;
    }

    protected List<BankProfile.ScaApproachesEnum> approachListToScaApproachesEnumList(List<Approach> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BankProfile.ScaApproachesEnum> list1 = new ArrayList<BankProfile.ScaApproachesEnum>(list.size());
        for (Approach approach : list) {
            list1.add(this.approachToScaApproachesEnum(approach));
        }
        return list1;
    }

    protected BankProfile.PreferredApproachEnum approachToPreferredApproachEnum(Approach approach) {
        BankProfile.PreferredApproachEnum preferredApproachEnum;
        if (approach == null) {
            return null;
        }
        switch (approach) {
            case REDIRECT: {
                preferredApproachEnum = BankProfile.PreferredApproachEnum.REDIRECT;
                break;
            }
            case EMBEDDED: {
                preferredApproachEnum = BankProfile.PreferredApproachEnum.EMBEDDED;
                break;
            }
            case DECOUPLED: {
                preferredApproachEnum = BankProfile.PreferredApproachEnum.DECOUPLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + approach);
            }
        }
        return preferredApproachEnum;
    }

    protected BankAction.ProtocolActionEnum protocolActionToProtocolActionEnum(ProtocolAction protocolAction) {
        BankAction.ProtocolActionEnum protocolActionEnum;
        if (protocolAction == null) {
            return null;
        }
        switch (protocolAction) {
            case LIST_ACCOUNTS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.LIST_ACCOUNTS;
                break;
            }
            case LIST_TRANSACTIONS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.LIST_TRANSACTIONS;
                break;
            }
            case DELETE_CONSENT: {
                protocolActionEnum = BankAction.ProtocolActionEnum.DELETE_CONSENT;
                break;
            }
            case GET_CONSENT_STATUS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_CONSENT_STATUS;
                break;
            }
            case GET_AIS_AUTHORIZATION_STATUS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_AIS_AUTHORIZATION_STATUS;
                break;
            }
            case UPDATE_EXTERNAL_AIS_SESSION: {
                protocolActionEnum = BankAction.ProtocolActionEnum.UPDATE_EXTERNAL_AIS_SESSION;
                break;
            }
            case AUTHORIZATION: {
                protocolActionEnum = BankAction.ProtocolActionEnum.AUTHORIZATION;
                break;
            }
            case ON_LOGIN: {
                protocolActionEnum = BankAction.ProtocolActionEnum.ON_LOGIN;
                break;
            }
            case GET_AUTHORIZATION_STATE: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_AUTHORIZATION_STATE;
                break;
            }
            case UPDATE_AUTHORIZATION: {
                protocolActionEnum = BankAction.ProtocolActionEnum.UPDATE_AUTHORIZATION;
                break;
            }
            case DENY_AUTHORIZATION: {
                protocolActionEnum = BankAction.ProtocolActionEnum.DENY_AUTHORIZATION;
                break;
            }
            case FROM_ASPSP_REDIRECT: {
                protocolActionEnum = BankAction.ProtocolActionEnum.FROM_ASPSP_REDIRECT;
                break;
            }
            case SINGLE_PAYMENT: {
                protocolActionEnum = BankAction.ProtocolActionEnum.SINGLE_PAYMENT;
                break;
            }
            case GET_PAYMENT_STATUS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_PAYMENT_STATUS;
                break;
            }
            case GET_PAYMENT_INFORMATION: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_PAYMENT_INFORMATION;
                break;
            }
            case GET_PIS_AUTHORIZATION_STATUS: {
                protocolActionEnum = BankAction.ProtocolActionEnum.GET_PIS_AUTHORIZATION_STATUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + protocolAction);
            }
        }
        return protocolActionEnum;
    }

    protected BankSubAction.ProtocolActionEnum protocolActionToProtocolActionEnum1(ProtocolAction protocolAction) {
        BankSubAction.ProtocolActionEnum protocolActionEnum;
        if (protocolAction == null) {
            return null;
        }
        switch (protocolAction) {
            case LIST_ACCOUNTS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.LIST_ACCOUNTS;
                break;
            }
            case LIST_TRANSACTIONS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.LIST_TRANSACTIONS;
                break;
            }
            case DELETE_CONSENT: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.DELETE_CONSENT;
                break;
            }
            case GET_CONSENT_STATUS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_CONSENT_STATUS;
                break;
            }
            case GET_AIS_AUTHORIZATION_STATUS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_AIS_AUTHORIZATION_STATUS;
                break;
            }
            case UPDATE_EXTERNAL_AIS_SESSION: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.UPDATE_EXTERNAL_AIS_SESSION;
                break;
            }
            case AUTHORIZATION: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.AUTHORIZATION;
                break;
            }
            case ON_LOGIN: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.ON_LOGIN;
                break;
            }
            case GET_AUTHORIZATION_STATE: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_AUTHORIZATION_STATE;
                break;
            }
            case UPDATE_AUTHORIZATION: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.UPDATE_AUTHORIZATION;
                break;
            }
            case DENY_AUTHORIZATION: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.DENY_AUTHORIZATION;
                break;
            }
            case FROM_ASPSP_REDIRECT: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.FROM_ASPSP_REDIRECT;
                break;
            }
            case SINGLE_PAYMENT: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.SINGLE_PAYMENT;
                break;
            }
            case GET_PAYMENT_STATUS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_PAYMENT_STATUS;
                break;
            }
            case GET_PAYMENT_INFORMATION: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_PAYMENT_INFORMATION;
                break;
            }
            case GET_PIS_AUTHORIZATION_STATUS: {
                protocolActionEnum = BankSubAction.ProtocolActionEnum.GET_PIS_AUTHORIZATION_STATUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + protocolAction);
            }
        }
        return protocolActionEnum;
    }

    protected BankSubAction bankSubActionToBankSubAction(de.adorsys.opba.db.domain.entity.BankSubAction bankSubAction) {
        if (bankSubAction == null) {
            return null;
        }
        BankSubAction bankSubAction1 = new BankSubAction();
        bankSubAction1.setProtocolAction(this.protocolActionToProtocolActionEnum1(bankSubAction.getProtocolAction()));
        bankSubAction1.setSubProtocolBeanName(bankSubAction.getSubProtocolBeanName());
        return bankSubAction1;
    }

    protected List<BankSubAction> bankSubActionCollectionToBankSubActionList(Collection<de.adorsys.opba.db.domain.entity.BankSubAction> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<BankSubAction> list = new ArrayList<BankSubAction>(collection.size());
        for (de.adorsys.opba.db.domain.entity.BankSubAction bankSubAction : collection) {
            list.add(this.bankSubActionToBankSubAction(bankSubAction));
        }
        return list;
    }

    protected de.adorsys.opba.adminapi.model.generated.BankAction bankActionToBankAction(BankAction bankAction) {
        if (bankAction == null) {
            return null;
        }
        de.adorsys.opba.adminapi.model.generated.BankAction bankAction1 = new de.adorsys.opba.adminapi.model.generated.BankAction();
        bankAction1.setProtocolAction(this.protocolActionToProtocolActionEnum(bankAction.getProtocolAction()));
        bankAction1.setProtocolBeanName(bankAction.getProtocolBeanName());
        bankAction1.setConsentSupported(Boolean.valueOf(bankAction.isConsentSupported()));
        bankAction1.setSubProtocols(this.bankSubActionCollectionToBankSubActionList(bankAction.getSubProtocols()));
        return bankAction1;
    }

    protected Map<String, de.adorsys.opba.adminapi.model.generated.BankAction> protocolActionBankActionMapToStringBankActionMap(Map<ProtocolAction, BankAction> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, de.adorsys.opba.adminapi.model.generated.BankAction> map1 = new HashMap<String, de.adorsys.opba.adminapi.model.generated.BankAction>(Math.max((int)((float)map.size() / 0.75f) + 1, 16));
        for (Map.Entry<ProtocolAction, BankAction> entry : map.entrySet()) {
            String key = entry.getKey().name();
            de.adorsys.opba.adminapi.model.generated.BankAction value = this.bankActionToBankAction(entry.getValue());
            map1.put(key, value);
        }
        return map1;
    }

    protected de.adorsys.opba.db.domain.entity.Bank bankToBank1(Bank bank) {
        if (bank == null) {
            return null;
        }
        Bank.BankBuilder bank1 = de.adorsys.opba.db.domain.entity.Bank.builder();
        bank1.name(bank.getName());
        bank1.bic(bank.getBic());
        bank1.bankCode(bank.getBankCode());
        return bank1.build();
    }

    protected Approach scaApproachesEnumToApproach(BankProfile.ScaApproachesEnum scaApproachesEnum) {
        Approach approach;
        if (scaApproachesEnum == null) {
            return null;
        }
        switch (scaApproachesEnum) {
            case REDIRECT: {
                approach = Approach.REDIRECT;
                break;
            }
            case EMBEDDED: {
                approach = Approach.EMBEDDED;
                break;
            }
            case DECOUPLED: {
                approach = Approach.DECOUPLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaApproachesEnum);
            }
        }
        return approach;
    }

    protected List<Approach> scaApproachesEnumListToApproachList(List<BankProfile.ScaApproachesEnum> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Approach> list1 = new ArrayList<Approach>(list.size());
        for (BankProfile.ScaApproachesEnum scaApproachesEnum : list) {
            list1.add(this.scaApproachesEnumToApproach(scaApproachesEnum));
        }
        return list1;
    }

    protected Approach preferredApproachEnumToApproach(BankProfile.PreferredApproachEnum preferredApproachEnum) {
        Approach approach;
        if (preferredApproachEnum == null) {
            return null;
        }
        switch (preferredApproachEnum) {
            case REDIRECT: {
                approach = Approach.REDIRECT;
                break;
            }
            case EMBEDDED: {
                approach = Approach.EMBEDDED;
                break;
            }
            case DECOUPLED: {
                approach = Approach.DECOUPLED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + preferredApproachEnum);
            }
        }
        return approach;
    }

    protected BankProfile bankProfileToBankProfile1(de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile) {
        if (bankProfile == null) {
            return null;
        }
        BankProfile.BankProfileBuilder bankProfile1 = BankProfile.builder();
        bankProfile1.id(bankProfile.getId());
        bankProfile1.url(bankProfile.getUrl());
        bankProfile1.adapterId(bankProfile.getAdapterId());
        bankProfile1.idpUrl(bankProfile.getIdpUrl());
        bankProfile1.uuid(bankProfile.getUuid());
        bankProfile1.name(bankProfile.getName());
        bankProfile1.scaApproaches(this.scaApproachesEnumListToApproachList(bankProfile.getScaApproaches()));
        bankProfile1.preferredApproach(this.preferredApproachEnumToApproach(bankProfile.getPreferredApproach()));
        if (bankProfile.isTryToUsePreferredApproach() != null) {
            bankProfile1.tryToUsePreferredApproach(bankProfile.isTryToUsePreferredApproach().booleanValue());
        }
        if (bankProfile.isUniquePaymentPurpose() != null) {
            bankProfile1.uniquePaymentPurpose(bankProfile.isUniquePaymentPurpose().booleanValue());
        }
        bankProfile1.externalId(bankProfile.getExternalId());
        bankProfile1.externalInterfaces(bankProfile.getExternalInterfaces());
        bankProfile1.protocolType(bankProfile.getProtocolType());
        if (bankProfile.isIsSandbox() != null) {
            bankProfile1.isSandbox(bankProfile.isIsSandbox().booleanValue());
        }
        bankProfile1.actions(this.mapActions(bankProfile.getActions()));
        return bankProfile1.build();
    }

    protected Collection<BankProfile> bankProfileListToBankProfileCollection(List<de.adorsys.opba.adminapi.model.generated.BankProfile> list) {
        if (list == null) {
            return null;
        }
        ArrayList<BankProfile> collection = new ArrayList<BankProfile>(list.size());
        for (de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile : list) {
            collection.add(this.bankProfileToBankProfile1(bankProfile));
        }
        return collection;
    }

    protected ProtocolAction protocolActionEnumToProtocolAction(BankAction.ProtocolActionEnum protocolActionEnum) {
        ProtocolAction protocolAction;
        if (protocolActionEnum == null) {
            return null;
        }
        switch (protocolActionEnum) {
            case LIST_ACCOUNTS: {
                protocolAction = ProtocolAction.LIST_ACCOUNTS;
                break;
            }
            case LIST_TRANSACTIONS: {
                protocolAction = ProtocolAction.LIST_TRANSACTIONS;
                break;
            }
            case DELETE_CONSENT: {
                protocolAction = ProtocolAction.DELETE_CONSENT;
                break;
            }
            case GET_CONSENT_STATUS: {
                protocolAction = ProtocolAction.GET_CONSENT_STATUS;
                break;
            }
            case GET_AIS_AUTHORIZATION_STATUS: {
                protocolAction = ProtocolAction.GET_AIS_AUTHORIZATION_STATUS;
                break;
            }
            case UPDATE_EXTERNAL_AIS_SESSION: {
                protocolAction = ProtocolAction.UPDATE_EXTERNAL_AIS_SESSION;
                break;
            }
            case AUTHORIZATION: {
                protocolAction = ProtocolAction.AUTHORIZATION;
                break;
            }
            case ON_LOGIN: {
                protocolAction = ProtocolAction.ON_LOGIN;
                break;
            }
            case GET_AUTHORIZATION_STATE: {
                protocolAction = ProtocolAction.GET_AUTHORIZATION_STATE;
                break;
            }
            case UPDATE_AUTHORIZATION: {
                protocolAction = ProtocolAction.UPDATE_AUTHORIZATION;
                break;
            }
            case DENY_AUTHORIZATION: {
                protocolAction = ProtocolAction.DENY_AUTHORIZATION;
                break;
            }
            case FROM_ASPSP_REDIRECT: {
                protocolAction = ProtocolAction.FROM_ASPSP_REDIRECT;
                break;
            }
            case SINGLE_PAYMENT: {
                protocolAction = ProtocolAction.SINGLE_PAYMENT;
                break;
            }
            case GET_PAYMENT_STATUS: {
                protocolAction = ProtocolAction.GET_PAYMENT_STATUS;
                break;
            }
            case GET_PAYMENT_INFORMATION: {
                protocolAction = ProtocolAction.GET_PAYMENT_INFORMATION;
                break;
            }
            case GET_PIS_AUTHORIZATION_STATUS: {
                protocolAction = ProtocolAction.GET_PIS_AUTHORIZATION_STATUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + protocolActionEnum);
            }
        }
        return protocolAction;
    }

    protected ProtocolAction protocolActionEnumToProtocolAction1(BankSubAction.ProtocolActionEnum protocolActionEnum) {
        ProtocolAction protocolAction;
        if (protocolActionEnum == null) {
            return null;
        }
        switch (protocolActionEnum) {
            case LIST_ACCOUNTS: {
                protocolAction = ProtocolAction.LIST_ACCOUNTS;
                break;
            }
            case LIST_TRANSACTIONS: {
                protocolAction = ProtocolAction.LIST_TRANSACTIONS;
                break;
            }
            case DELETE_CONSENT: {
                protocolAction = ProtocolAction.DELETE_CONSENT;
                break;
            }
            case GET_CONSENT_STATUS: {
                protocolAction = ProtocolAction.GET_CONSENT_STATUS;
                break;
            }
            case GET_AIS_AUTHORIZATION_STATUS: {
                protocolAction = ProtocolAction.GET_AIS_AUTHORIZATION_STATUS;
                break;
            }
            case UPDATE_EXTERNAL_AIS_SESSION: {
                protocolAction = ProtocolAction.UPDATE_EXTERNAL_AIS_SESSION;
                break;
            }
            case AUTHORIZATION: {
                protocolAction = ProtocolAction.AUTHORIZATION;
                break;
            }
            case ON_LOGIN: {
                protocolAction = ProtocolAction.ON_LOGIN;
                break;
            }
            case GET_AUTHORIZATION_STATE: {
                protocolAction = ProtocolAction.GET_AUTHORIZATION_STATE;
                break;
            }
            case UPDATE_AUTHORIZATION: {
                protocolAction = ProtocolAction.UPDATE_AUTHORIZATION;
                break;
            }
            case DENY_AUTHORIZATION: {
                protocolAction = ProtocolAction.DENY_AUTHORIZATION;
                break;
            }
            case FROM_ASPSP_REDIRECT: {
                protocolAction = ProtocolAction.FROM_ASPSP_REDIRECT;
                break;
            }
            case SINGLE_PAYMENT: {
                protocolAction = ProtocolAction.SINGLE_PAYMENT;
                break;
            }
            case GET_PAYMENT_STATUS: {
                protocolAction = ProtocolAction.GET_PAYMENT_STATUS;
                break;
            }
            case GET_PAYMENT_INFORMATION: {
                protocolAction = ProtocolAction.GET_PAYMENT_INFORMATION;
                break;
            }
            case GET_PIS_AUTHORIZATION_STATUS: {
                protocolAction = ProtocolAction.GET_PIS_AUTHORIZATION_STATUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + protocolActionEnum);
            }
        }
        return protocolAction;
    }

    protected de.adorsys.opba.db.domain.entity.BankSubAction bankSubActionToBankSubAction1(BankSubAction bankSubAction) {
        if (bankSubAction == null) {
            return null;
        }
        BankSubAction.BankSubActionBuilder bankSubAction1 = de.adorsys.opba.db.domain.entity.BankSubAction.builder();
        bankSubAction1.protocolAction(this.protocolActionEnumToProtocolAction1(bankSubAction.getProtocolAction()));
        bankSubAction1.subProtocolBeanName(bankSubAction.getSubProtocolBeanName());
        return bankSubAction1.build();
    }

    protected Collection<de.adorsys.opba.db.domain.entity.BankSubAction> bankSubActionListToBankSubActionCollection(List<BankSubAction> list) {
        if (list == null) {
            return null;
        }
        ArrayList<de.adorsys.opba.db.domain.entity.BankSubAction> collection = new ArrayList<de.adorsys.opba.db.domain.entity.BankSubAction>(list.size());
        for (BankSubAction bankSubAction : list) {
            collection.add(this.bankSubActionToBankSubAction1(bankSubAction));
        }
        return collection;
    }

    protected BankAction bankActionToBankAction1(de.adorsys.opba.adminapi.model.generated.BankAction bankAction) {
        if (bankAction == null) {
            return null;
        }
        BankAction.BankActionBuilder bankAction1 = BankAction.builder();
        bankAction1.protocolAction(this.protocolActionEnumToProtocolAction(bankAction.getProtocolAction()));
        bankAction1.protocolBeanName(bankAction.getProtocolBeanName());
        if (bankAction.isConsentSupported() != null) {
            bankAction1.consentSupported(bankAction.isConsentSupported().booleanValue());
        }
        bankAction1.subProtocols(this.bankSubActionListToBankSubActionCollection(bankAction.getSubProtocols()));
        return bankAction1.build();
    }
}

