/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.adminapi.service;

import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.model.generated.PageBankData;
import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.BankAction;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.repository.jpa.BankProfileJpaRepository;
import de.adorsys.opba.db.repository.jpa.BankRepository;
import de.adorsys.opba.db.repository.jpa.ConsentRepository;
import de.adorsys.opba.db.repository.jpa.PaymentRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyInboxRepository;
import de.adorsys.opba.db.repository.jpa.fintech.FintechPsuAspspPrvKeyRepository;
import de.adorsys.opba.db.repository.jpa.psu.PsuAspspPrvKeyRepository;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Profile(value={"!no-admin-api"})
@Service
public class AdminApiService {
    private static final String ADMIN_MAPPERS_PACKAGE = "de.adorsys.opba.adminapi.service.mappers";
    private final BankRepository bankRepository;
    private final BankProfileJpaRepository bankProfileJpaRepository;
    private final PsuAspspPrvKeyRepository psuAspspPrvKeyRepository;
    private final FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository;
    private final FintechPsuAspspPrvKeyInboxRepository fintechPsuAspspPrvKeyInboxRepository;
    private final PaymentRepository paymentRepository;
    private final ConsentRepository consentRepository;
    private final BankMapper bankMapper;
    private final PageMapper pageMapper;

    @Transactional(readOnly=true)
    public PageBankData getBankDatas(Integer page, Integer size) {
        Page bankPage = this.bankRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((String[])new String[]{"id"})));
        PageBankData result = new PageBankData();
        result.setContent(this.pageMapper.map((Page<Bank>)bankPage).getData().stream().map(BankData::getBank).collect(Collectors.toList()));
        result.setNumber(page);
        result.setSize(size);
        result.setTotalPages(Integer.valueOf(bankPage.getTotalPages()));
        result.setTotalElements(Long.valueOf(bankPage.getTotalElements()));
        return result;
    }

    @Transactional(readOnly=true)
    public BankData getBankDataByBankId(UUID bankId) {
        Optional bank = this.bankRepository.findByUuid(bankId);
        return bank.map(this::mapBankAndAddProfile).orElse(null);
    }

    @Transactional
    public BankData createOrReplaceBank(UUID bankId, BankData bankData) {
        BankDataToMap mapped = this.bankMapper.map(bankData);
        if (null == bankData.getBank()) {
            throw new IllegalStateException("Bank should not be null");
        }
        BankDataToMap result = new BankDataToMap();
        mapped.getBank().setUuid(bankId);
        Bank bank = (Bank)this.bankRepository.save((Object)mapped.getBank());
        result.setBank(bank);
        if (null != mapped.getProfiles()) {
            Collection<BankProfile> profiles = this.saveBankProfileAndActions(mapped, bank);
            result.setProfiles(profiles);
        }
        return this.bankMapper.map(result);
    }

    @Transactional
    public BankData updateBank(UUID bankId, BankData bankData) {
        Bank bank = (Bank)this.bankRepository.findByUuid(bankId).orElseThrow(() -> new EntityNotFoundException("No bank: " + bankId));
        this.bankMapper.mapToBank(bankData.getBank(), bank);
        bank = (Bank)this.bankRepository.save((Object)bank);
        if (null == bankData.getProfiles()) {
            return this.mapBankAndAddProfile(bank);
        }
        Map profilesByUuid = bank.getProfiles().stream().collect(Collectors.toMap(BankProfile::getUuid, Function.identity()));
        bankData.getProfiles().stream().filter(it -> profilesByUuid.containsKey(it.getUuid())).forEach(profile -> this.bankMapper.mapToProfile((de.adorsys.opba.adminapi.model.generated.BankProfile)profile, (BankProfile)profilesByUuid.get(profile.getUuid())));
        bank.getProfiles().clear();
        for (de.adorsys.opba.adminapi.model.generated.BankProfile profile2 : bankData.getProfiles()) {
            BankProfile dbProfile = (BankProfile)profilesByUuid.remove(profile2.getUuid());
            if (null == dbProfile) {
                dbProfile = new BankProfile();
            }
            this.bankMapper.mapToProfile(profile2, dbProfile);
            dbProfile.setBank(bank);
            if (null != profile2.getActions()) {
                dbProfile.getActions().clear();
                dbProfile = (BankProfile)this.bankProfileJpaRepository.saveAndFlush((Object)dbProfile);
                dbProfile.getActions().putAll(this.bankMapper.mapActions(profile2.getActions()));
                BankProfile finalDbProfile = dbProfile;
                dbProfile.getActions().forEach((key, action) -> this.updateActions(finalDbProfile, (BankAction)action));
            }
            this.bankProfileJpaRepository.save((Object)dbProfile);
        }
        this.bankProfileJpaRepository.deleteAll(profilesByUuid.values());
        return this.mapBankAndAddProfile(bank);
    }

    @Transactional
    public void deleteBank(UUID bankId) {
        Bank bank = (Bank)this.bankRepository.findByUuid(bankId).orElseThrow(() -> new EntityNotFoundException("No bank: " + bankId));
        this.bankProfileJpaRepository.deleteByBank(bank);
        this.psuAspspPrvKeyRepository.deleteByAspsp(bank);
        this.fintechPsuAspspPrvKeyRepository.deleteByAspsp(bank);
        this.fintechPsuAspspPrvKeyInboxRepository.deleteByAspsp(bank);
        this.paymentRepository.deleteByAspsp(bank);
        this.consentRepository.deleteByAspsp(bank);
        this.bankRepository.delete((Object)bank);
    }

    @NotNull
    private Collection<BankProfile> saveBankProfileAndActions(BankDataToMap mapped, Bank bank) {
        mapped.getProfiles().forEach(it -> it.setBank(bank));
        mapped.getProfiles().forEach(it -> it.getActions().forEach((key, action) -> this.updateActions((BankProfile)it, (BankAction)action)));
        return this.bankProfileJpaRepository.saveAll(mapped.getProfiles());
    }

    private void updateActions(BankProfile profile, BankAction action) {
        action.setBankProfile(profile);
        if (null == action.getProtocolBeanName()) {
            action.setProtocolBeanName("");
        }
        if (null != action.getSubProtocols()) {
            action.getSubProtocols().forEach(it -> it.setAction(action));
        }
    }

    @NotNull
    private BankData mapBankAndAddProfile(Bank bank) {
        BankDataToMap result = new BankDataToMap();
        result.setBank(bank);
        result.setProfiles(bank.getProfiles());
        return this.bankMapper.map(result);
    }

    @ConstructorProperties(value={"bankRepository", "bankProfileJpaRepository", "psuAspspPrvKeyRepository", "fintechPsuAspspPrvKeyRepository", "fintechPsuAspspPrvKeyInboxRepository", "paymentRepository", "consentRepository", "bankMapper", "pageMapper"})
    @Generated
    public AdminApiService(BankRepository bankRepository, BankProfileJpaRepository bankProfileJpaRepository, PsuAspspPrvKeyRepository psuAspspPrvKeyRepository, FintechPsuAspspPrvKeyRepository fintechPsuAspspPrvKeyRepository, FintechPsuAspspPrvKeyInboxRepository fintechPsuAspspPrvKeyInboxRepository, PaymentRepository paymentRepository, ConsentRepository consentRepository, BankMapper bankMapper, PageMapper pageMapper) {
        this.bankRepository = bankRepository;
        this.bankProfileJpaRepository = bankProfileJpaRepository;
        this.psuAspspPrvKeyRepository = psuAspspPrvKeyRepository;
        this.fintechPsuAspspPrvKeyRepository = fintechPsuAspspPrvKeyRepository;
        this.fintechPsuAspspPrvKeyInboxRepository = fintechPsuAspspPrvKeyInboxRepository;
        this.paymentRepository = paymentRepository;
        this.consentRepository = consentRepository;
        this.bankMapper = bankMapper;
        this.pageMapper = pageMapper;
    }

    public static class BankDataToMap {
        private Bank bank;
        private Collection<BankProfile> profiles;

        @Generated
        public BankDataToMap() {
        }

        @Generated
        public Bank getBank() {
            return this.bank;
        }

        @Generated
        public Collection<BankProfile> getProfiles() {
            return this.profiles;
        }

        @Generated
        public void setBank(Bank bank) {
            this.bank = bank;
        }

        @Generated
        public void setProfiles(Collection<BankProfile> profiles) {
            this.profiles = profiles;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BankDataToMap)) {
                return false;
            }
            BankDataToMap other = (BankDataToMap)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Bank this$bank = this.getBank();
            Bank other$bank = other.getBank();
            if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                return false;
            }
            Collection<BankProfile> this$profiles = this.getProfiles();
            Collection<BankProfile> other$profiles = other.getProfiles();
            return !(this$profiles == null ? other$profiles != null : !((Object)this$profiles).equals(other$profiles));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BankDataToMap;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Bank $bank = this.getBank();
            result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
            Collection<BankProfile> $profiles = this.getProfiles();
            result = result * 59 + ($profiles == null ? 43 : ((Object)$profiles).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AdminApiService.BankDataToMap(bank=" + this.getBank() + ", profiles=" + this.getProfiles() + ")";
        }
    }

    public static class PageBankDataMappable
    extends PageBankData
    implements List<BankData> {
        private List<BankData> data = new ArrayList<BankData>();

        @Generated
        public List<BankData> getData() {
            return this.data;
        }

        @Override
        @Generated
        public int size() {
            return this.getData().size();
        }

        @Override
        @Generated
        public boolean isEmpty() {
            return this.getData().isEmpty();
        }

        @Override
        @Generated
        public boolean contains(Object arg0) {
            return this.getData().contains(arg0);
        }

        @Override
        @Generated
        public Iterator<BankData> iterator() {
            return this.getData().iterator();
        }

        @Override
        @Generated
        public Object[] toArray() {
            return this.getData().toArray();
        }

        @Override
        @Generated
        public <T> T[] toArray(T[] arg0) {
            return this.getData().toArray(arg0);
        }

        @Override
        @Generated
        public boolean add(BankData arg0) {
            return this.getData().add(arg0);
        }

        @Override
        @Generated
        public boolean remove(Object arg0) {
            return this.getData().remove(arg0);
        }

        @Override
        @Generated
        public boolean containsAll(Collection<?> arg0) {
            return this.getData().containsAll(arg0);
        }

        @Override
        @Generated
        public boolean addAll(Collection<? extends BankData> arg0) {
            return this.getData().addAll(arg0);
        }

        @Override
        @Generated
        public boolean addAll(int arg0, Collection<? extends BankData> arg1) {
            return this.getData().addAll(arg0, arg1);
        }

        @Override
        @Generated
        public boolean removeAll(Collection<?> arg0) {
            return this.getData().removeAll(arg0);
        }

        @Override
        @Generated
        public boolean retainAll(Collection<?> arg0) {
            return this.getData().retainAll(arg0);
        }

        @Override
        @Generated
        public void replaceAll(UnaryOperator<BankData> operator) {
            this.getData().replaceAll(operator);
        }

        @Override
        @Generated
        public void sort(Comparator<? super BankData> c) {
            this.getData().sort(c);
        }

        @Override
        @Generated
        public void clear() {
            this.getData().clear();
        }

        @Override
        @Generated
        public BankData get(int arg0) {
            return this.getData().get(arg0);
        }

        @Override
        @Generated
        public BankData set(int arg0, BankData arg1) {
            return this.getData().set(arg0, arg1);
        }

        @Override
        @Generated
        public void add(int arg0, BankData arg1) {
            this.getData().add(arg0, arg1);
        }

        @Override
        @Generated
        public BankData remove(int arg0) {
            return this.getData().remove(arg0);
        }

        @Override
        @Generated
        public int indexOf(Object arg0) {
            return this.getData().indexOf(arg0);
        }

        @Override
        @Generated
        public int lastIndexOf(Object arg0) {
            return this.getData().lastIndexOf(arg0);
        }

        @Override
        @Generated
        public ListIterator<BankData> listIterator() {
            return this.getData().listIterator();
        }

        @Override
        @Generated
        public ListIterator<BankData> listIterator(int arg0) {
            return this.getData().listIterator(arg0);
        }

        @Override
        @Generated
        public List<BankData> subList(int arg0, int arg1) {
            return this.getData().subList(arg0, arg1);
        }

        @Override
        @Generated
        public Spliterator<BankData> spliterator() {
            return this.getData().spliterator();
        }
    }

    @Mapper(componentModel="spring", implementationPackage="de.adorsys.opba.adminapi.service.mappers", uses={BankMapper.class})
    public static interface PageMapper {
        @Mapping(target="bank", source=".")
        public BankData map(Bank var1);

        @Mapping(target="content", ignore=true)
        public PageBankDataMappable map(Page<Bank> var1);
    }

    @Mapper(componentModel="spring", nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, implementationPackage="de.adorsys.opba.adminapi.service.mappers")
    public static interface BankMapper {
        public BankData map(BankDataToMap var1);

        @Mapping(target="isActive", source="active")
        public de.adorsys.opba.adminapi.model.generated.Bank bankToBank(Bank var1);

        @Mapping(target="isActive", source="active")
        public de.adorsys.opba.adminapi.model.generated.BankProfile bankProfileToBankProfile(BankProfile var1);

        @Mappings(value={@Mapping(target="bank.id", ignore=true), @Mapping(target="bank.uuid", ignore=true), @Mapping(target="profile.id", ignore=true)})
        public BankDataToMap map(BankData var1);

        @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="uuid", ignore=true), @Mapping(target="active", source="isActive")})
        public void mapToBank(de.adorsys.opba.adminapi.model.generated.Bank var1, @MappingTarget Bank var2);

        @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="actions", ignore=true), @Mapping(target="active", source="isActive")})
        public void mapToProfile(de.adorsys.opba.adminapi.model.generated.BankProfile var1, @MappingTarget BankProfile var2);

        public Map<ProtocolAction, BankAction> mapActions(Map<String, de.adorsys.opba.adminapi.model.generated.BankAction> var1);

        @Mapping(target="id", ignore=true)
        public void mapAction(BankAction var1, @MappingTarget BankAction var2);
    }
}

