/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.adminapi.controller;

import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.model.generated.PageBankData;
import de.adorsys.opba.adminapi.resource.generated.AdminApiControllerApi;
import de.adorsys.opba.adminapi.service.AdminApiService;
import java.beans.ConstructorProperties;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.springframework.context.annotation.Profile;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"!no-admin-api"})
@RestController
public class AdminApiController
implements AdminApiControllerApi {
    private final AdminApiService adminApiService;

    public ResponseEntity<BankData> createNewBankDataEntry(UUID bankId, @Valid BankData body) {
        return ResponseEntity.ok((Object)this.adminApiService.createOrReplaceBank(bankId, body));
    }

    public ResponseEntity<BankData> deleteBankDataEntry(UUID bankId) {
        this.adminApiService.deleteBank(bankId);
        return ResponseEntity.ok().build();
    }

    public ResponseEntity<BankData> getBankDataById(@NotNull @Valid UUID bankId) {
        BankData data = this.adminApiService.getBankDataByBankId(bankId);
        if (null == data) {
            return ResponseEntity.notFound().build();
        }
        return ResponseEntity.ok((Object)data);
    }

    public ResponseEntity<PageBankData> getBanksData(Integer page, Integer size) {
        return ResponseEntity.ok((Object)this.adminApiService.getBankDatas(page, size));
    }

    public ResponseEntity<BankData> updateBankDataEntry(UUID bankId, @Valid BankData body) {
        return ResponseEntity.ok((Object)this.adminApiService.updateBank(bankId, body));
    }

    @ConstructorProperties(value={"adminApiService"})
    @Generated
    public AdminApiController(AdminApiService adminApiService) {
        this.adminApiService = adminApiService;
    }
}

