/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.adminapi.config;

import de.adorsys.opba.adminapi.config.AdminApiSecurityFilter;
import de.adorsys.opba.api.security.internal.EnableSignatureBasedApiSecurity;
import java.util.Set;
import javax.servlet.Filter;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Profile;
import org.springframework.validation.annotation.Validated;

@Validated
@EnableSignatureBasedApiSecurity
@Profile(value={"!no-admin-api"})
@ConfigurationProperties(prefix="api.banking.admin-api.security")
public class AdminApiSecurityFilterConfig {
    @NotBlank
    private String login;
    @NotBlank
    private String password;
    private @NotEmpty Set<@NotBlank String> urlPatternsToProtect;

    @Bean
    @Profile(value={"!no-admin-api-security"})
    public FilterRegistrationBean<AdminApiSecurityFilter> adminApiSecurity() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean();
        registrationBean.setFilter((Filter)new AdminApiSecurityFilter(this.login, this.password));
        registrationBean.setUrlPatterns(this.urlPatternsToProtect);
        return registrationBean;
    }

    @Generated
    public AdminApiSecurityFilterConfig() {
    }

    @Generated
    public String getLogin() {
        return this.login;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public Set<@NotBlank String> getUrlPatternsToProtect() {
        return this.urlPatternsToProtect;
    }

    @Generated
    public void setLogin(String login) {
        this.login = login;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUrlPatternsToProtect(Set<@NotBlank String> urlPatternsToProtect) {
        this.urlPatternsToProtect = urlPatternsToProtect;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminApiSecurityFilterConfig)) {
            return false;
        }
        AdminApiSecurityFilterConfig other = (AdminApiSecurityFilterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$login = this.getLogin();
        String other$login = other.getLogin();
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        Set<String> this$urlPatternsToProtect = this.getUrlPatternsToProtect();
        Set<String> other$urlPatternsToProtect = other.getUrlPatternsToProtect();
        return !(this$urlPatternsToProtect == null ? other$urlPatternsToProtect != null : !((Object)this$urlPatternsToProtect).equals(other$urlPatternsToProtect));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AdminApiSecurityFilterConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $login = this.getLogin();
        result = result * 59 + ($login == null ? 43 : $login.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        Set<String> $urlPatternsToProtect = this.getUrlPatternsToProtect();
        result = result * 59 + ($urlPatternsToProtect == null ? 43 : ((Object)$urlPatternsToProtect).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AdminApiSecurityFilterConfig(login=" + this.getLogin() + ", password=" + this.getPassword() + ", urlPatternsToProtect=" + this.getUrlPatternsToProtect() + ")";
    }
}

