/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.adminapi.config;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminApiSecurityFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminApiSecurityFilter.class);
    private static final int BASIC_KEYWORD_LEN = 6;
    private final String expectedAuth;

    public AdminApiSecurityFilter(String login, String password) {
        this.expectedAuth = Base64.getEncoder().encodeToString((login + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String path = request.getRequestURI();
        String authHeader = request.getHeader("Authorization");
        if (Strings.isEmpty((CharSequence)authHeader) || !authHeader.startsWith("Basic ")) {
            log.warn("Missing or wrong Authorization header for {}", (Object)path);
            response.sendError(401, "Missing authorization");
            return;
        }
        String authData = authHeader.substring(6);
        if (!this.expectedAuth.equals(authData)) {
            log.warn("Bad credentials for {}", (Object)path);
            response.sendError(401, "Wrong credentials");
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

