package de.adorsys.opba.adminapi.service.mappers;

import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.service.AdminApiService.BankMapper;
import de.adorsys.opba.adminapi.service.AdminApiService.PageBankDataMappable;
import de.adorsys.opba.adminapi.service.AdminApiService.PageMapper;
import de.adorsys.opba.db.domain.entity.Bank;
import de.adorsys.opba.db.domain.entity.BankProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-10-11T15:56:41+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class AdminApiService$PageMapperImpl implements PageMapper {

    @Autowired
    private BankMapper bankMapper;

    @Override
    public BankData map(Bank bank) {
        if ( bank == null ) {
            return null;
        }

        BankData bankData = new BankData();

        bankData.setBank( bankMapper.bankToBank( bank ) );
        bankData.setProfiles( bankProfileCollectionToBankProfileList( bank.getProfiles() ) );

        return bankData;
    }

    @Override
    public PageBankDataMappable map(Page<Bank> page) {
        if ( page == null ) {
            return null;
        }

        PageBankDataMappable pageBankDataMappable = new PageBankDataMappable();
        for ( Bank bank : page ) {
            pageBankDataMappable.add( map( bank ) );
        }

        return pageBankDataMappable;
    }

    protected List<de.adorsys.opba.adminapi.model.generated.BankProfile> bankProfileCollectionToBankProfileList(Collection<BankProfile> collection) {
        if ( collection == null ) {
            return null;
        }

        List<de.adorsys.opba.adminapi.model.generated.BankProfile> list = new ArrayList<de.adorsys.opba.adminapi.model.generated.BankProfile>( collection.size() );
        for ( BankProfile bankProfile : collection ) {
            list.add( bankMapper.bankProfileToBankProfile( bankProfile ) );
        }

        return list;
    }
}
