package de.adorsys.opba.adminapi.service.mappers;

import de.adorsys.opba.adminapi.model.generated.Bank;
import de.adorsys.opba.adminapi.model.generated.BankAction;
import de.adorsys.opba.adminapi.model.generated.BankAction.ProtocolActionEnum;
import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.model.generated.BankProfile.PreferredApproachEnum;
import de.adorsys.opba.adminapi.model.generated.BankProfile.ScaApproachesEnum;
import de.adorsys.opba.adminapi.service.AdminApiService.BankDataToMap;
import de.adorsys.opba.adminapi.service.AdminApiService.BankMapper;
import de.adorsys.opba.db.domain.entity.Bank.BankBuilder;
import de.adorsys.opba.db.domain.entity.BankAction.BankActionBuilder;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.domain.entity.BankProfile.BankProfileBuilder;
import de.adorsys.opba.db.domain.entity.BankSubAction;
import de.adorsys.opba.db.domain.entity.BankSubAction.BankSubActionBuilder;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.protocol.api.common.Approach;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-10-11T15:56:42+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class AdminApiService$BankMapperImpl implements BankMapper {

    @Override
    public BankData map(BankDataToMap bank) {
        if ( bank == null ) {
            return null;
        }

        BankData bankData = new BankData();

        bankData.setBank( bankToBank( bank.getBank() ) );
        bankData.setProfiles( bankProfileCollectionToBankProfileList( bank.getProfiles() ) );

        return bankData;
    }

    @Override
    public Bank bankToBank(de.adorsys.opba.db.domain.entity.Bank bank) {
        if ( bank == null ) {
            return null;
        }

        Bank bank1 = new Bank();

        bank1.setIsActive( bank.isActive() );
        bank1.setId( bank.getId() );
        bank1.setUuid( bank.getUuid() );
        bank1.setName( bank.getName() );
        bank1.setBic( bank.getBic() );
        bank1.setBankCode( bank.getBankCode() );

        return bank1;
    }

    @Override
    public de.adorsys.opba.adminapi.model.generated.BankProfile bankProfileToBankProfile(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile1 = new de.adorsys.opba.adminapi.model.generated.BankProfile();

        bankProfile1.setIsActive( bankProfile.isActive() );
        bankProfile1.setId( bankProfile.getId() );
        bankProfile1.setUrl( bankProfile.getUrl() );
        bankProfile1.setUuid( bankProfile.getUuid() );
        bankProfile1.setAdapterId( bankProfile.getAdapterId() );
        bankProfile1.setIdpUrl( bankProfile.getIdpUrl() );
        bankProfile1.setScaApproaches( approachListToScaApproachesEnumList( bankProfile.getScaApproaches() ) );
        bankProfile1.setPreferredApproach( approachToPreferredApproachEnum( bankProfile.getPreferredApproach() ) );
        bankProfile1.setTryToUsePreferredApproach( bankProfile.isTryToUsePreferredApproach() );
        bankProfile1.setUniquePaymentPurpose( bankProfile.isUniquePaymentPurpose() );
        bankProfile1.setActions( protocolActionBankActionMapToStringBankActionMap( bankProfile.getActions() ) );
        bankProfile1.setBankCode( bankProfile.getBankCode() );
        bankProfile1.setBic( bankProfile.getBic() );
        bankProfile1.setName( bankProfile.getName() );
        bankProfile1.setExternalId( bankProfile.getExternalId() );
        bankProfile1.setExternalInterfaces( bankProfile.getExternalInterfaces() );
        bankProfile1.setProtocolType( bankProfile.getProtocolType() );

        return bankProfile1;
    }

    @Override
    public BankDataToMap map(BankData bank) {
        if ( bank == null ) {
            return null;
        }

        BankDataToMap bankDataToMap = new BankDataToMap();

        bankDataToMap.setBank( bankToBank1( bank.getBank() ) );
        bankDataToMap.setProfiles( bankProfileListToBankProfileCollection( bank.getProfiles() ) );

        return bankDataToMap;
    }

    @Override
    public void mapToBank(Bank bankData, de.adorsys.opba.db.domain.entity.Bank bank) {
        if ( bankData == null ) {
            return;
        }

        if ( bankData.isIsActive() != null ) {
            bank.setActive( bankData.isIsActive() );
        }
        if ( bankData.getName() != null ) {
            bank.setName( bankData.getName() );
        }
        if ( bankData.getBic() != null ) {
            bank.setBic( bankData.getBic() );
        }
        if ( bankData.getBankCode() != null ) {
            bank.setBankCode( bankData.getBankCode() );
        }
    }

    @Override
    public void mapToProfile(de.adorsys.opba.adminapi.model.generated.BankProfile bankData, BankProfile bank) {
        if ( bankData == null ) {
            return;
        }

        if ( bankData.isIsActive() != null ) {
            bank.setActive( bankData.isIsActive() );
        }
        if ( bankData.getUrl() != null ) {
            bank.setUrl( bankData.getUrl() );
        }
        if ( bankData.getAdapterId() != null ) {
            bank.setAdapterId( bankData.getAdapterId() );
        }
        if ( bankData.getIdpUrl() != null ) {
            bank.setIdpUrl( bankData.getIdpUrl() );
        }
        if ( bankData.getUuid() != null ) {
            bank.setUuid( bankData.getUuid() );
        }
        if ( bankData.getName() != null ) {
            bank.setName( bankData.getName() );
        }
        if ( bank.getScaApproaches() != null ) {
            List<Approach> list = scaApproachesEnumListToApproachList( bankData.getScaApproaches() );
            if ( list != null ) {
                bank.getScaApproaches().clear();
                bank.getScaApproaches().addAll( list );
            }
        }
        else {
            List<Approach> list = scaApproachesEnumListToApproachList( bankData.getScaApproaches() );
            if ( list != null ) {
                bank.setScaApproaches( list );
            }
        }
        if ( bankData.getPreferredApproach() != null ) {
            bank.setPreferredApproach( preferredApproachEnumToApproach( bankData.getPreferredApproach() ) );
        }
        if ( bankData.isTryToUsePreferredApproach() != null ) {
            bank.setTryToUsePreferredApproach( bankData.isTryToUsePreferredApproach() );
        }
        if ( bankData.isUniquePaymentPurpose() != null ) {
            bank.setUniquePaymentPurpose( bankData.isUniquePaymentPurpose() );
        }
        if ( bankData.getExternalId() != null ) {
            bank.setExternalId( bankData.getExternalId() );
        }
        if ( bankData.getExternalInterfaces() != null ) {
            bank.setExternalInterfaces( bankData.getExternalInterfaces() );
        }
        if ( bankData.getProtocolType() != null ) {
            bank.setProtocolType( bankData.getProtocolType() );
        }
    }

    @Override
    public Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> mapActions(Map<String, BankAction> map) {
        if ( map == null ) {
            return null;
        }

        Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> map1 = new HashMap<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, BankAction> entry : map.entrySet() ) {
            ProtocolAction key = Enum.valueOf( ProtocolAction.class, entry.getKey() );
            de.adorsys.opba.db.domain.entity.BankAction value = bankActionToBankAction1( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    @Override
    public void mapAction(de.adorsys.opba.db.domain.entity.BankAction action, de.adorsys.opba.db.domain.entity.BankAction targetAction) {
        if ( action == null ) {
            return;
        }

        if ( action.getBankProfile() != null ) {
            targetAction.setBankProfile( action.getBankProfile() );
        }
        if ( action.getProtocolAction() != null ) {
            targetAction.setProtocolAction( action.getProtocolAction() );
        }
        if ( action.getProtocolBeanName() != null ) {
            targetAction.setProtocolBeanName( action.getProtocolBeanName() );
        }
        targetAction.setConsentSupported( action.isConsentSupported() );
        if ( targetAction.getSubProtocols() != null ) {
            Collection<BankSubAction> collection = action.getSubProtocols();
            if ( collection != null ) {
                targetAction.getSubProtocols().clear();
                targetAction.getSubProtocols().addAll( collection );
            }
        }
        else {
            Collection<BankSubAction> collection = action.getSubProtocols();
            if ( collection != null ) {
                targetAction.setSubProtocols( new ArrayList<BankSubAction>( collection ) );
            }
        }
        if ( targetAction.getAuthSessions() != null ) {
            Collection<AuthSession> collection1 = action.getAuthSessions();
            if ( collection1 != null ) {
                targetAction.getAuthSessions().clear();
                targetAction.getAuthSessions().addAll( collection1 );
            }
        }
        else {
            Collection<AuthSession> collection1 = action.getAuthSessions();
            if ( collection1 != null ) {
                targetAction.setAuthSessions( new ArrayList<AuthSession>( collection1 ) );
            }
        }
    }

    protected List<de.adorsys.opba.adminapi.model.generated.BankProfile> bankProfileCollectionToBankProfileList(Collection<BankProfile> collection) {
        if ( collection == null ) {
            return null;
        }

        List<de.adorsys.opba.adminapi.model.generated.BankProfile> list = new ArrayList<de.adorsys.opba.adminapi.model.generated.BankProfile>( collection.size() );
        for ( BankProfile bankProfile : collection ) {
            list.add( bankProfileToBankProfile( bankProfile ) );
        }

        return list;
    }

    protected ScaApproachesEnum approachToScaApproachesEnum(Approach approach) {
        if ( approach == null ) {
            return null;
        }

        ScaApproachesEnum scaApproachesEnum;

        switch ( approach ) {
            case REDIRECT: scaApproachesEnum = ScaApproachesEnum.REDIRECT;
            break;
            case EMBEDDED: scaApproachesEnum = ScaApproachesEnum.EMBEDDED;
            break;
            case DECOUPLED: scaApproachesEnum = ScaApproachesEnum.DECOUPLED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + approach );
        }

        return scaApproachesEnum;
    }

    protected List<ScaApproachesEnum> approachListToScaApproachesEnumList(List<Approach> list) {
        if ( list == null ) {
            return null;
        }

        List<ScaApproachesEnum> list1 = new ArrayList<ScaApproachesEnum>( list.size() );
        for ( Approach approach : list ) {
            list1.add( approachToScaApproachesEnum( approach ) );
        }

        return list1;
    }

    protected PreferredApproachEnum approachToPreferredApproachEnum(Approach approach) {
        if ( approach == null ) {
            return null;
        }

        PreferredApproachEnum preferredApproachEnum;

        switch ( approach ) {
            case REDIRECT: preferredApproachEnum = PreferredApproachEnum.REDIRECT;
            break;
            case EMBEDDED: preferredApproachEnum = PreferredApproachEnum.EMBEDDED;
            break;
            case DECOUPLED: preferredApproachEnum = PreferredApproachEnum.DECOUPLED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + approach );
        }

        return preferredApproachEnum;
    }

    protected ProtocolActionEnum protocolActionToProtocolActionEnum(ProtocolAction protocolAction) {
        if ( protocolAction == null ) {
            return null;
        }

        ProtocolActionEnum protocolActionEnum;

        switch ( protocolAction ) {
            case LIST_ACCOUNTS: protocolActionEnum = ProtocolActionEnum.LIST_ACCOUNTS;
            break;
            case LIST_TRANSACTIONS: protocolActionEnum = ProtocolActionEnum.LIST_TRANSACTIONS;
            break;
            case DELETE_CONSENT: protocolActionEnum = ProtocolActionEnum.DELETE_CONSENT;
            break;
            case GET_CONSENT_STATUS: protocolActionEnum = ProtocolActionEnum.GET_CONSENT_STATUS;
            break;
            case GET_AIS_AUTHORIZATION_STATUS: protocolActionEnum = ProtocolActionEnum.GET_AIS_AUTHORIZATION_STATUS;
            break;
            case UPDATE_EXTERNAL_AIS_SESSION: protocolActionEnum = ProtocolActionEnum.UPDATE_EXTERNAL_AIS_SESSION;
            break;
            case AUTHORIZATION: protocolActionEnum = ProtocolActionEnum.AUTHORIZATION;
            break;
            case ON_LOGIN: protocolActionEnum = ProtocolActionEnum.ON_LOGIN;
            break;
            case GET_AUTHORIZATION_STATE: protocolActionEnum = ProtocolActionEnum.GET_AUTHORIZATION_STATE;
            break;
            case UPDATE_AUTHORIZATION: protocolActionEnum = ProtocolActionEnum.UPDATE_AUTHORIZATION;
            break;
            case DENY_AUTHORIZATION: protocolActionEnum = ProtocolActionEnum.DENY_AUTHORIZATION;
            break;
            case FROM_ASPSP_REDIRECT: protocolActionEnum = ProtocolActionEnum.FROM_ASPSP_REDIRECT;
            break;
            case SINGLE_PAYMENT: protocolActionEnum = ProtocolActionEnum.SINGLE_PAYMENT;
            break;
            case GET_PAYMENT_STATUS: protocolActionEnum = ProtocolActionEnum.GET_PAYMENT_STATUS;
            break;
            case GET_PAYMENT_INFORMATION: protocolActionEnum = ProtocolActionEnum.GET_PAYMENT_INFORMATION;
            break;
            case GET_PIS_AUTHORIZATION_STATUS: protocolActionEnum = ProtocolActionEnum.GET_PIS_AUTHORIZATION_STATUS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + protocolAction );
        }

        return protocolActionEnum;
    }

    protected de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum protocolActionToProtocolActionEnum1(ProtocolAction protocolAction) {
        if ( protocolAction == null ) {
            return null;
        }

        de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum protocolActionEnum;

        switch ( protocolAction ) {
            case LIST_ACCOUNTS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.LIST_ACCOUNTS;
            break;
            case LIST_TRANSACTIONS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.LIST_TRANSACTIONS;
            break;
            case DELETE_CONSENT: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.DELETE_CONSENT;
            break;
            case GET_CONSENT_STATUS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_CONSENT_STATUS;
            break;
            case GET_AIS_AUTHORIZATION_STATUS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_AIS_AUTHORIZATION_STATUS;
            break;
            case UPDATE_EXTERNAL_AIS_SESSION: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.UPDATE_EXTERNAL_AIS_SESSION;
            break;
            case AUTHORIZATION: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.AUTHORIZATION;
            break;
            case ON_LOGIN: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.ON_LOGIN;
            break;
            case GET_AUTHORIZATION_STATE: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_AUTHORIZATION_STATE;
            break;
            case UPDATE_AUTHORIZATION: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.UPDATE_AUTHORIZATION;
            break;
            case DENY_AUTHORIZATION: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.DENY_AUTHORIZATION;
            break;
            case FROM_ASPSP_REDIRECT: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.FROM_ASPSP_REDIRECT;
            break;
            case SINGLE_PAYMENT: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.SINGLE_PAYMENT;
            break;
            case GET_PAYMENT_STATUS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_PAYMENT_STATUS;
            break;
            case GET_PAYMENT_INFORMATION: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_PAYMENT_INFORMATION;
            break;
            case GET_PIS_AUTHORIZATION_STATUS: protocolActionEnum = de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum.GET_PIS_AUTHORIZATION_STATUS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + protocolAction );
        }

        return protocolActionEnum;
    }

    protected de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubActionToBankSubAction(BankSubAction bankSubAction) {
        if ( bankSubAction == null ) {
            return null;
        }

        de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction1 = new de.adorsys.opba.adminapi.model.generated.BankSubAction();

        bankSubAction1.setProtocolAction( protocolActionToProtocolActionEnum1( bankSubAction.getProtocolAction() ) );
        bankSubAction1.setSubProtocolBeanName( bankSubAction.getSubProtocolBeanName() );

        return bankSubAction1;
    }

    protected List<de.adorsys.opba.adminapi.model.generated.BankSubAction> bankSubActionCollectionToBankSubActionList(Collection<BankSubAction> collection) {
        if ( collection == null ) {
            return null;
        }

        List<de.adorsys.opba.adminapi.model.generated.BankSubAction> list = new ArrayList<de.adorsys.opba.adminapi.model.generated.BankSubAction>( collection.size() );
        for ( BankSubAction bankSubAction : collection ) {
            list.add( bankSubActionToBankSubAction( bankSubAction ) );
        }

        return list;
    }

    protected BankAction bankActionToBankAction(de.adorsys.opba.db.domain.entity.BankAction bankAction) {
        if ( bankAction == null ) {
            return null;
        }

        BankAction bankAction1 = new BankAction();

        bankAction1.setProtocolAction( protocolActionToProtocolActionEnum( bankAction.getProtocolAction() ) );
        bankAction1.setProtocolBeanName( bankAction.getProtocolBeanName() );
        bankAction1.setConsentSupported( bankAction.isConsentSupported() );
        bankAction1.setSubProtocols( bankSubActionCollectionToBankSubActionList( bankAction.getSubProtocols() ) );

        return bankAction1;
    }

    protected Map<String, BankAction> protocolActionBankActionMapToStringBankActionMap(Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, BankAction> map1 = new HashMap<String, BankAction>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> entry : map.entrySet() ) {
            String key = entry.getKey().name();
            BankAction value = bankActionToBankAction( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected de.adorsys.opba.db.domain.entity.Bank bankToBank1(Bank bank) {
        if ( bank == null ) {
            return null;
        }

        BankBuilder bank1 = de.adorsys.opba.db.domain.entity.Bank.builder();

        bank1.name( bank.getName() );
        bank1.bic( bank.getBic() );
        bank1.bankCode( bank.getBankCode() );

        return bank1.build();
    }

    protected Approach scaApproachesEnumToApproach(ScaApproachesEnum scaApproachesEnum) {
        if ( scaApproachesEnum == null ) {
            return null;
        }

        Approach approach;

        switch ( scaApproachesEnum ) {
            case REDIRECT: approach = Approach.REDIRECT;
            break;
            case EMBEDDED: approach = Approach.EMBEDDED;
            break;
            case DECOUPLED: approach = Approach.DECOUPLED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaApproachesEnum );
        }

        return approach;
    }

    protected List<Approach> scaApproachesEnumListToApproachList(List<ScaApproachesEnum> list) {
        if ( list == null ) {
            return null;
        }

        List<Approach> list1 = new ArrayList<Approach>( list.size() );
        for ( ScaApproachesEnum scaApproachesEnum : list ) {
            list1.add( scaApproachesEnumToApproach( scaApproachesEnum ) );
        }

        return list1;
    }

    protected Approach preferredApproachEnumToApproach(PreferredApproachEnum preferredApproachEnum) {
        if ( preferredApproachEnum == null ) {
            return null;
        }

        Approach approach;

        switch ( preferredApproachEnum ) {
            case REDIRECT: approach = Approach.REDIRECT;
            break;
            case EMBEDDED: approach = Approach.EMBEDDED;
            break;
            case DECOUPLED: approach = Approach.DECOUPLED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + preferredApproachEnum );
        }

        return approach;
    }

    protected BankProfile bankProfileToBankProfile1(de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        BankProfileBuilder bankProfile1 = BankProfile.builder();

        bankProfile1.id( bankProfile.getId() );
        bankProfile1.url( bankProfile.getUrl() );
        bankProfile1.adapterId( bankProfile.getAdapterId() );
        bankProfile1.idpUrl( bankProfile.getIdpUrl() );
        bankProfile1.uuid( bankProfile.getUuid() );
        bankProfile1.name( bankProfile.getName() );
        bankProfile1.scaApproaches( scaApproachesEnumListToApproachList( bankProfile.getScaApproaches() ) );
        bankProfile1.preferredApproach( preferredApproachEnumToApproach( bankProfile.getPreferredApproach() ) );
        if ( bankProfile.isTryToUsePreferredApproach() != null ) {
            bankProfile1.tryToUsePreferredApproach( bankProfile.isTryToUsePreferredApproach() );
        }
        if ( bankProfile.isUniquePaymentPurpose() != null ) {
            bankProfile1.uniquePaymentPurpose( bankProfile.isUniquePaymentPurpose() );
        }
        bankProfile1.externalId( bankProfile.getExternalId() );
        bankProfile1.externalInterfaces( bankProfile.getExternalInterfaces() );
        bankProfile1.protocolType( bankProfile.getProtocolType() );
        if ( bankProfile.isIsSandbox() != null ) {
            bankProfile1.isSandbox( bankProfile.isIsSandbox() );
        }
        bankProfile1.actions( mapActions( bankProfile.getActions() ) );

        return bankProfile1.build();
    }

    protected Collection<BankProfile> bankProfileListToBankProfileCollection(List<de.adorsys.opba.adminapi.model.generated.BankProfile> list) {
        if ( list == null ) {
            return null;
        }

        Collection<BankProfile> collection = new ArrayList<BankProfile>( list.size() );
        for ( de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile : list ) {
            collection.add( bankProfileToBankProfile1( bankProfile ) );
        }

        return collection;
    }

    protected ProtocolAction protocolActionEnumToProtocolAction(ProtocolActionEnum protocolActionEnum) {
        if ( protocolActionEnum == null ) {
            return null;
        }

        ProtocolAction protocolAction;

        switch ( protocolActionEnum ) {
            case LIST_ACCOUNTS: protocolAction = ProtocolAction.LIST_ACCOUNTS;
            break;
            case LIST_TRANSACTIONS: protocolAction = ProtocolAction.LIST_TRANSACTIONS;
            break;
            case DELETE_CONSENT: protocolAction = ProtocolAction.DELETE_CONSENT;
            break;
            case GET_CONSENT_STATUS: protocolAction = ProtocolAction.GET_CONSENT_STATUS;
            break;
            case GET_AIS_AUTHORIZATION_STATUS: protocolAction = ProtocolAction.GET_AIS_AUTHORIZATION_STATUS;
            break;
            case UPDATE_EXTERNAL_AIS_SESSION: protocolAction = ProtocolAction.UPDATE_EXTERNAL_AIS_SESSION;
            break;
            case AUTHORIZATION: protocolAction = ProtocolAction.AUTHORIZATION;
            break;
            case ON_LOGIN: protocolAction = ProtocolAction.ON_LOGIN;
            break;
            case GET_AUTHORIZATION_STATE: protocolAction = ProtocolAction.GET_AUTHORIZATION_STATE;
            break;
            case UPDATE_AUTHORIZATION: protocolAction = ProtocolAction.UPDATE_AUTHORIZATION;
            break;
            case DENY_AUTHORIZATION: protocolAction = ProtocolAction.DENY_AUTHORIZATION;
            break;
            case FROM_ASPSP_REDIRECT: protocolAction = ProtocolAction.FROM_ASPSP_REDIRECT;
            break;
            case SINGLE_PAYMENT: protocolAction = ProtocolAction.SINGLE_PAYMENT;
            break;
            case GET_PAYMENT_STATUS: protocolAction = ProtocolAction.GET_PAYMENT_STATUS;
            break;
            case GET_PAYMENT_INFORMATION: protocolAction = ProtocolAction.GET_PAYMENT_INFORMATION;
            break;
            case GET_PIS_AUTHORIZATION_STATUS: protocolAction = ProtocolAction.GET_PIS_AUTHORIZATION_STATUS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + protocolActionEnum );
        }

        return protocolAction;
    }

    protected ProtocolAction protocolActionEnumToProtocolAction1(de.adorsys.opba.adminapi.model.generated.BankSubAction.ProtocolActionEnum protocolActionEnum) {
        if ( protocolActionEnum == null ) {
            return null;
        }

        ProtocolAction protocolAction;

        switch ( protocolActionEnum ) {
            case LIST_ACCOUNTS: protocolAction = ProtocolAction.LIST_ACCOUNTS;
            break;
            case LIST_TRANSACTIONS: protocolAction = ProtocolAction.LIST_TRANSACTIONS;
            break;
            case DELETE_CONSENT: protocolAction = ProtocolAction.DELETE_CONSENT;
            break;
            case GET_CONSENT_STATUS: protocolAction = ProtocolAction.GET_CONSENT_STATUS;
            break;
            case GET_AIS_AUTHORIZATION_STATUS: protocolAction = ProtocolAction.GET_AIS_AUTHORIZATION_STATUS;
            break;
            case UPDATE_EXTERNAL_AIS_SESSION: protocolAction = ProtocolAction.UPDATE_EXTERNAL_AIS_SESSION;
            break;
            case AUTHORIZATION: protocolAction = ProtocolAction.AUTHORIZATION;
            break;
            case ON_LOGIN: protocolAction = ProtocolAction.ON_LOGIN;
            break;
            case GET_AUTHORIZATION_STATE: protocolAction = ProtocolAction.GET_AUTHORIZATION_STATE;
            break;
            case UPDATE_AUTHORIZATION: protocolAction = ProtocolAction.UPDATE_AUTHORIZATION;
            break;
            case DENY_AUTHORIZATION: protocolAction = ProtocolAction.DENY_AUTHORIZATION;
            break;
            case FROM_ASPSP_REDIRECT: protocolAction = ProtocolAction.FROM_ASPSP_REDIRECT;
            break;
            case SINGLE_PAYMENT: protocolAction = ProtocolAction.SINGLE_PAYMENT;
            break;
            case GET_PAYMENT_STATUS: protocolAction = ProtocolAction.GET_PAYMENT_STATUS;
            break;
            case GET_PAYMENT_INFORMATION: protocolAction = ProtocolAction.GET_PAYMENT_INFORMATION;
            break;
            case GET_PIS_AUTHORIZATION_STATUS: protocolAction = ProtocolAction.GET_PIS_AUTHORIZATION_STATUS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + protocolActionEnum );
        }

        return protocolAction;
    }

    protected BankSubAction bankSubActionToBankSubAction1(de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction) {
        if ( bankSubAction == null ) {
            return null;
        }

        BankSubActionBuilder bankSubAction1 = BankSubAction.builder();

        bankSubAction1.protocolAction( protocolActionEnumToProtocolAction1( bankSubAction.getProtocolAction() ) );
        bankSubAction1.subProtocolBeanName( bankSubAction.getSubProtocolBeanName() );

        return bankSubAction1.build();
    }

    protected Collection<BankSubAction> bankSubActionListToBankSubActionCollection(List<de.adorsys.opba.adminapi.model.generated.BankSubAction> list) {
        if ( list == null ) {
            return null;
        }

        Collection<BankSubAction> collection = new ArrayList<BankSubAction>( list.size() );
        for ( de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction : list ) {
            collection.add( bankSubActionToBankSubAction1( bankSubAction ) );
        }

        return collection;
    }

    protected de.adorsys.opba.db.domain.entity.BankAction bankActionToBankAction1(BankAction bankAction) {
        if ( bankAction == null ) {
            return null;
        }

        BankActionBuilder bankAction1 = de.adorsys.opba.db.domain.entity.BankAction.builder();

        bankAction1.protocolAction( protocolActionEnumToProtocolAction( bankAction.getProtocolAction() ) );
        bankAction1.protocolBeanName( bankAction.getProtocolBeanName() );
        if ( bankAction.isConsentSupported() != null ) {
            bankAction1.consentSupported( bankAction.isConsentSupported() );
        }
        bankAction1.subProtocols( bankSubActionListToBankSubActionCollection( bankAction.getSubProtocols() ) );

        return bankAction1.build();
    }
}
