package de.adorsys.opba.adminapi.service.mappers;

import de.adorsys.opba.adminapi.model.generated.Bank;
import de.adorsys.opba.adminapi.model.generated.BankAction;
import de.adorsys.opba.adminapi.model.generated.BankData;
import de.adorsys.opba.adminapi.model.generated.BankProfile.PreferredApproachEnum;
import de.adorsys.opba.adminapi.model.generated.BankProfile.ScaApproachesEnum;
import de.adorsys.opba.adminapi.service.AdminApiService.ActionEnumMapping;
import de.adorsys.opba.adminapi.service.AdminApiService.BankDataToMap;
import de.adorsys.opba.adminapi.service.AdminApiService.BankMapper;
import de.adorsys.opba.db.domain.entity.Bank.BankBuilder;
import de.adorsys.opba.db.domain.entity.BankAction.BankActionBuilder;
import de.adorsys.opba.db.domain.entity.BankProfile;
import de.adorsys.opba.db.domain.entity.BankProfile.BankProfileBuilder;
import de.adorsys.opba.db.domain.entity.BankSubAction;
import de.adorsys.opba.db.domain.entity.BankSubAction.BankSubActionBuilder;
import de.adorsys.opba.db.domain.entity.sessions.AuthSession;
import de.adorsys.opba.protocol.api.common.Approach;
import de.adorsys.opba.protocol.api.common.ProtocolAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-11-17T19:06:17+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.9 (Azul Systems, Inc.)"
)
@Component
public class AdminApiService$BankMapperImpl implements BankMapper {

    @Autowired
    private ActionEnumMapping actionEnumMapping;

    @Override
    public BankData map(BankDataToMap bank) {
        if ( bank == null ) {
            return null;
        }

        BankData bankData = new BankData();

        bankData.setBank( bankToBank( bank.getBank() ) );
        bankData.setProfile( bankProfileToBankProfile( bank.getProfile() ) );

        return bankData;
    }

    @Override
    public BankDataToMap map(BankData bank) {
        if ( bank == null ) {
            return null;
        }

        BankDataToMap bankDataToMap = new BankDataToMap();

        bankDataToMap.setBank( bankToBank1( bank.getBank() ) );
        bankDataToMap.setProfile( bankProfileToBankProfile1( bank.getProfile() ) );

        return bankDataToMap;
    }

    @Override
    public void mapToBank(Bank bankData, de.adorsys.opba.db.domain.entity.Bank bank) {
        if ( bankData == null ) {
            return;
        }

        if ( bankData.getName() != null ) {
            bank.setName( bankData.getName() );
        }
        if ( bankData.getBic() != null ) {
            bank.setBic( bankData.getBic() );
        }
        if ( bankData.getBankCode() != null ) {
            bank.setBankCode( bankData.getBankCode() );
        }
    }

    @Override
    public void mapToProfile(de.adorsys.opba.adminapi.model.generated.BankProfile bankData, BankProfile bank) {
        if ( bankData == null ) {
            return;
        }

        if ( bankData.getUrl() != null ) {
            bank.setUrl( bankData.getUrl() );
        }
        if ( bankData.getAdapterId() != null ) {
            bank.setAdapterId( bankData.getAdapterId() );
        }
        if ( bankData.getIdpUrl() != null ) {
            bank.setIdpUrl( bankData.getIdpUrl() );
        }
        if ( bank.getScaApproaches() != null ) {
            List<Approach> list = scaApproachesEnumListToApproachList( bankData.getScaApproaches() );
            if ( list != null ) {
                bank.getScaApproaches().clear();
                bank.getScaApproaches().addAll( list );
            }
        }
        else {
            List<Approach> list = scaApproachesEnumListToApproachList( bankData.getScaApproaches() );
            if ( list != null ) {
                bank.setScaApproaches( list );
            }
        }
        if ( bankData.getPreferredApproach() != null ) {
            bank.setPreferredApproach( preferredApproachEnumToApproach( bankData.getPreferredApproach() ) );
        }
        if ( bankData.isTryToUsePreferredApproach() != null ) {
            bank.setTryToUsePreferredApproach( bankData.isTryToUsePreferredApproach() );
        }
        if ( bankData.isUniquePaymentPurpose() != null ) {
            bank.setUniquePaymentPurpose( bankData.isUniquePaymentPurpose() );
        }
    }

    @Override
    public Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> mapActions(Map<String, BankAction> map) {
        if ( map == null ) {
            return null;
        }

        Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> map1 = new HashMap<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<String, BankAction> entry : map.entrySet() ) {
            ProtocolAction key = Enum.valueOf( ProtocolAction.class, entry.getKey() );
            de.adorsys.opba.db.domain.entity.BankAction value = bankActionToBankAction1( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    @Override
    public void mapAction(de.adorsys.opba.db.domain.entity.BankAction action, de.adorsys.opba.db.domain.entity.BankAction targetAction) {
        if ( action == null ) {
            return;
        }

        if ( action.getBankProfile() != null ) {
            targetAction.setBankProfile( action.getBankProfile() );
        }
        if ( action.getProtocolAction() != null ) {
            targetAction.setProtocolAction( action.getProtocolAction() );
        }
        if ( action.getProtocolBeanName() != null ) {
            targetAction.setProtocolBeanName( action.getProtocolBeanName() );
        }
        targetAction.setConsentSupported( action.isConsentSupported() );
        if ( targetAction.getSubProtocols() != null ) {
            Collection<BankSubAction> collection = action.getSubProtocols();
            if ( collection != null ) {
                targetAction.getSubProtocols().clear();
                targetAction.getSubProtocols().addAll( collection );
            }
        }
        else {
            Collection<BankSubAction> collection = action.getSubProtocols();
            if ( collection != null ) {
                targetAction.setSubProtocols( new ArrayList<BankSubAction>( collection ) );
            }
        }
        if ( targetAction.getAuthSessions() != null ) {
            Collection<AuthSession> collection1 = action.getAuthSessions();
            if ( collection1 != null ) {
                targetAction.getAuthSessions().clear();
                targetAction.getAuthSessions().addAll( collection1 );
            }
        }
        else {
            Collection<AuthSession> collection1 = action.getAuthSessions();
            if ( collection1 != null ) {
                targetAction.setAuthSessions( new ArrayList<AuthSession>( collection1 ) );
            }
        }
    }

    protected Bank bankToBank(de.adorsys.opba.db.domain.entity.Bank bank) {
        if ( bank == null ) {
            return null;
        }

        Bank bank1 = new Bank();

        bank1.setId( bank.getId() );
        bank1.setUuid( bank.getUuid() );
        bank1.setName( bank.getName() );
        bank1.setBic( bank.getBic() );
        bank1.setBankCode( bank.getBankCode() );

        return bank1;
    }

    protected ScaApproachesEnum approachToScaApproachesEnum(Approach approach) {
        if ( approach == null ) {
            return null;
        }

        ScaApproachesEnum scaApproachesEnum;

        switch ( approach ) {
            case REDIRECT: scaApproachesEnum = ScaApproachesEnum.REDIRECT;
            break;
            case EMBEDDED: scaApproachesEnum = ScaApproachesEnum.EMBEDDED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + approach );
        }

        return scaApproachesEnum;
    }

    protected List<ScaApproachesEnum> approachListToScaApproachesEnumList(List<Approach> list) {
        if ( list == null ) {
            return null;
        }

        List<ScaApproachesEnum> list1 = new ArrayList<ScaApproachesEnum>( list.size() );
        for ( Approach approach : list ) {
            list1.add( approachToScaApproachesEnum( approach ) );
        }

        return list1;
    }

    protected PreferredApproachEnum approachToPreferredApproachEnum(Approach approach) {
        if ( approach == null ) {
            return null;
        }

        PreferredApproachEnum preferredApproachEnum;

        switch ( approach ) {
            case REDIRECT: preferredApproachEnum = PreferredApproachEnum.REDIRECT;
            break;
            case EMBEDDED: preferredApproachEnum = PreferredApproachEnum.EMBEDDED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + approach );
        }

        return preferredApproachEnum;
    }

    protected de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubActionToBankSubAction(BankSubAction bankSubAction) {
        if ( bankSubAction == null ) {
            return null;
        }

        de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction1 = new de.adorsys.opba.adminapi.model.generated.BankSubAction();

        bankSubAction1.setProtocolAction( actionEnumMapping.mapSubAction( bankSubAction.getProtocolAction() ) );
        bankSubAction1.setSubProtocolBeanName( bankSubAction.getSubProtocolBeanName() );

        return bankSubAction1;
    }

    protected List<de.adorsys.opba.adminapi.model.generated.BankSubAction> bankSubActionCollectionToBankSubActionList(Collection<BankSubAction> collection) {
        if ( collection == null ) {
            return null;
        }

        List<de.adorsys.opba.adminapi.model.generated.BankSubAction> list = new ArrayList<de.adorsys.opba.adminapi.model.generated.BankSubAction>( collection.size() );
        for ( BankSubAction bankSubAction : collection ) {
            list.add( bankSubActionToBankSubAction( bankSubAction ) );
        }

        return list;
    }

    protected BankAction bankActionToBankAction(de.adorsys.opba.db.domain.entity.BankAction bankAction) {
        if ( bankAction == null ) {
            return null;
        }

        BankAction bankAction1 = new BankAction();

        bankAction1.setProtocolAction( actionEnumMapping.mapAction( bankAction.getProtocolAction() ) );
        bankAction1.setProtocolBeanName( bankAction.getProtocolBeanName() );
        bankAction1.setConsentSupported( bankAction.isConsentSupported() );
        bankAction1.setSubProtocols( bankSubActionCollectionToBankSubActionList( bankAction.getSubProtocols() ) );

        return bankAction1;
    }

    protected Map<String, BankAction> protocolActionBankActionMapToStringBankActionMap(Map<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> map) {
        if ( map == null ) {
            return null;
        }

        Map<String, BankAction> map1 = new HashMap<String, BankAction>( Math.max( (int) ( map.size() / .75f ) + 1, 16 ) );

        for ( java.util.Map.Entry<ProtocolAction, de.adorsys.opba.db.domain.entity.BankAction> entry : map.entrySet() ) {
            String key = entry.getKey().name();
            BankAction value = bankActionToBankAction( entry.getValue() );
            map1.put( key, value );
        }

        return map1;
    }

    protected de.adorsys.opba.adminapi.model.generated.BankProfile bankProfileToBankProfile(BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile1 = new de.adorsys.opba.adminapi.model.generated.BankProfile();

        bankProfile1.setId( bankProfile.getId() );
        bankProfile1.setUrl( bankProfile.getUrl() );
        bankProfile1.setAdapterId( bankProfile.getAdapterId() );
        bankProfile1.setIdpUrl( bankProfile.getIdpUrl() );
        bankProfile1.setScaApproaches( approachListToScaApproachesEnumList( bankProfile.getScaApproaches() ) );
        bankProfile1.setPreferredApproach( approachToPreferredApproachEnum( bankProfile.getPreferredApproach() ) );
        bankProfile1.setTryToUsePreferredApproach( bankProfile.isTryToUsePreferredApproach() );
        bankProfile1.setUniquePaymentPurpose( bankProfile.isUniquePaymentPurpose() );
        bankProfile1.setActions( protocolActionBankActionMapToStringBankActionMap( bankProfile.getActions() ) );
        bankProfile1.setBankCode( bankProfile.getBankCode() );
        bankProfile1.setBic( bankProfile.getBic() );
        bankProfile1.setName( bankProfile.getName() );

        return bankProfile1;
    }

    protected de.adorsys.opba.db.domain.entity.Bank bankToBank1(Bank bank) {
        if ( bank == null ) {
            return null;
        }

        BankBuilder bank1 = de.adorsys.opba.db.domain.entity.Bank.builder();

        bank1.name( bank.getName() );
        bank1.bic( bank.getBic() );
        bank1.bankCode( bank.getBankCode() );

        return bank1.build();
    }

    protected Approach scaApproachesEnumToApproach(ScaApproachesEnum scaApproachesEnum) {
        if ( scaApproachesEnum == null ) {
            return null;
        }

        Approach approach;

        switch ( scaApproachesEnum ) {
            case REDIRECT: approach = Approach.REDIRECT;
            break;
            case EMBEDDED: approach = Approach.EMBEDDED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaApproachesEnum );
        }

        return approach;
    }

    protected List<Approach> scaApproachesEnumListToApproachList(List<ScaApproachesEnum> list) {
        if ( list == null ) {
            return null;
        }

        List<Approach> list1 = new ArrayList<Approach>( list.size() );
        for ( ScaApproachesEnum scaApproachesEnum : list ) {
            list1.add( scaApproachesEnumToApproach( scaApproachesEnum ) );
        }

        return list1;
    }

    protected Approach preferredApproachEnumToApproach(PreferredApproachEnum preferredApproachEnum) {
        if ( preferredApproachEnum == null ) {
            return null;
        }

        Approach approach;

        switch ( preferredApproachEnum ) {
            case REDIRECT: approach = Approach.REDIRECT;
            break;
            case EMBEDDED: approach = Approach.EMBEDDED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + preferredApproachEnum );
        }

        return approach;
    }

    protected BankProfile bankProfileToBankProfile1(de.adorsys.opba.adminapi.model.generated.BankProfile bankProfile) {
        if ( bankProfile == null ) {
            return null;
        }

        BankProfileBuilder bankProfile1 = BankProfile.builder();

        bankProfile1.url( bankProfile.getUrl() );
        bankProfile1.adapterId( bankProfile.getAdapterId() );
        bankProfile1.idpUrl( bankProfile.getIdpUrl() );
        bankProfile1.scaApproaches( scaApproachesEnumListToApproachList( bankProfile.getScaApproaches() ) );
        bankProfile1.preferredApproach( preferredApproachEnumToApproach( bankProfile.getPreferredApproach() ) );
        if ( bankProfile.isTryToUsePreferredApproach() != null ) {
            bankProfile1.tryToUsePreferredApproach( bankProfile.isTryToUsePreferredApproach() );
        }
        if ( bankProfile.isUniquePaymentPurpose() != null ) {
            bankProfile1.uniquePaymentPurpose( bankProfile.isUniquePaymentPurpose() );
        }
        bankProfile1.actions( mapActions( bankProfile.getActions() ) );

        return bankProfile1.build();
    }

    protected BankSubAction bankSubActionToBankSubAction1(de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction) {
        if ( bankSubAction == null ) {
            return null;
        }

        BankSubActionBuilder bankSubAction1 = BankSubAction.builder();

        bankSubAction1.protocolAction( actionEnumMapping.mapSubAction( bankSubAction.getProtocolAction() ) );
        bankSubAction1.subProtocolBeanName( bankSubAction.getSubProtocolBeanName() );

        return bankSubAction1.build();
    }

    protected Collection<BankSubAction> bankSubActionListToBankSubActionCollection(List<de.adorsys.opba.adminapi.model.generated.BankSubAction> list) {
        if ( list == null ) {
            return null;
        }

        Collection<BankSubAction> collection = new ArrayList<BankSubAction>( list.size() );
        for ( de.adorsys.opba.adminapi.model.generated.BankSubAction bankSubAction : list ) {
            collection.add( bankSubActionToBankSubAction1( bankSubAction ) );
        }

        return collection;
    }

    protected de.adorsys.opba.db.domain.entity.BankAction bankActionToBankAction1(BankAction bankAction) {
        if ( bankAction == null ) {
            return null;
        }

        BankActionBuilder bankAction1 = de.adorsys.opba.db.domain.entity.BankAction.builder();

        bankAction1.protocolAction( actionEnumMapping.mapAction( bankAction.getProtocolAction() ) );
        bankAction1.protocolBeanName( bankAction.getProtocolBeanName() );
        if ( bankAction.isConsentSupported() != null ) {
            bankAction1.consentSupported( bankAction.isConsentSupported() );
        }
        bankAction1.subProtocols( bankSubActionListToBankSubActionCollection( bankAction.getSubProtocols() ) );

        return bankAction1.build();
    }
}
