package de.adorsys.opba.adminapi.model.generated;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.opba.adminapi.model.generated.BankAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * BankProfile
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-11-17T19:49:19.840566Z[Etc/UTC]")
public class BankProfile   {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("url")
  private String url = null;

  @JsonProperty("adapterId")
  private String adapterId = null;

  @JsonProperty("idpUrl")
  private String idpUrl = null;

  /**
   * Gets or Sets scaApproaches
   */
  public enum ScaApproachesEnum {
    REDIRECT("REDIRECT"),
    
    EMBEDDED("EMBEDDED");

    private String value;

    ScaApproachesEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ScaApproachesEnum fromValue(String text) {
      for (ScaApproachesEnum b : ScaApproachesEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }
  @JsonProperty("scaApproaches")
  @Valid
  private List<ScaApproachesEnum> scaApproaches = null;

  /**
   * Gets or Sets preferredApproach
   */
  public enum PreferredApproachEnum {
    REDIRECT("REDIRECT"),
    
    EMBEDDED("EMBEDDED");

    private String value;

    PreferredApproachEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PreferredApproachEnum fromValue(String text) {
      for (PreferredApproachEnum b : PreferredApproachEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }
  @JsonProperty("preferredApproach")
  private PreferredApproachEnum preferredApproach = null;

  @JsonProperty("tryToUsePreferredApproach")
  private Boolean tryToUsePreferredApproach = null;

  @JsonProperty("uniquePaymentPurpose")
  private Boolean uniquePaymentPurpose = null;

  @JsonProperty("actions")
  @Valid
  private Map<String, BankAction> actions = null;

  @JsonProperty("bankCode")
  private String bankCode = null;

  @JsonProperty("bic")
  private String bic = null;

  @JsonProperty("name")
  private String name = null;

  public BankProfile id(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  
    public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }

  public BankProfile url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Get url
   * @return url
  **/
  @ApiModelProperty(value = "")
  
    public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public BankProfile adapterId(String adapterId) {
    this.adapterId = adapterId;
    return this;
  }

  /**
   * Get adapterId
   * @return adapterId
  **/
  @ApiModelProperty(value = "")
  
    public String getAdapterId() {
    return adapterId;
  }

  public void setAdapterId(String adapterId) {
    this.adapterId = adapterId;
  }

  public BankProfile idpUrl(String idpUrl) {
    this.idpUrl = idpUrl;
    return this;
  }

  /**
   * Get idpUrl
   * @return idpUrl
  **/
  @ApiModelProperty(value = "")
  
    public String getIdpUrl() {
    return idpUrl;
  }

  public void setIdpUrl(String idpUrl) {
    this.idpUrl = idpUrl;
  }

  public BankProfile scaApproaches(List<ScaApproachesEnum> scaApproaches) {
    this.scaApproaches = scaApproaches;
    return this;
  }

  public BankProfile addScaApproachesItem(ScaApproachesEnum scaApproachesItem) {
    if (this.scaApproaches == null) {
      this.scaApproaches = new ArrayList<>();
    }
    this.scaApproaches.add(scaApproachesItem);
    return this;
  }

  /**
   * Get scaApproaches
   * @return scaApproaches
  **/
  @ApiModelProperty(value = "")
  
    public List<ScaApproachesEnum> getScaApproaches() {
    return scaApproaches;
  }

  public void setScaApproaches(List<ScaApproachesEnum> scaApproaches) {
    this.scaApproaches = scaApproaches;
  }

  public BankProfile preferredApproach(PreferredApproachEnum preferredApproach) {
    this.preferredApproach = preferredApproach;
    return this;
  }

  /**
   * Get preferredApproach
   * @return preferredApproach
  **/
  @ApiModelProperty(value = "")
  
    public PreferredApproachEnum getPreferredApproach() {
    return preferredApproach;
  }

  public void setPreferredApproach(PreferredApproachEnum preferredApproach) {
    this.preferredApproach = preferredApproach;
  }

  public BankProfile tryToUsePreferredApproach(Boolean tryToUsePreferredApproach) {
    this.tryToUsePreferredApproach = tryToUsePreferredApproach;
    return this;
  }

  /**
   * Get tryToUsePreferredApproach
   * @return tryToUsePreferredApproach
  **/
  @ApiModelProperty(value = "")
  
    public Boolean isTryToUsePreferredApproach() {
    return tryToUsePreferredApproach;
  }

  public void setTryToUsePreferredApproach(Boolean tryToUsePreferredApproach) {
    this.tryToUsePreferredApproach = tryToUsePreferredApproach;
  }

  public BankProfile uniquePaymentPurpose(Boolean uniquePaymentPurpose) {
    this.uniquePaymentPurpose = uniquePaymentPurpose;
    return this;
  }

  /**
   * Get uniquePaymentPurpose
   * @return uniquePaymentPurpose
  **/
  @ApiModelProperty(value = "")
  
    public Boolean isUniquePaymentPurpose() {
    return uniquePaymentPurpose;
  }

  public void setUniquePaymentPurpose(Boolean uniquePaymentPurpose) {
    this.uniquePaymentPurpose = uniquePaymentPurpose;
  }

  public BankProfile actions(Map<String, BankAction> actions) {
    this.actions = actions;
    return this;
  }

  public BankProfile putActionsItem(String key, BankAction actionsItem) {
    if (this.actions == null) {
      this.actions = new HashMap<>();
    }
    this.actions.put(key, actionsItem);
    return this;
  }

  /**
   * Get actions
   * @return actions
  **/
  @ApiModelProperty(value = "")
      @Valid
    public Map<String, BankAction> getActions() {
    return actions;
  }

  public void setActions(Map<String, BankAction> actions) {
    this.actions = actions;
  }

  public BankProfile bankCode(String bankCode) {
    this.bankCode = bankCode;
    return this;
  }

  /**
   * Get bankCode
   * @return bankCode
  **/
  @ApiModelProperty(value = "")
  
    public String getBankCode() {
    return bankCode;
  }

  public void setBankCode(String bankCode) {
    this.bankCode = bankCode;
  }

  public BankProfile bic(String bic) {
    this.bic = bic;
    return this;
  }

  /**
   * Get bic
   * @return bic
  **/
  @ApiModelProperty(value = "")
  
    public String getBic() {
    return bic;
  }

  public void setBic(String bic) {
    this.bic = bic;
  }

  public BankProfile name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")
  
    public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankProfile bankProfile = (BankProfile) o;
    return Objects.equals(this.id, bankProfile.id) &&
        Objects.equals(this.url, bankProfile.url) &&
        Objects.equals(this.adapterId, bankProfile.adapterId) &&
        Objects.equals(this.idpUrl, bankProfile.idpUrl) &&
        Objects.equals(this.scaApproaches, bankProfile.scaApproaches) &&
        Objects.equals(this.preferredApproach, bankProfile.preferredApproach) &&
        Objects.equals(this.tryToUsePreferredApproach, bankProfile.tryToUsePreferredApproach) &&
        Objects.equals(this.uniquePaymentPurpose, bankProfile.uniquePaymentPurpose) &&
        Objects.equals(this.actions, bankProfile.actions) &&
        Objects.equals(this.bankCode, bankProfile.bankCode) &&
        Objects.equals(this.bic, bankProfile.bic) &&
        Objects.equals(this.name, bankProfile.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, url, adapterId, idpUrl, scaApproaches, preferredApproach, tryToUsePreferredApproach, uniquePaymentPurpose, actions, bankCode, bic, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankProfile {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    adapterId: ").append(toIndentedString(adapterId)).append("\n");
    sb.append("    idpUrl: ").append(toIndentedString(idpUrl)).append("\n");
    sb.append("    scaApproaches: ").append(toIndentedString(scaApproaches)).append("\n");
    sb.append("    preferredApproach: ").append(toIndentedString(preferredApproach)).append("\n");
    sb.append("    tryToUsePreferredApproach: ").append(toIndentedString(tryToUsePreferredApproach)).append("\n");
    sb.append("    uniquePaymentPurpose: ").append(toIndentedString(uniquePaymentPurpose)).append("\n");
    sb.append("    actions: ").append(toIndentedString(actions)).append("\n");
    sb.append("    bankCode: ").append(toIndentedString(bankCode)).append("\n");
    sb.append("    bic: ").append(toIndentedString(bic)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
