package de.adorsys.opba.adminapi.model.generated;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.opba.adminapi.model.generated.BankSubAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * BankAction
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-11-17T19:49:19.840566Z[Etc/UTC]")
public class BankAction   {
  /**
   * Gets or Sets protocolAction
   */
  public enum ProtocolActionEnum {
    LIST_ACCOUNTS("list-accounts"),
    
    LIST_TRANSACTIONS("list-transactions"),
    
    AUTHORIZATION("authorization"),
    
    GET_AUTHORIZATION_STATE("get-authorization-state"),
    
    UPDATE_AUTHORIZATION("update-authorization"),
    
    DENY_AUTHORIZATION("deny-authorization"),
    
    FROM_ASPSP("from-aspsp"),
    
    SINGLE_PAYMENT("single-payment"),
    
    GET_PAYMENT_STATUS("get-payment-status"),
    
    GET_PAYMENT_INFORMATION("get-payment-information");

    private String value;

    ProtocolActionEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ProtocolActionEnum fromValue(String text) {
      for (ProtocolActionEnum b : ProtocolActionEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }
  @JsonProperty("protocolAction")
  private ProtocolActionEnum protocolAction = null;

  @JsonProperty("protocolBeanName")
  private String protocolBeanName = null;

  @JsonProperty("consentSupported")
  private Boolean consentSupported = null;

  @JsonProperty("subProtocols")
  @Valid
  private List<BankSubAction> subProtocols = null;

  public BankAction protocolAction(ProtocolActionEnum protocolAction) {
    this.protocolAction = protocolAction;
    return this;
  }

  /**
   * Get protocolAction
   * @return protocolAction
  **/
  @ApiModelProperty(value = "")
  
    public ProtocolActionEnum getProtocolAction() {
    return protocolAction;
  }

  public void setProtocolAction(ProtocolActionEnum protocolAction) {
    this.protocolAction = protocolAction;
  }

  public BankAction protocolBeanName(String protocolBeanName) {
    this.protocolBeanName = protocolBeanName;
    return this;
  }

  /**
   * Get protocolBeanName
   * @return protocolBeanName
  **/
  @ApiModelProperty(value = "")
  
    public String getProtocolBeanName() {
    return protocolBeanName;
  }

  public void setProtocolBeanName(String protocolBeanName) {
    this.protocolBeanName = protocolBeanName;
  }

  public BankAction consentSupported(Boolean consentSupported) {
    this.consentSupported = consentSupported;
    return this;
  }

  /**
   * Get consentSupported
   * @return consentSupported
  **/
  @ApiModelProperty(value = "")
  
    public Boolean isConsentSupported() {
    return consentSupported;
  }

  public void setConsentSupported(Boolean consentSupported) {
    this.consentSupported = consentSupported;
  }

  public BankAction subProtocols(List<BankSubAction> subProtocols) {
    this.subProtocols = subProtocols;
    return this;
  }

  public BankAction addSubProtocolsItem(BankSubAction subProtocolsItem) {
    if (this.subProtocols == null) {
      this.subProtocols = new ArrayList<>();
    }
    this.subProtocols.add(subProtocolsItem);
    return this;
  }

  /**
   * Get subProtocols
   * @return subProtocols
  **/
  @ApiModelProperty(value = "")
      @Valid
    public List<BankSubAction> getSubProtocols() {
    return subProtocols;
  }

  public void setSubProtocols(List<BankSubAction> subProtocols) {
    this.subProtocols = subProtocols;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BankAction bankAction = (BankAction) o;
    return Objects.equals(this.protocolAction, bankAction.protocolAction) &&
        Objects.equals(this.protocolBeanName, bankAction.protocolBeanName) &&
        Objects.equals(this.consentSupported, bankAction.consentSupported) &&
        Objects.equals(this.subProtocols, bankAction.subProtocols);
  }

  @Override
  public int hashCode() {
    return Objects.hash(protocolAction, protocolBeanName, consentSupported, subProtocols);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BankAction {\n");
    
    sb.append("    protocolAction: ").append(toIndentedString(protocolAction)).append("\n");
    sb.append("    protocolBeanName: ").append(toIndentedString(protocolBeanName)).append("\n");
    sb.append("    consentSupported: ").append(toIndentedString(consentSupported)).append("\n");
    sb.append("    subProtocols: ").append(toIndentedString(subProtocols)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
