/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.parsing;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.kapott.hbci.manager.DocumentFactory;
import org.kapott.hbci.protocol.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ParsingUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ParsingUtil.class);
    public static final Document SYNTAX = DocumentFactory.createDocument((String)"300");

    public static List<Message> parseMessageWithoutSensitiveNonSensitiveValidation(String from) {
        NodeList list = SYNTAX.getElementsByTagName("MSGdef");
        ArrayList<Message> result = new ArrayList<Message>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element node = (Element)list.item(i);
            String msgName = node.getAttribute("id");
            try {
                result.add(new Message(msgName, from, SYNTAX, false, true));
                continue;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean isCrypted(String messageStr) {
        return messageStr.contains("HNVSK") || messageStr.contains("HNVSD") || messageStr.contains("HNSHK");
    }

    @NotNull
    public static String cleanupCryptoHeaders(String messageStr) {
        messageStr = messageStr.replaceAll("(?s)HNVSK.+?'", "").replaceAll("(?s)HNVSD.+?@.+?@", "").replaceAll("(?s)HNSHK.+?'", "");
        return messageStr.replaceAll("(?s)(HKSPA:\\d:\\d)'", "$1\\+'").replaceAll("(?s)(HNSHA:\\d:\\d)", "'$1");
    }

    @Generated
    private ParsingUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

