/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.interpolation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.common.primitives.Longs;
import de.adorsys.multibanking.domain.PaymentStatus;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.Account;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.Transaction;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.User;
import de.adorsys.opba.protocol.sandbox.hbci.domain.HbciSandboxPayment;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.interpolation.JsonTemplateInterpolation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.parsing.ParsingUtil;
import de.adorsys.opba.protocol.sandbox.hbci.repository.HbciSandboxPaymentRepository;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.callback.HBCICallbackConsole;
import org.kapott.hbci.manager.HBCIProduct;
import org.kapott.hbci.passport.HBCIPassportInternal;
import org.kapott.hbci.passport.PinTanPassport;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.MultipleSyntaxElements;
import org.kapott.hbci.protocol.SyntaxElement;
import org.kapott.hbci.security.Crypt;
import org.kapott.hbci.security.Sig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JsonTemplateInterpolation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonTemplateInterpolation.class);
    private final Pattern interpolationTarget = Pattern.compile("(\\$\\{(.+?)})");
    private final Pattern loopAccounts = Pattern.compile("(\\$\\{(.+getLoopAccount.+?)})");
    private final Pattern loopSca = Pattern.compile("(\\$\\{(.+getLoopScaMethod.+?)})");
    private final Pattern mt940LoopTransactions = Pattern.compile("(\\$\\{mt940Begin}.+?\\$\\{mt940End})", 32);
    private final ObjectMapper mapper;
    private final HbciSandboxPaymentRepository paymentRepository;

    public String interpolateToHbci(String templateResourcePath, HbciSandboxContext context) {
        Map interpolated = this.interpolate(templateResourcePath, context);
        String type = (String)interpolated.remove("A_TYPE");
        log.info("Using (unwrapped) message type: {}", (Object)type);
        Message message = new Message(type, ParsingUtil.SYNTAX);
        HashSet kontos6Injected = new HashSet();
        ImmutableSet pathsToPrefix = ImmutableSet.of((Object)"GVRes\\.KUmsZeitRes.*\\.booked", (Object)"GVRes\\.InstantUebSEPAStatusRes.*\\.sepapain");
        for (Map.Entry target : interpolated.entrySet()) {
            this.injectKonto6IfNeeded(message, (String)target.getKey(), interpolated, kontos6Injected);
            message.propagateValue(message.getPath() + "." + (String)target.getKey(), (String)(pathsToPrefix.stream().anyMatch(it -> ((String)target.getKey()).matches((String)it)) ? "B" + (String)target.getValue() : (String)target.getValue()), true, true);
        }
        if (context.isCryptNeeded()) {
            log.info("Encryption needed for {} of {}", (Object)templateResourcePath, (Object)context.getDialogId());
            message = this.encryptAndSignMessage(context, message);
            return message.toString(0);
        }
        message.validate();
        message.enumerateSegs(1, true);
        message.autoSetMsgSize();
        return message.toString(0);
    }

    private void injectKonto6IfNeeded(Message message, String key, Map<String, String> values, Set<String> kontos6Injected) {
        Pattern konto6Pattern = Pattern.compile("UPD\\.KInfo.*\\.iban");
        Pattern targetPattern = Pattern.compile("(UPD\\.KInfo.*?\\.)");
        Pattern kontoPattern = Pattern.compile("UPD\\.KInfo.*");
        if (!kontoPattern.matcher(key).find()) {
            return;
        }
        Matcher matcher = targetPattern.matcher(key);
        matcher.find();
        String root = matcher.group(1);
        boolean hasKonto6 = values.entrySet().stream().filter(it -> ((String)it.getKey()).startsWith(root)).anyMatch(it -> konto6Pattern.matcher((CharSequence)it.getKey()).matches());
        if (!hasKonto6 || kontos6Injected.contains(root)) {
            return;
        }
        log.info("Injecting Konto6 for {}", (Object)key);
        kontos6Injected.add(root);
        SyntaxElement updElem = message.getElement(message.getPath() + ".UPD");
        XPath xPath = XPathFactory.newInstance().newXPath();
        Node konto6 = (Node)xPath.compile("/hbci/SFs/SFdef[@id='UPD']/SEG[@type='KInfo6']").evaluate(ParsingUtil.SYNTAX, XPathConstants.NODE);
        int konto6Idx = ((Double)xPath.compile("count(/hbci/SFs/SFdef[@id='UPD']/SEG[@type='KInfo6']/preceding-sibling::*)+1").evaluate(ParsingUtil.SYNTAX, XPathConstants.NUMBER)).intValue();
        Method createNewChildContainer = SyntaxElement.class.getDeclaredMethod("createNewChildContainer", Node.class, Document.class);
        createNewChildContainer.setAccessible(true);
        MultipleSyntaxElements newKonto6Elem = (MultipleSyntaxElements)createNewChildContainer.invoke((Object)updElem, konto6, ParsingUtil.SYNTAX);
        Method setIdx = MultipleSyntaxElements.class.getDeclaredMethod("setSyntaxIdx", Integer.TYPE);
        setIdx.setAccessible(true);
        setIdx.invoke((Object)newKonto6Elem, konto6Idx);
        updElem.getChildContainers().add(newKonto6Elem);
    }

    private Message encryptAndSignMessage(HbciSandboxContext context, Message message) {
        String userLogin = null == context.getUser() ? "noref" : context.getUser().getLogin();
        PinTanPassport passport = new PinTanPassport("300", (Map)ImmutableMap.of((Object)"client.passport.country", (Object)"DE", (Object)"client.passport.blz", (Object)context.getBank().getBlz(), (Object)"client.passport.customerId", (Object)userLogin, (Object)"client.passport.userId", (Object)userLogin), (HBCICallback)new HBCICallbackConsole(), new HBCIProduct("1234", "300"));
        passport.setPIN("noref");
        passport.setSysId(context.getSysId());
        this.signMessage(message, passport);
        return this.encryptMessage(context, message, passport);
    }

    @NotNull
    private Message encryptMessage(HbciSandboxContext context, Message message, PinTanPassport passport) {
        Crypt crypt = new Crypt((HBCIPassportInternal)passport);
        message = crypt.cryptIt(message);
        ImmutableSet pathsToPrefix = ImmutableSet.of((Object)"CryptData.data", (Object)"CryptHead.CryptAlg.enckey");
        Message result = new Message("CryptedRes", ParsingUtil.SYNTAX);
        for (Map.Entry target : message.getData().entrySet()) {
            result.propagateValue(result.getPath() + "." + (String)target.getKey(), (String)(pathsToPrefix.contains(target.getKey()) ? "B" + (String)target.getValue() : (String)target.getValue()), true, true);
        }
        result.propagateValue(result.getPath() + ".MsgHead.MsgRef.dialogid", context.getDialogId(), true, true);
        result.propagateValue(result.getPath() + ".MsgHead.MsgRef.msgnum", message.getValueOfDE(message.getPath() + ".MsgHead.msgnum"), true, true);
        result.validate();
        result.enumerateSegs(1, true);
        result.autoSetMsgSize();
        return result;
    }

    private void signMessage(Message message, PinTanPassport passport) {
        Sig sig = new Sig();
        sig.signIt(message, (HBCIPassportInternal)passport);
        HashMap existingPaths = new HashMap();
        message.getChildContainers().stream().flatMap(it -> it.getElements().stream()).forEach(it -> this.recursivelyEnumeratePaths(it, existingPaths));
        this.nonRecursivelyRemoveDuplicatePathsAndDestroyDirectParentOnDuplicate((SyntaxElement)message, existingPaths);
        message.validate();
        message.enumerateSegs(1, true);
    }

    private void recursivelyEnumeratePaths(SyntaxElement element, Map<String, SyntaxElement> existingPaths) {
        existingPaths.putIfAbsent(element.getPath(), element);
        element.getChildContainers().stream().flatMap(it -> it.getElements().stream()).forEach(it -> this.recursivelyEnumeratePaths(it, existingPaths));
    }

    private void nonRecursivelyRemoveDuplicatePathsAndDestroyDirectParentOnDuplicate(SyntaxElement element, Map<String, SyntaxElement> existingPaths) {
        List children = element.getChildContainers();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            MultipleSyntaxElements current = (MultipleSyntaxElements)iterator.next();
            current.getElements().removeIf(elem -> !((SyntaxElement)existingPaths.get(elem.getPath())).equals(elem) || elem.toString(0).matches("HITAN:\\d+:\\d+'"));
            int totElems = current.getElements().stream().mapToInt(it -> it.getChildContainers().size()).sum();
            if (0 != totElems && !current.toString(0).matches("HITAN:\\d+:\\d+'") && !current.toString(0).matches("HISYN:\\d+:\\d+'")) continue;
            iterator.remove();
        }
    }

    public Map<String, String> interpolate(String templateResourcePath, HbciSandboxContext context) {
        String value;
        String key;
        ScaContext accs;
        String templateToParse = Resources.asByteSource((URL)Resources.getResource((String)templateResourcePath)).asCharSource(StandardCharsets.UTF_8).read();
        Map template = (Map)this.mapper.readValue(templateToParse, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List mt940TransactionLoop = this.extractAndRemoveFromTemplateTransactionLoopMt940Entries(template);
        List accountLoop = this.extractAndRemoveFromTemplateAccountLoopEntries(template);
        List scaLoop = this.extractAndRemoveFromTemplateScaLoopEntries(template);
        HashMap<String, String> result = new HashMap<String, String>();
        AccountsContext staticCtx = new AccountsContext(0, context);
        for (Map.Entry entry : template.entrySet()) {
            String key2 = (String)entry.getKey();
            String value2 = (String)entry.getValue();
            key2 = this.doInterpolate(key2, (HbciSandboxContext)new AccountsContext(0, (HbciSandboxContext)staticCtx));
            value2 = this.doInterpolate(value2, (HbciSandboxContext)new AccountsContext(0, (HbciSandboxContext)staticCtx));
            result.put(key2, value2);
        }
        for (Entry entry : scaLoop) {
            for (int scaPos = 0; scaPos < staticCtx.getUser().getScaMethodsAvailable().size(); ++scaPos) {
                accs = new ScaContext(scaPos, (HbciSandboxContext)staticCtx);
                key = this.doInterpolate(entry.getKey(), (HbciSandboxContext)accs);
                value = this.doInterpolate(entry.getValue(), (HbciSandboxContext)accs);
                result.put(key, value);
            }
        }
        for (Entry entry : accountLoop) {
            for (int accPos = 0; accPos < staticCtx.getUser().getAccounts().size(); ++accPos) {
                accs = new AccountsContext(accPos, (HbciSandboxContext)staticCtx);
                key = this.doInterpolate(entry.getKey(), (HbciSandboxContext)accs);
                value = this.doInterpolate(entry.getValue(), (HbciSandboxContext)accs);
                result.put(key, value);
            }
        }
        this.interpolateMT940TransactionsIfNeeded(mt940TransactionLoop, result, staticCtx);
        return result;
    }

    private void interpolateMT940TransactionsIfNeeded(List<Entry> mt940TransactionLoop, Map<String, String> result, AccountsContext staticCtx) {
        for (Entry entry : mt940TransactionLoop) {
            int accPos = JsonTemplateInterpolation.getAccountPosForTransactions((User)staticCtx.getUser(), (HbciSandboxContext)staticCtx);
            Account acc = (Account)staticCtx.getUser().getAccounts().get(accPos);
            List transactions = staticCtx.getUser().getTransactions().stream().filter(it -> it.getFrom().contains(acc.getNumber())).collect(Collectors.toList());
            this.processPaymentsThatAreTransactionsNow(staticCtx, acc, transactions);
            if (transactions.isEmpty()) {
                TransactionsContext txns = new TransactionsContext(0, (HbciSandboxContext)staticCtx, accPos, 0, transactions);
                result.put(entry.getKey(), this.interpolateTransactions(":20:STARTUMS\n:21:NONREF\n:25:${ctx.getBank().getBlz()}/${ctx.getTransactionsAccount().getNumber()}", (AccountsContext)txns));
                continue;
            }
            String initialValue = entry.getValue();
            StringBuilder value = new StringBuilder();
            for (int txnPos = 0; txnPos < transactions.size(); ++txnPos) {
                TransactionsContext txns = new TransactionsContext(0, (HbciSandboxContext)staticCtx, accPos, txnPos, transactions);
                value.append(this.interpolateTransactions(initialValue, (AccountsContext)txns));
            }
            result.put(entry.getKey(), value.toString());
        }
    }

    private void processPaymentsThatAreTransactionsNow(AccountsContext staticCtx, Account acc, List<Transaction> transactions) {
        BigDecimal balance = acc.getBalance();
        List payments = this.paymentRepository.findByOwnerLoginAndStatusInOrderByCreatedAtDesc(staticCtx.getUser().getLogin(), (Set)ImmutableSet.of((Object)PaymentStatus.ACSC)).stream().filter(it -> it.getDeduceFrom().endsWith(acc.getNumber()) || it.getSendTo().endsWith(acc.getNumber())).collect(Collectors.toList());
        for (HbciSandboxPayment payment : payments) {
            Transaction transaction = payment.toTransaction(acc.getNumber(), balance);
            balance = new BigDecimal(transaction.getBalanceAfter());
            transactions.add(transaction);
        }
    }

    private String interpolateTransactions(String template, AccountsContext context) {
        return this.doInterpolate(template.replaceAll("\\$\\{mt940Begin}", "").replaceAll("\\$\\{mt940End}", ""), (HbciSandboxContext)context);
    }

    private String doInterpolate(String template, HbciSandboxContext context) {
        Matcher target = this.interpolationTarget.matcher(template);
        StringBuffer result = new StringBuffer();
        while (target.find()) {
            String expression = target.group(2);
            String parsed = this.parseExpression(expression, context);
            target.appendReplacement(result, parsed);
        }
        target.appendTail(result);
        return result.toString();
    }

    private List<Entry> extractAndRemoveFromTemplateAccountLoopEntries(Map<String, String> template) {
        ArrayList<Entry> accountLoop = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : template.entrySet()) {
            if (!this.isLoopAccountsExpression(entry.getKey()) && !this.isLoopAccountsExpression(entry.getValue())) continue;
            accountLoop.add(new Entry(entry.getKey(), entry.getValue()));
        }
        accountLoop.forEach(it -> template.remove(it.getKey()));
        return accountLoop;
    }

    private List<Entry> extractAndRemoveFromTemplateScaLoopEntries(Map<String, String> template) {
        ArrayList<Entry> scaLoop = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : template.entrySet()) {
            if (!this.isLoopScaExpression(entry.getKey())) continue;
            scaLoop.add(new Entry(entry.getKey(), entry.getValue()));
        }
        scaLoop.forEach(it -> template.remove(it.getKey()));
        return scaLoop;
    }

    private boolean isLoopAccountsExpression(String expression) {
        return this.loopAccounts.matcher(expression).find();
    }

    private boolean isLoopScaExpression(String expression) {
        return this.loopSca.matcher(expression).find();
    }

    private List<Entry> extractAndRemoveFromTemplateTransactionLoopMt940Entries(Map<String, String> template) {
        ArrayList<Entry> transactionLoop = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : template.entrySet()) {
            if (!this.isLoopTransactionsMT940Expression(entry.getValue())) continue;
            transactionLoop.add(new Entry(entry.getKey(), entry.getValue()));
        }
        transactionLoop.forEach(it -> template.remove(it.getKey()));
        return transactionLoop;
    }

    private boolean isLoopTransactionsMT940Expression(String expression) {
        return this.mt940LoopTransactions.matcher(expression).find();
    }

    private String parseExpression(String expression, HbciSandboxContext context) {
        String result;
        String prefix = "";
        if (expression.startsWith("_")) {
            prefix = "_";
            expression = expression.substring(1);
        }
        if (null != (result = this.doParse("#{" + expression + "}", context))) {
            Long asInt = Longs.tryParse((String)result);
            if (!"".equals(prefix) && null != asInt && 1L == asInt) {
                return "";
            }
        }
        return prefix + result;
    }

    private String doParse(String expression, HbciSandboxContext context) {
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext parseContext = new StandardEvaluationContext((Object)new SpelCtx(context));
        return (String)parser.parseExpression(expression, (ParserContext)new TemplateParserContext()).getValue((EvaluationContext)parseContext, String.class);
    }

    private static int getAccountPosForTransactions(User user, HbciSandboxContext context) {
        String accNumber = context.getAccountNumberRequestedBeforeSca();
        if (null == accNumber) {
            String accKey = context.getRequest().getData().keySet().stream().filter(it -> it.matches("GV\\.KUmsZeit\\d+\\.KTV\\.number")).findFirst().orElseThrow(() -> new IllegalStateException("No account number for transaction list provided in request"));
            accNumber = (String)context.getRequest().getData().get(accKey);
        }
        for (int pos = 0; pos < user.getAccounts().size(); ++pos) {
            if (!((Account)user.getAccounts().get(pos)).getNumber().equals(accNumber)) continue;
            return pos;
        }
        throw new IllegalStateException(String.format("No account %s available for current user %s", accNumber, user.getLogin()));
    }

    @ConstructorProperties(value={"mapper", "paymentRepository"})
    @Generated
    public JsonTemplateInterpolation(ObjectMapper mapper, HbciSandboxPaymentRepository paymentRepository) {
        this.mapper = mapper;
        this.paymentRepository = paymentRepository;
    }
}

