/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.context;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.Bank;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.User;
import de.adorsys.opba.protocol.sandbox.hbci.domain.HbciSandboxPayment;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;

public class HbciSandboxContext {
    private static final Pattern PIN = Pattern.compile("SigTail(_\\d+)*\\.UserSig(_\\d+)*\\.pin");
    private static final Pattern TAN = Pattern.compile("SigTail(_\\d+)*\\.UserSig(_\\d+)*\\.tan");
    private static final String BLZ = "Idn.KIK.blz";
    private static final String LOGIN = "Idn.customerid";
    private Request request;
    private Bank bank;
    private User user;
    private String accountNumberRequestedBeforeSca;
    private String referencedScaMethodId;
    private String paymentId;
    private String response;
    private boolean cryptNeeded;
    private String secCheckRef;
    private String dialogId;
    private String userId;
    private String sysId;
    private String orderReference;
    @JsonIgnore
    private HbciSandboxPayment payment;

    @JsonIgnore
    public Operation getRequestOperation() {
        return this.request.getOperation();
    }

    @JsonIgnore
    public Map<String, String> getRequestData() {
        return this.request.getData();
    }

    @JsonIgnore
    public boolean isPinOk() {
        if (null == this.getUser()) {
            return false;
        }
        return this.getUser().getPin().equals(this.getRequestPin());
    }

    @JsonIgnore
    public boolean isTanOk() {
        if (null == this.getUser()) {
            return false;
        }
        return this.getUser().getTan().equals(this.getRequestTan());
    }

    @JsonIgnore
    public boolean isTanEmpty() {
        if (null == this.getUser()) {
            return true;
        }
        return Strings.isNullOrEmpty((String)this.getRequestTan());
    }

    @JsonIgnore
    public String getRequestPin() {
        if (null == this.request || null == this.getRequestData()) {
            return null;
        }
        return this.getRequestData().entrySet().stream().filter(it -> PIN.matcher((CharSequence)it.getKey()).find()).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @JsonIgnore
    public String getRequestTan() {
        if (null == this.request || null == this.getRequestData()) {
            return null;
        }
        return this.getRequestData().entrySet().stream().filter(it -> TAN.matcher((CharSequence)it.getKey()).find()).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    @JsonIgnore
    public String getRequestDataRegex(String regex) {
        return this.getRequest().getDataRegex(regex);
    }

    @JsonIgnore
    public String getRequestBankBlz() {
        return (String)this.getRequestData().get(BLZ);
    }

    @JsonIgnore
    public String getRequestUserLogin() {
        return (String)this.getRequestData().get(LOGIN);
    }

    @Generated
    public HbciSandboxContext() {
    }

    @Generated
    public Request getRequest() {
        return this.request;
    }

    @Generated
    public Bank getBank() {
        return this.bank;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public String getAccountNumberRequestedBeforeSca() {
        return this.accountNumberRequestedBeforeSca;
    }

    @Generated
    public String getReferencedScaMethodId() {
        return this.referencedScaMethodId;
    }

    @Generated
    public String getPaymentId() {
        return this.paymentId;
    }

    @Generated
    public String getResponse() {
        return this.response;
    }

    @Generated
    public boolean isCryptNeeded() {
        return this.cryptNeeded;
    }

    @Generated
    public String getSecCheckRef() {
        return this.secCheckRef;
    }

    @Generated
    public String getDialogId() {
        return this.dialogId;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getSysId() {
        return this.sysId;
    }

    @Generated
    public String getOrderReference() {
        return this.orderReference;
    }

    @Generated
    public HbciSandboxPayment getPayment() {
        return this.payment;
    }

    @Generated
    public void setRequest(Request request) {
        this.request = request;
    }

    @Generated
    public void setBank(Bank bank) {
        this.bank = bank;
    }

    @Generated
    public void setUser(User user) {
        this.user = user;
    }

    @Generated
    public void setAccountNumberRequestedBeforeSca(String accountNumberRequestedBeforeSca) {
        this.accountNumberRequestedBeforeSca = accountNumberRequestedBeforeSca;
    }

    @Generated
    public void setReferencedScaMethodId(String referencedScaMethodId) {
        this.referencedScaMethodId = referencedScaMethodId;
    }

    @Generated
    public void setPaymentId(String paymentId) {
        this.paymentId = paymentId;
    }

    @Generated
    public void setResponse(String response) {
        this.response = response;
    }

    @Generated
    public void setCryptNeeded(boolean cryptNeeded) {
        this.cryptNeeded = cryptNeeded;
    }

    @Generated
    public void setSecCheckRef(String secCheckRef) {
        this.secCheckRef = secCheckRef;
    }

    @Generated
    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    @Generated
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @Generated
    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    @Generated
    public void setOrderReference(String orderReference) {
        this.orderReference = orderReference;
    }

    @Generated
    public void setPayment(HbciSandboxPayment payment) {
        this.payment = payment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HbciSandboxContext)) {
            return false;
        }
        HbciSandboxContext other = (HbciSandboxContext)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Bank this$bank = this.getBank();
        Bank other$bank = other.getBank();
        if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
            return false;
        }
        User this$user = this.getUser();
        User other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$accountNumberRequestedBeforeSca = this.getAccountNumberRequestedBeforeSca();
        String other$accountNumberRequestedBeforeSca = other.getAccountNumberRequestedBeforeSca();
        if (this$accountNumberRequestedBeforeSca == null ? other$accountNumberRequestedBeforeSca != null : !this$accountNumberRequestedBeforeSca.equals(other$accountNumberRequestedBeforeSca)) {
            return false;
        }
        String this$referencedScaMethodId = this.getReferencedScaMethodId();
        String other$referencedScaMethodId = other.getReferencedScaMethodId();
        if (this$referencedScaMethodId == null ? other$referencedScaMethodId != null : !this$referencedScaMethodId.equals(other$referencedScaMethodId)) {
            return false;
        }
        String this$paymentId = this.getPaymentId();
        String other$paymentId = other.getPaymentId();
        if (this$paymentId == null ? other$paymentId != null : !this$paymentId.equals(other$paymentId)) {
            return false;
        }
        String this$response = this.getResponse();
        String other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        if (this.isCryptNeeded() != other.isCryptNeeded()) {
            return false;
        }
        String this$secCheckRef = this.getSecCheckRef();
        String other$secCheckRef = other.getSecCheckRef();
        if (this$secCheckRef == null ? other$secCheckRef != null : !this$secCheckRef.equals(other$secCheckRef)) {
            return false;
        }
        String this$dialogId = this.getDialogId();
        String other$dialogId = other.getDialogId();
        if (this$dialogId == null ? other$dialogId != null : !this$dialogId.equals(other$dialogId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$sysId = this.getSysId();
        String other$sysId = other.getSysId();
        if (this$sysId == null ? other$sysId != null : !this$sysId.equals(other$sysId)) {
            return false;
        }
        String this$orderReference = this.getOrderReference();
        String other$orderReference = other.getOrderReference();
        if (this$orderReference == null ? other$orderReference != null : !this$orderReference.equals(other$orderReference)) {
            return false;
        }
        HbciSandboxPayment this$payment = this.getPayment();
        HbciSandboxPayment other$payment = other.getPayment();
        return !(this$payment == null ? other$payment != null : !this$payment.equals(other$payment));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HbciSandboxContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Bank $bank = this.getBank();
        result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
        User $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $accountNumberRequestedBeforeSca = this.getAccountNumberRequestedBeforeSca();
        result = result * 59 + ($accountNumberRequestedBeforeSca == null ? 43 : $accountNumberRequestedBeforeSca.hashCode());
        String $referencedScaMethodId = this.getReferencedScaMethodId();
        result = result * 59 + ($referencedScaMethodId == null ? 43 : $referencedScaMethodId.hashCode());
        String $paymentId = this.getPaymentId();
        result = result * 59 + ($paymentId == null ? 43 : $paymentId.hashCode());
        String $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        result = result * 59 + (this.isCryptNeeded() ? 79 : 97);
        String $secCheckRef = this.getSecCheckRef();
        result = result * 59 + ($secCheckRef == null ? 43 : $secCheckRef.hashCode());
        String $dialogId = this.getDialogId();
        result = result * 59 + ($dialogId == null ? 43 : $dialogId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $sysId = this.getSysId();
        result = result * 59 + ($sysId == null ? 43 : $sysId.hashCode());
        String $orderReference = this.getOrderReference();
        result = result * 59 + ($orderReference == null ? 43 : $orderReference.hashCode());
        HbciSandboxPayment $payment = this.getPayment();
        result = result * 59 + ($payment == null ? 43 : $payment.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HbciSandboxContext(request=" + this.getRequest() + ", bank=" + this.getBank() + ", user=" + this.getUser() + ", accountNumberRequestedBeforeSca=" + this.getAccountNumberRequestedBeforeSca() + ", referencedScaMethodId=" + this.getReferencedScaMethodId() + ", paymentId=" + this.getPaymentId() + ", response=" + this.getResponse() + ", cryptNeeded=" + this.isCryptNeeded() + ", secCheckRef=" + this.getSecCheckRef() + ", dialogId=" + this.getDialogId() + ", userId=" + this.getUserId() + ", sysId=" + this.getSysId() + ", orderReference=" + this.getOrderReference() + ", payment=" + this.getPayment() + ")";
    }
}

