/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.config.dto;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Currency;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.hibernate.validator.constraints.Length;
import org.iban4j.Iban;
import org.springframework.validation.annotation.Validated;

@Validated
public class Transaction {
    @NotBlank
    private String from;
    @NotBlank
    private String to;
    @NotBlank
    private String statementNumber;
    @NotBlank
    private String amount;
    @NotBlank
    private String balanceBefore;
    @NotBlank
    private String balanceAfter;
    @NotBlank
    @Length(max=70)
    private @NotBlank @Length(max=70) String toName;
    @NotBlank
    @Length(max=400)
    private @NotBlank @Length(max=400) String purpose;
    @NotNull
    private Currency currency;
    @NotNull
    private String date;

    public String getDay() {
        return "" + LocalDateTime.parse(this.date).getDayOfYear();
    }

    public String getShortDate() {
        return LocalDateTime.parse(this.date).format(DateTimeFormatter.ofPattern("yyMMdd"));
    }

    public String getShortEntryDate() {
        return LocalDateTime.parse(this.date).format(DateTimeFormatter.ofPattern("MMdd"));
    }

    public String getAmountWithComma() {
        if (this.amount.contains(".")) {
            return this.amount.replace(".", ",");
        }
        return this.amount + ",";
    }

    public String getTargetBlz() {
        return Iban.valueOf((String)this.to).getBankCode();
    }

    public String getTargetAccountNumber() {
        return Iban.valueOf((String)this.to).getAccountNumber();
    }

    @Generated
    public Transaction() {
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getTo() {
        return this.to;
    }

    @Generated
    public String getStatementNumber() {
        return this.statementNumber;
    }

    @Generated
    public String getAmount() {
        return this.amount;
    }

    @Generated
    public String getBalanceBefore() {
        return this.balanceBefore;
    }

    @Generated
    public String getBalanceAfter() {
        return this.balanceAfter;
    }

    @Generated
    public String getToName() {
        return this.toName;
    }

    @Generated
    public String getPurpose() {
        return this.purpose;
    }

    @Generated
    public Currency getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDate() {
        return this.date;
    }

    @Generated
    public void setFrom(String from) {
        this.from = from;
    }

    @Generated
    public void setTo(String to) {
        this.to = to;
    }

    @Generated
    public void setStatementNumber(String statementNumber) {
        this.statementNumber = statementNumber;
    }

    @Generated
    public void setAmount(String amount) {
        this.amount = amount;
    }

    @Generated
    public void setBalanceBefore(String balanceBefore) {
        this.balanceBefore = balanceBefore;
    }

    @Generated
    public void setBalanceAfter(String balanceAfter) {
        this.balanceAfter = balanceAfter;
    }

    @Generated
    public void setToName(String toName) {
        this.toName = toName;
    }

    @Generated
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    @Generated
    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Generated
    public void setDate(String date) {
        this.date = date;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$statementNumber = this.getStatementNumber();
        String other$statementNumber = other.getStatementNumber();
        if (this$statementNumber == null ? other$statementNumber != null : !this$statementNumber.equals(other$statementNumber)) {
            return false;
        }
        String this$amount = this.getAmount();
        String other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
            return false;
        }
        String this$balanceBefore = this.getBalanceBefore();
        String other$balanceBefore = other.getBalanceBefore();
        if (this$balanceBefore == null ? other$balanceBefore != null : !this$balanceBefore.equals(other$balanceBefore)) {
            return false;
        }
        String this$balanceAfter = this.getBalanceAfter();
        String other$balanceAfter = other.getBalanceAfter();
        if (this$balanceAfter == null ? other$balanceAfter != null : !this$balanceAfter.equals(other$balanceAfter)) {
            return false;
        }
        String this$toName = this.getToName();
        String other$toName = other.getToName();
        if (this$toName == null ? other$toName != null : !this$toName.equals(other$toName)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        Currency this$currency = this.getCurrency();
        Currency other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $statementNumber = this.getStatementNumber();
        result = result * 59 + ($statementNumber == null ? 43 : $statementNumber.hashCode());
        String $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
        String $balanceBefore = this.getBalanceBefore();
        result = result * 59 + ($balanceBefore == null ? 43 : $balanceBefore.hashCode());
        String $balanceAfter = this.getBalanceAfter();
        result = result * 59 + ($balanceAfter == null ? 43 : $balanceAfter.hashCode());
        String $toName = this.getToName();
        result = result * 59 + ($toName == null ? 43 : $toName.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
        Currency $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Transaction(from=" + this.getFrom() + ", to=" + this.getTo() + ", statementNumber=" + this.getStatementNumber() + ", amount=" + this.getAmount() + ", balanceBefore=" + this.getBalanceBefore() + ", balanceAfter=" + this.getBalanceAfter() + ", toName=" + this.getToName() + ", purpose=" + this.getPurpose() + ", currency=" + this.getCurrency() + ", date=" + this.getDate() + ")";
    }
}

