/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.RequestStatusUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.authenticated.nonauthorized.AuthenticatedDialogInitSca;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.SyntaxElement;

/*
 * Exception performing whole class analysis ignored.
 */
public enum Operation {
    CUSTOM_MSG("CustomMsg", Operation::typeMatch),
    DIALOG_INIT_ANON("DialogInitAnon", Operation::typeMatch),
    DIALOG_INIT_SCA_TAN_2_STEP("DialogInitScaTAN", Operation::isScaInit),
    DIALOG_INIT_SCA("DialogInitSCA", Operation::typeMatchAndNotAfterSca),
    DIALOG_INIT("DialogInit", Operation::typeMatch),
    SYNCH("Synch", Operation::typeMatch),
    DIALOG_END("DialogEnd", Operation::typeMatch),
    ANY("*", Operation::typeMatch);

    private final String typeName;
    private final Function<MatchingContext, Message> is;

    public static Match find(List<Message> matched) {
        return Arrays.stream(Operation.values()).map(it -> {
            Message message = (Message)it.getIs().apply(new MatchingContext(it.getTypeName(), matched));
            return null == message ? null : new Match(it, message);
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unknown operation to match: " + Operation.matchToString((List)matched)));
    }

    private static String matchToString(List<Message> matched) {
        return new ObjectMapper().writeValueAsString(matched);
    }

    private static Message typeMatchAndNotAfterSca(MatchingContext context) {
        Message message = Operation.typeMatch((MatchingContext)context);
        if (null == message) {
            return null;
        }
        if (RequestStatusUtil.isForTransactionListing((Map)message.getData()) || RequestStatusUtil.isForAccountListing((Map)message.getData()) || RequestStatusUtil.isForPayment((Map)message.getData()) || RequestStatusUtil.isForPaymentStatus((Map)message.getData())) {
            return null;
        }
        return message;
    }

    private static Message typeMatch(MatchingContext context) {
        return context.getMatched().stream().filter(it -> it.getType().equals(context.getTypeName())).findFirst().orElse(null);
    }

    private static Message isScaInit(MatchingContext context) {
        Set available;
        ImmutableSet acceptableTypes = ImmutableSet.of((Object)Operation.DIALOG_INIT.typeName, (Object)Operation.CUSTOM_MSG.typeName);
        if (Sets.intersection((Set)acceptableTypes, available = context.getMatched().stream().map(SyntaxElement::getType).collect(Collectors.toSet())).isEmpty()) {
            return null;
        }
        return context.getMatched().stream().filter(it -> AuthenticatedDialogInitSca.canHandle((Map)it.getData())).findFirst().orElse(null);
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public Function<MatchingContext, Message> getIs() {
        return this.is;
    }

    @ConstructorProperties(value={"typeName", "is"})
    @Generated
    private Operation(String typeName, Function<MatchingContext, Message> is) {
        this.typeName = typeName;
        this.is = is;
    }
}

