/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.authenticated.nonauthorized;

import com.google.common.hash.Hashing;
import de.adorsys.opba.protocol.sandbox.hbci.config.dto.SensitiveAuthLevel;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.MapRegexUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.RequestStatusUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.TemplateBasedOperationHandler;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.interpolation.JsonTemplateInterpolation;
import de.adorsys.opba.protocol.sandbox.hbci.service.HbciSandboxPaymentService;
import java.util.UUID;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="authenticatedCustomMsg")
public class AuthenticatedCustomMsg
extends TemplateBasedOperationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticatedCustomMsg.class);
    private static final int HASH_BITS = 16;
    private final HbciSandboxPaymentService paymentService;

    public AuthenticatedCustomMsg(JsonTemplateInterpolation interpolation, HbciSandboxPaymentService paymentService) {
        super(interpolation);
        this.paymentService = paymentService;
    }

    @Override
    protected String getTemplatePathAndUpdateCtxIfNeeded(HbciSandboxContext context) {
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.SEPAInfo"))) {
            return context.getBank().getSecurity().getAccounts() == SensitiveAuthLevel.AUTHENTICATED ? "response-templates/authenticated/custom-message-sepa-info.json" : this.getAuthorizationRequiredTemplateOrWrongTanMethod();
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.KUmsZeit"))) {
            return this.handleTransactionList(context);
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.UebSEPA1"))) {
            return this.handlePayment(context);
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.InstantUebSEPA1"))) {
            return this.handleInstantPayment(context);
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.InstantUebSEPAStatus1"))) {
            return this.handlePaymentStatus(context);
        }
        throw new IllegalStateException("Cant't handle message: " + context.getRequestData());
    }

    @Override
    protected Operation handledRequestType() {
        return Operation.CUSTOM_MSG;
    }

    @NotNull
    private String handleTransactionList(HbciSandboxContext context) {
        if (context.getBank().getSecurity().getTransactions() == SensitiveAuthLevel.AUTHENTICATED) {
            return "response-templates/authenticated/custom-message-konto-mt940.json";
        }
        if (RequestStatusUtil.isForTransactionListing(context.getRequestData())) {
            context.setAccountNumberRequestedBeforeSca(MapRegexUtil.getDataRegex(context.getRequestData(), "TAN2Step6\\.OrderAccount\\.number"));
        }
        return this.getAuthorizationRequiredTemplateOrWrongTanMethod();
    }

    @NotNull
    private String handlePayment(HbciSandboxContext context) {
        if (context.getBank().getSecurity().getPayment() == SensitiveAuthLevel.AUTHENTICATED) {
            this.paymentService.createPaymentIfNeededAndPossibleFromContext(context);
            return "response-templates/authorized/custom-message-payment-response.json";
        }
        if (RequestStatusUtil.isForPayment(context.getRequestData())) {
            context.setAccountNumberRequestedBeforeSca(MapRegexUtil.getDataRegex(context.getRequestData(), "TAN2Step6\\.OrderAccount\\.number"));
            this.setOrderReference(context);
            this.paymentService.createPayment(context, false);
        }
        return "response-templates/authenticated/custom-message-authorization-required-payment.json";
    }

    @NotNull
    private String handleInstantPayment(HbciSandboxContext context) {
        if (context.getBank().getSecurity().getPayment() == SensitiveAuthLevel.AUTHENTICATED) {
            this.paymentService.createPaymentIfNeededAndPossibleFromContext(context);
            return "response-templates/authorized/custom-message-payment-response.json";
        }
        if (RequestStatusUtil.isForInstantPayment(context.getRequestData())) {
            context.setAccountNumberRequestedBeforeSca(MapRegexUtil.getDataRegex(context.getRequestData(), "GV\\.InstantUebSEPA1\\.My\\.iban"));
            this.setOrderReference(context);
            this.paymentService.createPayment(context, true);
        }
        return "response-templates/authenticated/custom-message-authorization-required-payment.json";
    }

    @NotNull
    private String handlePaymentStatus(HbciSandboxContext context) {
        String paymentId = MapRegexUtil.getDataRegex(context.getRequestData(), "GV\\.InstantUebSEPAStatus\\d\\.orderid");
        if (context.getBank().getSecurity().getPaymentStatus() == SensitiveAuthLevel.AUTHENTICATED) {
            this.paymentService.paymentFromDatabaseToContext(context, paymentId);
            return "response-templates/authenticated/custom-message-payment-status.json";
        }
        if (RequestStatusUtil.isForPaymentStatus(context.getRequestData())) {
            context.setPaymentId(paymentId);
        }
        return "response-templates/authenticated/custom-message-authorization-required-payment-status.json";
    }

    private String getAuthorizationRequiredTemplateOrWrongTanMethod() {
        return "response-templates/authenticated/custom-message-authorization-required.json";
    }

    private void setOrderReference(HbciSandboxContext context) {
        UUID orderRef = UUID.randomUUID();
        context.setOrderReference(Hashing.goodFastHash((int)16).hashLong(orderRef.getLeastSignificantBits()).toString() + "." + Hashing.goodFastHash((int)16).hashLong(orderRef.getMostSignificantBits()).toString());
    }
}

