/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol.authenticated.authorized;

import de.adorsys.opba.protocol.sandbox.hbci.protocol.MapRegexUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.RequestStatusUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.TemplateBasedOperationHandler;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.interpolation.JsonTemplateInterpolation;
import de.adorsys.opba.protocol.sandbox.hbci.service.HbciSandboxPaymentService;
import org.springframework.stereotype.Service;

@Service(value="authorizedCustomMsg")
public class AuthorizedCustomMsg
extends TemplateBasedOperationHandler {
    private final HbciSandboxPaymentService paymentService;

    public AuthorizedCustomMsg(JsonTemplateInterpolation interpolation, HbciSandboxPaymentService paymentService) {
        super(interpolation);
        this.paymentService = paymentService;
    }

    @Override
    protected String getTemplatePathAndUpdateCtxIfNeeded(HbciSandboxContext context) {
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.SEPAInfo")) || RequestStatusUtil.isForAccountListing(context.getRequestData())) {
            return "response-templates/authorized/custom-message-sepa-info.json";
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.KUmsZeit")) || RequestStatusUtil.isForTransactionListing(context.getRequestData())) {
            return "response-templates/authorized/custom-message-konto-mt940.json";
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.UebSEPA1") || it.startsWith("GV.InstantUebSEPA1")) || RequestStatusUtil.isForPayment(context.getRequestData()) || RequestStatusUtil.isForInstantPayment(context.getRequestData())) {
            this.paymentService.createPaymentIfNeededAndPossibleFromContext(context);
            this.paymentService.acceptPayment(context);
            return "response-templates/authorized/custom-message-payment-response.json";
        }
        if (context.getRequestData().keySet().stream().anyMatch(it -> it.startsWith("GV.InstantUebSEPAStatus1"))) {
            String paymentId = MapRegexUtil.getDataRegex(context.getRequestData(), "GV\\.InstantUebSEPAStatus\\d\\.orderid");
            this.paymentService.paymentFromDatabaseToContext(context, paymentId);
            return "response-templates/authorized/custom-message-payment-status.json";
        }
        throw new IllegalStateException("Cant't handle message: " + context.getRequestData());
    }

    @Override
    protected Operation handledRequestType() {
        return Operation.CUSTOM_MSG;
    }
}

