/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol;

import de.adorsys.opba.protocol.sandbox.hbci.protocol.Operation;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.context.HbciSandboxContext;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.JavaDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OperationHandler
implements JavaDelegate {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public void execute(DelegateExecution execution) {
        HbciSandboxContext context = (HbciSandboxContext)execution.getVariable("CONTEXT");
        Operation handled = this.handledRequestType();
        this.log.info("Handling request of type {} with expected type {}", (Object)context.getRequestOperation(), (Object)handled);
        if (!this.usesCustomHandlingAndHandles(context) && Operation.ANY != handled && context.getRequestOperation() != this.handledRequestType()) {
            throw new IllegalStateException(String.format("Can't handle request: %s, expected is %s", new Object[]{context.getRequestOperation(), this.handledRequestType()}));
        }
        HbciSandboxContext updated = this.doExecute(execution, context);
        execution.setVariable("CONTEXT", (Object)updated);
    }

    protected abstract HbciSandboxContext doExecute(DelegateExecution var1, HbciSandboxContext var2);

    protected abstract Operation handledRequestType();

    protected boolean usesCustomHandlingAndHandles(HbciSandboxContext context) {
        return false;
    }
}

