/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.opba.protocol.sandbox.hbci.protocol;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.RequestStatusUtil;
import de.adorsys.opba.protocol.sandbox.hbci.protocol.authenticated.nonauthorized.AuthenticatedDialogInitSca;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.kapott.hbci.protocol.Message;
import org.kapott.hbci.protocol.SyntaxElement;

public enum Operation {
    CUSTOM_MSG("CustomMsg", Operation::typeMatch),
    DIALOG_INIT_ANON("DialogInitAnon", Operation::typeMatch),
    DIALOG_INIT_SCA_TAN_2_STEP("DialogInitScaTAN", Operation::isScaInit),
    DIALOG_INIT_SCA("DialogInitSCA", Operation::typeMatchAndNotAfterSca),
    DIALOG_INIT("DialogInit", Operation::typeMatch),
    SYNCH("Synch", Operation::typeMatch),
    DIALOG_END("DialogEnd", Operation::typeMatch),
    ANY("*", Operation::typeMatch);

    private final String typeName;
    private final Function<MatchingContext, Message> is;

    public static Match find(List<Message> matched) {
        return Arrays.stream(Operation.values()).map(it -> {
            Message message = it.getIs().apply(new MatchingContext(it.getTypeName(), matched));
            return null == message ? null : new Match((Operation)((Object)it), message);
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Unknown operation to match: " + Operation.matchToString(matched)));
    }

    private static String matchToString(List<Message> matched) {
        return new ObjectMapper().writeValueAsString(matched);
    }

    private static Message typeMatchAndNotAfterSca(MatchingContext context) {
        Message message = Operation.typeMatch(context);
        if (null == message) {
            return null;
        }
        if (RequestStatusUtil.isForTransactionListing(message.getData()) || RequestStatusUtil.isForAccountListing(message.getData()) || RequestStatusUtil.isForPayment(message.getData()) || RequestStatusUtil.isForPaymentStatus(message.getData())) {
            return null;
        }
        return message;
    }

    private static Message typeMatch(MatchingContext context) {
        return context.getMatched().stream().filter(it -> it.getType().equals(context.getTypeName())).findFirst().orElse(null);
    }

    private static Message isScaInit(MatchingContext context) {
        Set available;
        ImmutableSet acceptableTypes = ImmutableSet.of((Object)Operation.DIALOG_INIT.typeName, (Object)Operation.CUSTOM_MSG.typeName);
        if (Sets.intersection((Set)acceptableTypes, available = context.getMatched().stream().map(SyntaxElement::getType).collect(Collectors.toSet())).isEmpty()) {
            return null;
        }
        return context.getMatched().stream().filter(it -> AuthenticatedDialogInitSca.canHandle(it.getData())).findFirst().orElse(null);
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Generated
    public Function<MatchingContext, Message> getIs() {
        return this.is;
    }

    @ConstructorProperties(value={"typeName", "is"})
    @Generated
    private Operation(String typeName, Function<MatchingContext, Message> is) {
        this.typeName = typeName;
        this.is = is;
    }

    public static class Match {
        private final Operation operation;
        private final Message message;

        @ConstructorProperties(value={"operation", "message"})
        @Generated
        public Match(Operation operation, Message message) {
            this.operation = operation;
            this.message = message;
        }

        @Generated
        public Operation getOperation() {
            return this.operation;
        }

        @Generated
        public Message getMessage() {
            return this.message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Match)) {
                return false;
            }
            Match other = (Match)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Operation this$operation = this.getOperation();
            Operation other$operation = other.getOperation();
            if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
                return false;
            }
            Message this$message = this.getMessage();
            Message other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Match;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Operation $operation = this.getOperation();
            result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
            Message $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Operation.Match(operation=" + (Object)((Object)this.getOperation()) + ", message=" + this.getMessage() + ")";
        }
    }

    private static class MatchingContext {
        private final String typeName;
        private final List<Message> matched;

        @ConstructorProperties(value={"typeName", "matched"})
        @Generated
        public MatchingContext(String typeName, List<Message> matched) {
            this.typeName = typeName;
            this.matched = matched;
        }

        @Generated
        public String getTypeName() {
            return this.typeName;
        }

        @Generated
        public List<Message> getMatched() {
            return this.matched;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MatchingContext)) {
                return false;
            }
            MatchingContext other = (MatchingContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
                return false;
            }
            List<Message> this$matched = this.getMatched();
            List<Message> other$matched = other.getMatched();
            return !(this$matched == null ? other$matched != null : !((Object)this$matched).equals(other$matched));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MatchingContext;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            List<Message> $matched = this.getMatched();
            result = result * 59 + ($matched == null ? 43 : ((Object)$matched).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Operation.MatchingContext(typeName=" + this.getTypeName() + ", matched=" + this.getMatched() + ")";
        }
    }
}

